/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import java.beans.PropertyVetoException;
import java.util.List;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

public interface JvmOptionBag
extends ConfigBeanProxy {
    @Element
    public List<String> getJvmOptions();

    public void setJvmOptions(List<String> var1) throws PropertyVetoException;

    @DuckTyped
    public int getXmxMegs();

    @DuckTyped
    public int getXmsMegs();

    @DuckTyped
    public boolean contains(String var1);

    @DuckTyped
    public String getStartingWith(String var1);

    public static class Duck {
        public static int getXmxMegs(JvmOptionBag me) {
            return Duck.getMemory(me, "-Xmx");
        }

        public static int getXmsMegs(JvmOptionBag me) {
            return Duck.getMemory(me, "-Xms");
        }

        private static int getMemory(JvmOptionBag me, String which) {
            List<String> options = me.getJvmOptions();
            for (String opt : options) {
                if (opt.indexOf(which) < 0) continue;
                return Duck.toMeg(opt, which);
            }
            return -1;
        }

        public static int toMeg(String whole, String which) {
            String second = whole.substring(which.length());
            char unit = second.charAt(second.length() - 1);
            try {
                if (unit == 'g' || unit == 'G') {
                    return Integer.parseInt(second.substring(0, second.length() - 1)) * 1024;
                }
                if (unit == 'm' || unit == 'M') {
                    return Integer.parseInt(second.substring(0, second.length() - 1));
                }
                if (unit == 'k' || unit == 'K') {
                    return Integer.parseInt(second.substring(0, second.length() - 1)) / 1024;
                }
                return Integer.parseInt(second) / 0x100000;
            }
            catch (NumberFormatException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public static boolean contains(JvmOptionBag me, String opt) {
            return me.getJvmOptions().contains(opt);
        }

        public static String getStartingWith(JvmOptionBag me, String start) {
            List<String> opts = me.getJvmOptions();
            for (String opt : opts) {
                if (!opt.startsWith(start)) continue;
                return opt;
            }
            return null;
        }
    }
}

