/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-connector-connection-pool")
@PerLookup
@I18n(value="delete.connector.connection.pool")
public class DeleteConnectorConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorConnectionPool.class);
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Param(optional=true, defaultValue="false")
    private Boolean cascade;
    @Param(name="poolname", primary=true)
    private String poolname;
    @Inject
    private Domain domain;
    @Inject
    private IterableProvider<Server> servers;
    @Inject
    private IterableProvider<Cluster> clusters;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.poolname == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.noJndiName", "No id defined for connector connection pool."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorConnectionPool.class, (String)this.poolname) == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            Object obj = this.deleteAssociatedResources((Iterable<Server>)this.servers, (Iterable<Cluster>)this.clusters, this.domain.getResources(), this.cascade, this.poolname);
            if (obj instanceof Integer && (Integer)obj == 1) {
                report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.pool_in_use", "Some connector resources are referencing connection pool {0}. Use 'cascade' option to delete them as well.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorConnectionPool cp = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName((Resources)DeleteConnectorConnectionPool.this.domain.getResources(), ConnectorConnectionPool.class, (String)DeleteConnectorConnectionPool.this.poolname);
                    if (cp != null) {
                        return param.getResources().remove(cp);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.domain.getResources()) == null) {
                report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(DeleteConnectorConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-connector-connection-pool", tfe);
            report.setMessage(tfe.getMessage() != null ? tfe.getLocalizedMessage() : localStrings.getLocalString("delete.connector.connection.pool.fail", "Connector connection pool {0} delete failed ", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.success", "Connector connection pool {0} deleted successfully", new Object[]{this.poolname}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private Object deleteAssociatedResources(final Iterable<Server> servers, final Iterable<Cluster> clusters, Resources resources, boolean cascade, final String poolName) throws TransactionFailure {
        if (cascade) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    Collection referringResources = ConnectorsUtil.getResourcesOfPool((Resources)param, (String)poolName);
                    for (BindableResource referringResource : referringResources) {
                        DeleteConnectorConnectionPool.this.deleteServerResourceRefs(servers, referringResource.getJndiName());
                        DeleteConnectorConnectionPool.this.deleteClusterResourceRefs(clusters, referringResource.getJndiName());
                        param.getResources().remove(referringResource);
                    }
                    return true;
                }
            }, (ConfigBeanProxy)resources);
        } else {
            Collection referringResources = ConnectorsUtil.getResourcesOfPool((Resources)resources, (String)poolName);
            if (referringResources.size() > 0) {
                return 1;
            }
        }
        return true;
    }

    private void deleteServerResourceRefs(Iterable<Server> servers, String refName) throws TransactionFailure {
        if (servers != null) {
            for (Server server : servers) {
                server.deleteResourceRef(refName);
            }
        }
    }

    private void deleteClusterResourceRefs(Iterable<Cluster> clusters, String refName) throws TransactionFailure {
        if (clusters != null) {
            for (Cluster cluster : clusters) {
                cluster.deleteResourceRef(refName);
            }
        }
    }
}

