/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.generate.Generator;
import com.sun.faces.generate.GeneratorUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class AbstractGenerator
implements Generator {
    protected static final Map<String, String> TYPE_DEFAULTS = new HashMap<String, String>();
    protected static final Set<String> JAVA_KEYWORDS;

    protected static String capitalize(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    protected static String mangle(String name) {
        if (JAVA_KEYWORDS.contains(name)) {
            return '_' + name;
        }
        return name;
    }

    protected static Map<String, String> options(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            if (!args[i].startsWith("-")) {
                throw new IllegalArgumentException("Invalid option name '" + args[i] + '\'');
            }
            if (i + 1 >= args.length) {
                throw new IllegalArgumentException("Missing value for option '" + args[i] + '\'');
            }
            options.put(args[i], args[i + 1]);
        }
        return options;
    }

    protected static boolean primitive(String type) {
        return GeneratorUtil.convertToPrimitive(type) != null;
    }

    protected static String shortName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            return className.substring(index + 1);
        }
        return className;
    }

    static {
        TYPE_DEFAULTS.put("boolean", "false");
        TYPE_DEFAULTS.put("byte", "Byte.MIN_VALUE");
        TYPE_DEFAULTS.put("char", "Character.MIN_VALUE");
        TYPE_DEFAULTS.put("double", "Double.MIN_VALUE");
        TYPE_DEFAULTS.put("float", "Float.MIN_VALUE");
        TYPE_DEFAULTS.put("int", "Integer.MIN_VALUE");
        TYPE_DEFAULTS.put("long", "Long.MIN_VALUE");
        TYPE_DEFAULTS.put("short", "Short.MIN_VALUE");
        JAVA_KEYWORDS = new HashSet<String>();
        JAVA_KEYWORDS.add("abstract");
        JAVA_KEYWORDS.add("boolean");
        JAVA_KEYWORDS.add("break");
        JAVA_KEYWORDS.add("byte");
        JAVA_KEYWORDS.add("case");
        JAVA_KEYWORDS.add("cast");
        JAVA_KEYWORDS.add("catch");
        JAVA_KEYWORDS.add("char");
        JAVA_KEYWORDS.add("class");
        JAVA_KEYWORDS.add("const");
        JAVA_KEYWORDS.add("continue");
        JAVA_KEYWORDS.add("default");
        JAVA_KEYWORDS.add("do");
        JAVA_KEYWORDS.add("double");
        JAVA_KEYWORDS.add("else");
        JAVA_KEYWORDS.add("enum");
        JAVA_KEYWORDS.add("extends");
        JAVA_KEYWORDS.add("final");
        JAVA_KEYWORDS.add("finally");
        JAVA_KEYWORDS.add("float");
        JAVA_KEYWORDS.add("for");
        JAVA_KEYWORDS.add("future");
        JAVA_KEYWORDS.add("generic");
        JAVA_KEYWORDS.add("goto");
        JAVA_KEYWORDS.add("if");
        JAVA_KEYWORDS.add("implements");
        JAVA_KEYWORDS.add("import");
        JAVA_KEYWORDS.add("inner");
        JAVA_KEYWORDS.add("instanceof");
        JAVA_KEYWORDS.add("int");
        JAVA_KEYWORDS.add("interface");
        JAVA_KEYWORDS.add("long");
        JAVA_KEYWORDS.add("native");
        JAVA_KEYWORDS.add("new");
        JAVA_KEYWORDS.add("null");
        JAVA_KEYWORDS.add("operator");
        JAVA_KEYWORDS.add("outer");
        JAVA_KEYWORDS.add("package");
        JAVA_KEYWORDS.add("private");
        JAVA_KEYWORDS.add("protected");
        JAVA_KEYWORDS.add("public");
        JAVA_KEYWORDS.add("rest");
        JAVA_KEYWORDS.add("return");
        JAVA_KEYWORDS.add("short");
        JAVA_KEYWORDS.add("static");
        JAVA_KEYWORDS.add("strictfp");
        JAVA_KEYWORDS.add("super");
        JAVA_KEYWORDS.add("switch");
        JAVA_KEYWORDS.add("synchronized");
        JAVA_KEYWORDS.add("this");
        JAVA_KEYWORDS.add("throw");
        JAVA_KEYWORDS.add("throws");
        JAVA_KEYWORDS.add("transient");
        JAVA_KEYWORDS.add("try");
        JAVA_KEYWORDS.add("var");
        JAVA_KEYWORDS.add("void");
        JAVA_KEYWORDS.add("volatile");
        JAVA_KEYWORDS.add("while");
    }

    protected static class CodeWriter
    extends BufferedWriter {
        private static final String TAB = "    ";
        private final int TAB_LENGTH = "    ".length();
        private Stack<String> depth = new Stack();
        private String formatString = "";

        public CodeWriter(Writer writer) {
            super(writer);
        }

        public void indent() {
            this.depth.push(TAB);
            this.updateFormatString(this.depth.size());
        }

        public void outdent() {
            this.depth.pop();
            this.updateFormatString(this.depth.size());
        }

        public void fwrite(String str) throws IOException {
            super.write(this.formatString + str);
        }

        public void writePackage(String packageName) throws IOException {
            this.fwrite(new StringBuffer("package ").append(packageName).append(";\n").toString());
        }

        public void writeImport(String fullyQualifiedClassName) throws IOException {
            this.fwrite(new StringBuffer("import ").append(fullyQualifiedClassName).append(";\n").toString());
        }

        public void writePublicClassDeclaration(String className, String extendsClass, String[] implementsClasses, boolean isAbstract, boolean isFinal) throws IOException {
            if (isAbstract && isFinal) {
                throw new IllegalArgumentException("Cannot have a class declaration be both abstract and final.");
            }
            StringBuffer sb = new StringBuffer("public");
            if (isAbstract) {
                sb.append(" abstract");
            }
            if (isFinal) {
                sb.append(" final");
            }
            sb.append(" class ").append(className);
            if (extendsClass != null && extendsClass.length() > 0) {
                sb.append(" extends ").append(extendsClass);
            }
            if (implementsClasses != null && implementsClasses.length > 0) {
                sb.append(" implements ");
                for (int i = 0; i < implementsClasses.length; ++i) {
                    sb.append(implementsClasses[i]);
                    if (i >= implementsClasses.length - 1) continue;
                    sb.append(", ");
                }
            }
            sb.append(" {\n\n");
            this.fwrite(sb.toString());
        }

        public void writeJavadocComment(String str) throws IOException {
            this.fwrite("/**\n");
            String[] tokens = str.split("\r|\n|\t");
            for (int i = 0; i < tokens.length; ++i) {
                this.fwrite(" * ");
                this.write(tokens[i].trim());
                this.write(10);
            }
            this.fwrite(" */\n");
        }

        public void writeLineComment(String str) throws IOException {
            String[] tokens = str.split("\r|\n|\t");
            for (int i = 0; i < tokens.length; ++i) {
                this.fwrite("// ");
                this.write(tokens[i].trim());
                this.write(10);
            }
        }

        public void writeBlockComment(String str) throws IOException {
            this.fwrite("/*\n");
            String[] tokens = str.split("\r|\n|\t");
            for (int i = 0; i < tokens.length; ++i) {
                this.fwrite(" * ");
                this.write(tokens[i].trim());
                this.write(10);
            }
            this.fwrite(" */\n");
        }

        public void writeReadWriteProperty(String propertyName, String type, String defaultValue) throws IOException {
            String iVarName = AbstractGenerator.mangle(propertyName);
            String methodName = AbstractGenerator.capitalize(propertyName);
            this.writeLineComment("PROPERTY: " + propertyName);
            this.fwrite("private " + type + ' ' + iVarName + (defaultValue == null ? ";" : " = " + defaultValue) + '\n');
            this.fwrite("public void set" + methodName + '(' + type + ' ' + iVarName + ") {\n");
            this.indent();
            this.fwrite("this." + iVarName + " = " + iVarName + ";\n");
            this.outdent();
            this.fwrite("}\n\n");
            this.fwrite("public " + type + "get" + methodName + "() {\n");
            this.indent();
            this.fwrite("return this." + iVarName + ";\n");
            this.outdent();
            this.fwrite("}\n\n");
        }

        public void writeReadWriteProperty(String propertyName, String type) throws IOException {
            this.writeReadWriteProperty(propertyName, type, null);
        }

        public void writeReadOnlyProperty(String propertyName, String type, String defaultValue) throws IOException {
            this.writeLineComment("PROPERTY: " + propertyName);
            String iVarName = AbstractGenerator.mangle(propertyName);
            this.fwrite("private " + type + ' ' + iVarName + (defaultValue == null ? ";" : " = " + defaultValue) + '\n');
            this.fwrite("public " + type + "get" + AbstractGenerator.capitalize(propertyName) + "() {\n");
            this.indent();
            this.fwrite("return this." + iVarName + ";\n");
            this.outdent();
            this.fwrite("}\n\n");
        }

        public void writeReadOnlyProperty(String propertyName, String type) throws IOException {
            this.writeReadOnlyProperty(propertyName, type, null);
        }

        public void writeWriteOnlyProperty(String propertyName, String type, String defaultValue) throws IOException {
            this.writeLineComment("PROPERTY: " + propertyName);
            String iVarName = AbstractGenerator.mangle(propertyName);
            this.fwrite("private " + type + ' ' + iVarName + (defaultValue == null ? ";" : " = " + defaultValue + ";") + '\n');
            this.fwrite("public void set" + AbstractGenerator.capitalize(propertyName) + '(' + type + ' ' + iVarName + ") {\n");
            this.indent();
            this.fwrite("this." + iVarName + " = " + iVarName + ";\n");
            this.outdent();
            this.fwrite("}\n\n");
        }

        public void writeWriteOnlyProperty(String propertyName, String type) throws IOException {
            this.writeWriteOnlyProperty(propertyName, type, null);
        }

        private void updateFormatString(int numTabs) {
            if (numTabs == 0) {
                this.formatString = "";
            } else {
                StringBuffer sb = new StringBuffer(numTabs * this.TAB_LENGTH);
                for (int i = 0; i < numTabs; ++i) {
                    sb.append(TAB);
                }
                this.formatString = sb.toString();
            }
        }
    }
}

