/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.client.utils.RestClientLogging;
import org.glassfish.api.logging.LogHelper;

public class MarshallingUtils {
    public static List<Map<String, String>> getPropertiesFromJson(String json) {
        List<Map<String, String>> properties = null;
        if ((json = json.trim()).startsWith("{")) {
            properties = new ArrayList<Map<String, String>>();
            properties.add(MarshallingUtils.processJsonMap(json));
        } else if (json.startsWith("[")) {
            try {
                properties = MarshallingUtils.processJsonArray(new JSONArray(json));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("The JSON string must start with { or [");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> getPropertiesFromXml(String xml) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        InputStream input = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            input = new ByteArrayInputStream(xml.trim().getBytes("UTF-8"));
            XMLStreamReader parser = inputFactory.createXMLStreamReader(input);
            while (parser.hasNext()) {
                int event = parser.next();
                switch (event) {
                    case 1: {
                        if (!"list".equals(parser.getLocalName())) break;
                        list = MarshallingUtils.processXmlList(parser);
                        break;
                    }
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00001", (Throwable)ex, (Object[])new Object[]{"UTF-8"});
            throw new RuntimeException(ex);
        }
        catch (XMLStreamException ex) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00002", (Throwable)ex, (Object[])new Object[0]);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00003", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return list;
    }

    public static String getXmlForProperties(final Map<String, String> properties) {
        return MarshallingUtils.getXmlForProperties((List<Map<String, String>>)new ArrayList<Map<String, String>>(){
            {
                this.add(properties);
            }
        });
    }

    public static String getXmlForProperties(List<Map<String, String>> properties) {
        try {
            Object xml = null;
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            StringWriter sw = new StringWriter();
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(sw);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("list");
            for (Map<String, String> property : properties) {
                writer.writeStartElement("map");
                for (Map.Entry<String, String> entry : property.entrySet()) {
                    writer.writeStartElement("entry");
                    writer.writeAttribute("key", entry.getKey());
                    writer.writeAttribute("value", entry.getValue());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            return sw.toString();
        }
        catch (XMLStreamException ex) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00002", (Throwable)ex, (Object[])new Object[0]);
            throw new RuntimeException(ex);
        }
    }

    public static String getJsonForProperties(final Map<String, String> properties) {
        return MarshallingUtils.getJsonForProperties((List<Map<String, String>>)new ArrayList<Map<String, String>>(){
            {
                this.add(properties);
            }
        });
    }

    public static String getJsonForProperties(List<Map<String, String>> properties) {
        JSONArray list = new JSONArray();
        for (Map<String, String> property : properties) {
            list.put(property);
        }
        return list.toString();
    }

    public static Map buildMapFromDocument(String text) {
        Map map = null;
        if (text == null || text.isEmpty()) {
            return new HashMap();
        }
        if ((text = text.trim()).startsWith("{")) {
            map = MarshallingUtils.processJsonMap(text);
        } else {
            if (text.startsWith("<")) {
                InputStream input = null;
                try {
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    inputFactory.setProperty("javax.xml.stream.isValidating", false);
                    input = new ByteArrayInputStream(text.trim().getBytes("UTF-8"));
                    XMLStreamReader parser = inputFactory.createXMLStreamReader(input);
                    while (parser.hasNext()) {
                        int event = parser.next();
                        switch (event) {
                            case 1: {
                                if (!"map".equals(parser.getLocalName())) break;
                                map = MarshallingUtils.processXmlMap(parser);
                                break;
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00001", (Throwable)ex, (Object[])new Object[]{"UTF-8"});
                    throw new RuntimeException(ex);
                }
                catch (XMLStreamException ex) {
                    LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00002", (Throwable)ex, (Object[])new Object[0]);
                    throw new RuntimeException(ex);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00003", (Throwable)ex, (Object[])new Object[0]);
                    }
                }
            }
            System.out.println(text);
            throw new RuntimeException("An unknown document type was provided:  " + text);
        }
        return map;
    }

    private static Map processJsonMap(String json) {
        HashMap map;
        try {
            map = MarshallingUtils.processJsonObject(new JSONObject(json));
        }
        catch (JSONException e) {
            map = new HashMap();
        }
        return map;
    }

    private static Map processJsonObject(JSONObject jo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Iterator i = jo.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object value = jo.get(key);
                if (value instanceof JSONArray) {
                    map.put(key, MarshallingUtils.processJsonArray((JSONArray)value));
                    continue;
                }
                if (value instanceof JSONObject) {
                    map.put(key, MarshallingUtils.processJsonObject((JSONObject)value));
                    continue;
                }
                if (value.getClass().getSimpleName().equalsIgnoreCase("null")) {
                    map.put(key, null);
                    continue;
                }
                map.put(key, value);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00004", (Throwable)e, (Object[])new Object[0]);
        }
        return map;
    }

    private static List processJsonArray(JSONArray ja) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            for (int i = 0; i < ja.length(); ++i) {
                Object entry = ja.get(i);
                if (entry instanceof JSONArray) {
                    results.add(MarshallingUtils.processJsonArray((JSONArray)entry));
                    continue;
                }
                if (entry instanceof JSONObject) {
                    results.add(MarshallingUtils.processJsonObject((JSONObject)entry));
                    continue;
                }
                results.add(entry);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00004", (Throwable)e, (Object[])new Object[0]);
        }
        return results;
    }

    private static Map processXmlMap(XMLStreamReader parser) throws XMLStreamException {
        boolean endOfMap = false;
        HashMap<String, Object> entry = new HashMap<String, Object>();
        String key = null;
        String element = null;
        block4: while (!endOfMap) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    Object value;
                    if ("entry".equals(parser.getLocalName())) {
                        key = parser.getAttributeValue(null, "key");
                        value = parser.getAttributeValue(null, "value");
                        if (value == null) continue block4;
                        entry.put(key, value);
                        key = null;
                        break;
                    }
                    if ("map".equals(parser.getLocalName())) {
                        value = MarshallingUtils.processXmlMap(parser);
                        entry.put(key, value);
                        break;
                    }
                    if ("list".equals(parser.getLocalName())) {
                        value = MarshallingUtils.processXmlList(parser);
                        entry.put(key, value);
                        break;
                    }
                    element = parser.getLocalName();
                    break;
                }
                case 2: {
                    if ("map".equals(parser.getLocalName())) {
                        endOfMap = true;
                    }
                    element = null;
                    break;
                }
                default: {
                    String text = parser.getText();
                    if (element == null) continue block4;
                    if ("number".equals(element)) {
                        if (text.contains(".")) {
                            entry.put(key, Double.parseDouble(text));
                        } else {
                            entry.put(key, Long.parseLong(text));
                        }
                    } else if ("string".equals(element)) {
                        entry.put(key, text);
                    }
                    element = null;
                }
            }
        }
        return entry;
    }

    private static List processXmlList(XMLStreamReader parser) throws XMLStreamException {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean endOfList = false;
        String element = null;
        block4: while (!endOfList) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    if ("map".equals(parser.getLocalName())) {
                        list.add(MarshallingUtils.processXmlMap(parser));
                        continue block4;
                    }
                    element = parser.getLocalName();
                    continue block4;
                }
                case 2: {
                    if ("list".equals(parser.getLocalName())) {
                        endOfList = true;
                    }
                    element = null;
                    continue block4;
                }
            }
            String text = parser.getText();
            if (element == null) continue;
            if ("number".equals(element)) {
                if (text.contains(".")) {
                    list.add(Double.parseDouble(text));
                } else {
                    list.add(Long.parseLong(text));
                }
            } else if ("string".equals(element)) {
                list.add(text);
            }
            element = null;
        }
        return list;
    }
}

