/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

public class LBCommandsBase {
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LBCommandsBase.class);

    Map<String, Integer> getInstanceWeightsMap(String weights) throws CommandException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringTokenizer st = new StringTokenizer(weights, ":");
        while (st.hasMoreTokens()) {
            Integer weightInt;
            String token = st.nextToken();
            String insName = null;
            String value = null;
            insName = token.substring(0, token.indexOf("="));
            value = token.substring(token.indexOf("=") + 1);
            try {
                weightInt = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                throw new CommandException("Invalid weight value");
            }
            map.put(insName, weightInt);
        }
        return map;
    }

    void updateLBForCluster(ActionReport report, String clusterName, String value, String timeout) {
        Cluster c = this.domain.getClusterNamed(clusterName);
        if (c == null) {
            report.setMessage("Cluster not defined");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (ServerRef sRef : c.getServerRef()) {
            try {
                this.updateLbEnabled(sRef, value, timeout);
            }
            catch (TransactionFailure ex) {
                report.setMessage("Failed to update lb-enabled");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
    }

    ServerRef getServerRefFromCluster(ActionReport report, String target) {
        Cluster c = this.domain.getClusterForInstance(target);
        if (c == null) {
            report.setMessage("ServerNotDefined");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        return c.getServerRefByRef(target);
    }

    void updateLbEnabled(ServerRef ref, final String v, final String tOut) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ServerRef>(){

            public Object run(ServerRef param) throws PropertyVetoException, TransactionFailure {
                param.setLbEnabled(v);
                if (v.equals("false") && tOut != null) {
                    param.setDisableTimeoutInMinutes(tOut);
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)ref);
    }

    void checkCommandStatus(AdminCommandContext context) throws CommandException {
        if (context.getActionReport().getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            throw new CommandException(context.getActionReport().getMessage());
        }
    }
}

