/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.ejb.Init;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbInitInfo;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=Init.class)
public class InitHandler
extends AbstractAttributeHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        Init init = (Init)ainfo.getAnnotation();
        for (EjbContext next : ejbContexts) {
            EjbSessionDescriptor sessionDescriptor = (EjbSessionDescriptor)next.getDescriptor();
            Method m = (Method)ainfo.getAnnotatedElement();
            int numMatches = 0;
            String adaptedCreateMethodName = init.value();
            try {
                if (sessionDescriptor.isRemoteInterfacesSupported()) {
                    this.addInitMethod(sessionDescriptor, m, adaptedCreateMethodName, false);
                    ++numMatches;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (sessionDescriptor.isLocalInterfacesSupported()) {
                    this.addInitMethod(sessionDescriptor, m, adaptedCreateMethodName, true);
                    ++numMatches;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (numMatches != 0) continue;
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.notmatchcreate", "Unable to find matching Home create method for Init method {0} on bean {1}.", new Object[]{m, sessionDescriptor.getName()}));
            return this.getDefaultFailedResult();
        }
        return this.getDefaultProcessedResult();
    }

    private void addInitMethod(EjbSessionDescriptor descriptor, Method beanMethod, String adaptedCreateMethodName, boolean local) throws Exception {
        String homeIntfName = local ? descriptor.getLocalHomeClassName() : descriptor.getHomeClassName();
        ClassLoader cl = descriptor.getEjbBundleDescriptor().getClassLoader();
        Class<?> homeIntf = cl.loadClass(homeIntfName);
        Method createMethod = null;
        if (adaptedCreateMethodName == null || adaptedCreateMethodName.equals("")) {
            for (Method next : homeIntf.getMethods()) {
                if (!next.getName().startsWith("create") || !TypeUtil.sameParamTypes((Method)next, (Method)beanMethod)) continue;
                createMethod = next;
                break;
            }
            if (createMethod == null) {
                throw new NoSuchMethodException("No matching adapted home method found for @Init  method " + beanMethod);
            }
        } else {
            createMethod = homeIntf.getMethod(adaptedCreateMethodName, beanMethod.getParameterTypes());
        }
        MethodDescriptor beanMethodDescriptor = new MethodDescriptor(beanMethod, "Bean");
        MethodDescriptor createMethodDescriptor = new MethodDescriptor(createMethod, local ? "Home" : "LocalHome");
        EjbInitInfo initInfo = new EjbInitInfo();
        initInfo.setBeanMethod(beanMethodDescriptor);
        initInfo.setCreateMethod(createMethodDescriptor);
        descriptor.addInitMethod(initInfo);
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAnnotationTypes();
    }
}

