/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization.naming;

import java.nio.CharBuffer;
import java.util.Objects;
import javax.json.bind.config.PropertyNamingStrategy;

public abstract class LowerCaseStrategy
implements PropertyNamingStrategy {
    public String translateName(String propertyName) {
        Objects.requireNonNull(propertyName);
        CharBuffer charBuffer = CharBuffer.allocate(propertyName.length() * 2);
        char last = '\u0000';
        for (int i = 0; i < propertyName.length(); ++i) {
            char current = propertyName.charAt(i);
            if (i > 0 && Character.isUpperCase(current) && this.isLowerCaseCharacter(last)) {
                charBuffer.append(this.getSeparator());
            }
            charBuffer.append(Character.toLowerCase(current));
            last = current;
        }
        return new String(charBuffer.array(), 0, charBuffer.position());
    }

    private boolean isLowerCaseCharacter(char character) {
        return Character.isAlphabetic(character) && Character.isLowerCase(character);
    }

    protected abstract char getSeparator();
}

