/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.file;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.util.IASSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Service;

@Service
public final class FileRealm
extends IASRealm {
    public static final String AUTH_TYPE = "filepassword";
    public static final String PARAM_KEYFILE = "file";
    FileRealmHelper helper;

    public FileRealm(String keyfile) throws BadRealmException, NoSuchRealmException {
        Properties p = new Properties();
        p.setProperty(PARAM_KEYFILE, keyfile);
        p.setProperty("jaas-context", "ignore");
        this.init(p);
    }

    public FileRealm() {
    }

    public static List<String> getRealmFileNames(Config config) {
        ArrayList<String> files = new ArrayList<String>();
        SecurityService securityService = config.getSecurityService();
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            String file;
            String fileRealmClassName = authRealm.getClassname();
            if (fileRealmClassName == null || !fileRealmClassName.equals(FileRealm.class.getName()) || (file = authRealm.getPropertyValue(PARAM_KEYFILE)) == null) continue;
            if (file.contains("$")) {
                file = RelativePathResolver.resolvePath((String)file);
            }
            files.add(file);
        }
        return files;
    }

    @Override
    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String file = props.getProperty(PARAM_KEYFILE);
        if (file == null) {
            String msg = sm.getString("filerealm.nofile");
            throw new BadRealmException(msg);
        }
        if (file.contains("$")) {
            file = RelativePathResolver.resolvePath((String)file);
        }
        this.setProperty(PARAM_KEYFILE, file);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            String msg = sm.getString("filerealm.nomodule");
            throw new BadRealmException(msg);
        }
        this.setProperty("jaas-context", jaasCtx);
        _logger.log(Level.FINE, "FileRealm : file={0}", file);
        _logger.log(Level.FINE, "FileRealm : jaas-context={0}", jaasCtx);
        try {
            if (Util.isEmbeddedServer()) {
                String embeddedFilePath;
                file = embeddedFilePath = Util.writeConfigFileToTempDir(file).getAbsolutePath();
            }
            this.helper = new FileRealmHelper(file);
        }
        catch (IOException ioe) {
            String msg = sm.getString("filerealm.noaccess", (Object)ioe.toString());
            throw new BadRealmException(msg);
        }
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public Enumeration<String> getUserNames() throws BadRealmException {
        return Collections.enumeration(this.helper.getUserNames());
    }

    @Override
    public User getUser(String name) throws NoSuchUserException {
        FileRealmHelper.User u = this.helper.getUser(name);
        if (u == null) {
            String msg = sm.getString("filerealm.nouser", (Object)name);
            throw new NoSuchUserException(msg);
        }
        return new FileRealmUser(u, null);
    }

    @Override
    public Enumeration getGroupNames() throws BadRealmException {
        return Collections.enumeration(this.helper.getGroupNames());
    }

    @Override
    public Enumeration getGroupNames(String username) throws NoSuchUserException {
        String[] groups = this.helper.getGroupNames(username);
        if (groups == null) {
            groups = new String[]{};
        }
        groups = this.addAssignGroups(groups);
        return Collections.enumeration(Arrays.asList(groups));
    }

    @Override
    public void refresh() throws BadRealmException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Reloading file realm data.");
        }
        try {
            FileRealm newRealm = new FileRealm(this.getProperty(PARAM_KEYFILE));
            newRealm.init(this.getProperties());
            Realm.updateInstance(newRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    @Override
    public void refresh(String configName) throws BadRealmException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Reloading file realm data.");
        }
        try {
            FileRealm newRealm = new FileRealm(this.getProperty(PARAM_KEYFILE));
            newRealm.init(this.getProperties());
            Realm.updateInstance(configName, newRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    @Override
    public void addUser(String name, char[] password, String[] groupList) throws BadRealmException, IASSecurityException {
        this.helper.addUser(name, password, groupList);
    }

    @Override
    public void removeUser(String name) throws NoSuchUserException, BadRealmException {
        this.helper.removeUser(name);
    }

    @Override
    public void updateUser(String name, String newName, char[] password, String[] groups) throws NoSuchUserException, BadRealmException, IASSecurityException {
        this.helper.updateUser(name, newName, password, groups);
    }

    public String[] authenticate(String user, char[] password) {
        String[] groups = this.helper.authenticate(user, password);
        if (groups != null) {
            groups = this.addAssignGroups(groups);
        }
        return groups;
    }

    public boolean hasAuthenticatableUser() {
        return this.helper.hasAuthenticatableUser();
    }

    @Override
    public boolean supportsUserManagement() {
        return true;
    }

    @Override
    public void persist() throws BadRealmException {
        try {
            this.helper.persist();
        }
        catch (IOException ex) {
            throw new BadRealmException(ex);
        }
    }
}

