/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.SemanticTokenTypes;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.VariableTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Definition;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Field;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Parameter;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.SymbolTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.TypeName;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Variable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class Semantic
extends TreeParser
implements SemanticTokenTypes {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(Semantic.class);
    protected SymbolTable symtab;
    protected SymbolTable typeNames;
    protected TypeTable typetab;
    protected ParameterTable paramtab;
    protected VariableTable vartab;
    protected ErrorMsg errorMsg;
    protected ClassType candidateClass;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"import\"", "\"this\"", "\"ascending\"", "\"descending\"", "\"distinct\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "\"null\"", "\"true\"", "\"false\"", "\"avg\"", "\"max\"", "\"min\"", "\"sum\"", "\"count\"", "LPAREN", "RPAREN", "COMMA", "EQUAL", "LNOT", "BNOT", "NOT_EQUAL", "DIV", "PLUS", "MINUS", "STAR", "MOD", "GE", "GT", "LE", "LT", "BXOR", "BOR", "OR", "BAND", "AND", "SEMI", "WS", "NEWLINE", "CHAR_LITERAL", "STRING_LITERAL", "ESC", "HEX_DIGIT", "INT_LITERAL", "EXPONENT", "FLOATINGPOINT_SUFFIX", "an identifier", "UNICODE_ESCAPE", "QUERY", "CLASS_DEF", "IMPORT_DEF", "PARAMETER_DEF", "VARIABLE_DEF", "ORDERING_DEF", "FILTER_DEF", "ARG_LIST", "UNARY_MINUS", "UNARY_PLUS", "TYPECAST", "OBJECT_EQUAL", "OBJECT_NOT_EQUAL", "COLLECTION_EQUAL", "COLLECTION_NOT_EQUAL", "CONCAT", "FIELD_ACCESS", "STATIC_FIELD_ACCESS", "CONTAINS", "NOT_CONTAINS", "NAVIGATION", "STARTS_WITH", "ENDS_WITH", "IS_EMPTY", "VARIABLE", "PARAMETER", "TYPENAME", "VALUE", "RESULT_DEF", "LIKE", "SUBSTRING", "INDEXOF", "LENGTH", "ABS", "SQRT", "NOT_IN", "DOT", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL"};
    public static final BitSet _tokenSet_0 = new BitSet(Semantic.mk_tokenSet_0());

    public void init(TypeTable typetab, ParameterTable paramtab, ErrorMsg errorMsg) {
        this.symtab = new SymbolTable();
        this.typeNames = new SymbolTable();
        this.vartab = new VariableTable(errorMsg);
        this.typetab = typetab;
        this.paramtab = paramtab;
        this.errorMsg = errorMsg;
    }

    public void reportError(RecognitionException ex) {
        this.errorMsg.fatal("Error: " + (Object)((Object)ex));
    }

    public void reportError(String s) {
        this.errorMsg.fatal("Error: " + s);
    }

    public JQLAST createQueryAST(JQLAST candidateClass, JQLAST importsAST, JQLAST paramsAST, JQLAST varsAST, JQLAST orderingAST, JQLAST resultAST, JQLAST filterAST) {
        JQLAST query = new JQLAST(58, "query", null);
        if (candidateClass != null) {
            query.addChild((AST)candidateClass);
        }
        if (importsAST != null) {
            query.addChild((AST)importsAST);
        }
        if (paramsAST != null) {
            query.addChild((AST)paramsAST);
        }
        if (varsAST != null) {
            query.addChild((AST)varsAST);
        }
        if (orderingAST != null) {
            query.addChild((AST)orderingAST);
        }
        if (resultAST != null) {
            query.addChild((AST)resultAST);
        }
        if (filterAST != null) {
            query.addChild((AST)filterAST);
        }
        return query;
    }

    public JQLAST checkCandidateClass(Class candidateClass) {
        Type type = this.typetab.checkType(candidateClass);
        if (type == null) {
            this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkcandidateclass.unknowntype", (String)String.valueOf(candidateClass)));
        }
        return new JQLAST(59, "classDef", type);
    }

    protected void analyseOrderingExpression(JQLAST expr) {
        this.checkValidOrderingExpr(expr);
        Type exprType = expr.getJQLType();
        if (!exprType.isOrderable()) {
            this.errorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analyseorderingexpression.notorderable", (String)exprType.getName()));
            expr.setJQLType(TypeTable.errorType);
        }
    }

    private void checkValidOrderingExpr(JQLAST expr) {
        switch (expr.getType()) {
            case 5: 
            case 82: {
                break;
            }
            case 74: 
            case 78: {
                JQLAST child = (JQLAST)expr.getFirstChild();
                if (child == null) break;
                this.checkValidOrderingExpr(child);
                break;
            }
            default: {
                this.errorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkvalidorderingexpr.invalidordering", (String)expr.getText()));
            }
        }
    }

    private void checkValidResultExpr(JQLAST expr) {
        switch (expr.getType()) {
            case 5: {
                break;
            }
            case 74: 
            case 78: {
                JQLAST child = (JQLAST)expr.getFirstChild();
                if (child == null) break;
                this.checkValidResultExpr(child);
                break;
            }
            case 82: {
                break;
            }
            case 8: {
                this.checkValidResultExpr((JQLAST)expr.getFirstChild());
                break;
            }
            case 20: 
            case 23: {
                if (!this.typetab.isNumberType(expr.getJQLType()) || this.typetab.isCharType(expr.getJQLType())) {
                    this.errorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkvalidresultexpr.invalidavgsumexpr", (String)expr.getJQLType().getName(), (String)expr.getText()));
                }
                this.checkValidResultExpr((JQLAST)expr.getFirstChild());
                break;
            }
            case 21: 
            case 22: {
                if (!expr.getJQLType().isOrderable()) {
                    this.errorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkvalidresultexpr.invalidminmaxexpr", (String)expr.getJQLType().getName(), (String)expr.getText()));
                }
                this.checkValidResultExpr((JQLAST)expr.getFirstChild());
                break;
            }
            case 24: {
                this.checkValidResultExpr((JQLAST)expr.getFirstChild());
                break;
            }
            default: {
                this.errorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkvalidresultexpr.invalidresult", (String)expr.getText()));
            }
        }
    }

    private void checkResultOrdering(JQLAST result, JQLAST ordering) {
        block8: {
            JQLAST resultReturnAST;
            block7: {
                if (ordering == null) {
                    return;
                }
                resultReturnAST = result;
                boolean hasResultDistinct = false;
                if (resultReturnAST == null) {
                    resultReturnAST = new JQLAST(5, "this", this.candidateClass);
                    hasResultDistinct = true;
                }
                if (resultReturnAST.getType() == 86) {
                    resultReturnAST = resultReturnAST.getFirstChild();
                }
                if (resultReturnAST.getType() == 8) {
                    resultReturnAST = resultReturnAST.getFirstChild();
                    hasResultDistinct = true;
                }
                if (!hasResultDistinct) {
                    return;
                }
                if (resultReturnAST.getType() != 74) break block7;
                StringBuffer buf = new StringBuffer();
                this.genPathExpression((AST)resultReturnAST, buf);
                String resultReturnPathExpr = buf.toString();
                for (JQLAST sibling = ordering; sibling != null && sibling.getType() == 63; sibling = sibling.getNextSibling()) {
                    buf.setLength(0);
                    this.genPathExpression(sibling.getFirstChild().getNextSibling(), buf);
                    String orderingItemExpr = buf.toString();
                    if (orderingItemExpr.equals(resultReturnPathExpr)) continue;
                    this.errorMsg.error(ordering.getLine(), ordering.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkresultordering.invalidorderingfordistinctresultfield", (String)resultReturnPathExpr, (String)orderingItemExpr));
                }
                break block8;
            }
            if (resultReturnAST.getType() != 78 && resultReturnAST.getType() != 5) break block8;
            StringBuffer buf = new StringBuffer();
            this.genPathExpression((AST)resultReturnAST, buf);
            String resultReturnPathExpr = buf.toString();
            for (JQLAST sibling = ordering; sibling != null && sibling.getType() == 63; sibling = sibling.getNextSibling()) {
                buf.setLength(0);
                this.genPathExpression(sibling.getFirstChild().getNextSibling().getFirstChild(), buf);
                String orderingRootExpr = buf.toString();
                if (orderingRootExpr.equals(resultReturnPathExpr)) continue;
                buf.setLength(0);
                this.genPathExpression(sibling.getFirstChild().getNextSibling(), buf);
                this.errorMsg.error(ordering.getLine(), ordering.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.checkresultordering.invalidorderingfordistinctresult", (String)resultReturnPathExpr, (String)buf.toString()));
            }
        }
    }

    private void genPathExpression(AST ast, StringBuffer buf) {
        if (ast == null) {
            return;
        }
        switch (ast.getType()) {
            case 74: 
            case 75: 
            case 78: {
                AST left = ast.getFirstChild();
                AST right = left.getNextSibling();
                this.genPathExpression(left, buf);
                buf.append('.');
                this.genPathExpression(right, buf);
                break;
            }
            default: {
                buf.append(ast.getText());
            }
        }
    }

    protected JQLAST analyseDotExpr(JQLAST dot, JQLAST expr, JQLAST ident, JQLAST args) {
        Type exprType = expr.getJQLType();
        String name = ident.getText();
        dot.setText(expr.getText() + '.' + name);
        if (exprType instanceof ClassType) {
            ClassType classType = (ClassType)exprType;
            if (args == null) {
                FieldInfo fieldInfo = classType.getFieldInfo(name);
                if (fieldInfo == null) {
                    this.errorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.unknownfield", (String)ident.getText(), (String)exprType.getName()));
                    dot.setJQLType(TypeTable.errorType);
                    ident.setJQLType(TypeTable.errorType);
                    return dot;
                }
                if (expr.getType() == 84) {
                    return this.analyseStaticFieldAccess(dot, expr, ident, classType, fieldInfo);
                }
                return this.analyseFieldAccess(dot, expr, ident, classType, fieldInfo);
            }
            if (this.typetab.isCollectionType(exprType)) {
                return this.analyseCollectionCall(dot, expr, ident, args);
            }
            if (exprType.equals(this.typetab.stringType)) {
                return this.analyseStringCall(dot, expr, ident, args);
            }
            if (this.typetab.isJavaLangMathType(exprType)) {
                return this.analyseMathCall(dot, expr, ident, args);
            }
            this.errorMsg.error(dot.getLine(), dot.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.invalidmethodcall"));
            dot.setJQLType(TypeTable.errorType);
            return dot;
        }
        this.errorMsg.error(expr.getLine(), expr.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysedotexpr.classexprexpected", (String)ident.getText(), (String)exprType.getName()));
        dot.setJQLType(TypeTable.errorType);
        return dot;
    }

    protected JQLAST analyseFieldAccess(JQLAST access, JQLAST objectExpr, JQLAST ident, ClassType classType, FieldInfo fieldInfo) {
        String name = ident.getText();
        Type fieldType = fieldInfo.getType();
        if (classType.isPersistenceCapable()) {
            if (!fieldInfo.isPersistent()) {
                this.errorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysefieldaccess.nonperistentfield", (String)name, (String)classType.getName()));
            }
            if (this.typetab.isPersistenceCapableType(fieldType)) {
                access.setType(78);
            } else {
                access.setType(74);
            }
        } else {
            if (!fieldInfo.isPublic()) {
                this.errorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysefieldaccess.nonpublicfield", (String)name, (String)classType.getName()));
            }
            access.setType(74);
        }
        access.setText(objectExpr.getText() + '.' + name);
        access.setJQLType(fieldType);
        ident.setJQLType(fieldType);
        access.setFirstChild((AST)objectExpr);
        objectExpr.setNextSibling((AST)ident);
        return access;
    }

    protected JQLAST analyseStaticFieldAccess(JQLAST access, JQLAST typename, JQLAST ident, ClassType classType, FieldInfo fieldInfo) {
        String name = ident.getText();
        Type fieldType = fieldInfo.getType();
        if (!fieldInfo.isStatic()) {
            this.errorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysestaticfieldaccess.staticreference", (String)ident.getText(), (String)classType.getName()));
        }
        if (!fieldInfo.isPublic()) {
            this.errorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysestaticfieldaccess.nonpublicfield", (String)name, (String)classType.getName()));
        }
        access.setType(75);
        access.setText(typename.getText() + '.' + name);
        access.setJQLType(fieldType);
        ident.setJQLType(fieldType);
        access.setFirstChild((AST)typename);
        typename.setNextSibling((AST)ident);
        return access;
    }

    protected JQLAST analyseDefinedIdentifier(JQLAST ident, Definition def) {
        Type type = def.getType();
        if (def instanceof Variable) {
            ident.setType(82);
        } else if (def instanceof Parameter) {
            ident.setType(83);
        } else if (def instanceof Field) {
            FieldInfo fieldInfo = ((Field)def).getFieldInfo();
            JQLAST fieldAccessAST = ident;
            JQLAST identAST = new JQLAST(ident);
            if (fieldInfo.isStatic()) {
                JQLAST typeNameAST = new JQLAST(84, this.candidateClass.getName(), this.candidateClass);
                ident = this.analyseStaticFieldAccess(fieldAccessAST, typeNameAST, identAST, this.candidateClass, fieldInfo);
            } else {
                JQLAST thisAST = new JQLAST(5, "this", this.candidateClass);
                ident = this.analyseFieldAccess(fieldAccessAST, thisAST, identAST, this.candidateClass, fieldInfo);
            }
        } else if (def instanceof TypeName) {
            ident.setType(84);
            ident.setText(((TypeName)def).getQualifiedName());
        } else {
            type = TypeTable.errorType;
            this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysedefinedidentifier.illegalident", (String)String.valueOf(def)));
        }
        ident.setJQLType(type);
        return ident;
    }

    protected JQLAST analyseCollectionCall(JQLAST dot, JQLAST collection, JQLAST method, JQLAST args) {
        String methodName = method.getText();
        JQLAST firstArg = (JQLAST)args.getFirstChild();
        if (methodName.equals("contains")) {
            this.checkContainsArgs(collection, method, firstArg);
            dot.setType(76);
            dot.setJQLType(this.typetab.booleanType);
            dot.setFirstChild((AST)collection);
            collection.setNextSibling((AST)firstArg);
            return dot;
        }
        if (methodName.equals("isEmpty")) {
            this.checkNoArgs(method, firstArg);
            dot.setType(81);
            dot.setJQLType(this.typetab.booleanType);
            dot.setFirstChild((AST)collection);
            collection.setNextSibling(null);
            return dot;
        }
        this.errorMsg.error(dot.getLine(), dot.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.invalidmethodcall"));
        dot.setJQLType(TypeTable.errorType);
        return dot;
    }

    protected JQLAST analyseStringCall(JQLAST dot, JQLAST string, JQLAST method, JQLAST args) {
        String methodName = method.getText();
        JQLAST firstArg = (JQLAST)args.getFirstChild();
        if (methodName.equals("startsWith")) {
            dot.setType(79);
            this.checkOneStringArg(method, firstArg);
            dot.setJQLType(this.typetab.booleanType);
            dot.setFirstChild((AST)string);
            string.setNextSibling((AST)firstArg);
        } else if (methodName.equals("endsWith")) {
            dot.setType(80);
            this.checkOneStringArg(method, firstArg);
            dot.setJQLType(this.typetab.booleanType);
            dot.setFirstChild((AST)string);
            string.setNextSibling((AST)firstArg);
        } else if (methodName.equals("like")) {
            this.checkLikeArgs(method, firstArg);
            dot.setType(87);
            dot.setJQLType(this.typetab.booleanType);
            dot.setFirstChild((AST)string);
            string.setNextSibling((AST)firstArg);
        } else if (methodName.equals("substring")) {
            this.checkTwoIntArgs(method, firstArg);
            dot.setType(88);
            dot.setJQLType(this.typetab.stringType);
            dot.setFirstChild((AST)string);
            string.setNextSibling((AST)firstArg);
        } else if (methodName.equals("indexOf")) {
            this.checkIndexOfArgs(method, firstArg);
            dot.setType(89);
            dot.setJQLType(this.typetab.intType);
            dot.setFirstChild((AST)string);
            string.setNextSibling((AST)firstArg);
        } else if (methodName.equals("length")) {
            this.checkNoArgs(method, firstArg);
            dot.setType(90);
            dot.setJQLType(this.typetab.intType);
            dot.setFirstChild((AST)string);
            string.setNextSibling(null);
        } else {
            this.errorMsg.error(dot.getLine(), dot.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.invalidmethodcall"));
            dot.setJQLType(TypeTable.errorType);
        }
        return dot;
    }

    protected JQLAST analyseMathCall(JQLAST dot, JQLAST type, JQLAST method, JQLAST args) {
        String methodName = method.getText();
        JQLAST firstArg = (JQLAST)args.getFirstChild();
        if (methodName.equals("abs")) {
            this.checkAbsArgs(method, firstArg);
            dot.setType(91);
            dot.setJQLType(firstArg.getJQLType());
            dot.setFirstChild((AST)firstArg);
        } else if (methodName.equals("sqrt")) {
            this.checkSqrtArgs(method, firstArg);
            dot.setType(92);
            dot.setJQLType(firstArg.getJQLType());
            dot.setFirstChild((AST)firstArg);
        } else {
            this.errorMsg.error(dot.getLine(), dot.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.invalidmethodcall"));
            dot.setJQLType(TypeTable.errorType);
        }
        return dot;
    }

    protected void checkNoArgs(JQLAST method, JQLAST firstArg) {
        if (firstArg != null) {
            this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        }
    }

    protected void checkOneStringArg(JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type argType = firstArg.getJQLType();
            if (!argType.equals(this.typetab.stringType)) {
                this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)argType.getName(), (String)this.typetab.stringType.getName()));
            }
        }
    }

    protected void checkContainsArgs(JQLAST collection, JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getType() != 82) {
            this.errorMsg.unsupported(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysecollectioncall.nonvariable"));
        } else {
            FieldInfo collectionFieldInfo = this.getCollectionField(collection);
            if (collectionFieldInfo == null) {
                this.errorMsg.unsupported(collection.getLine(), collection.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysecollectioncall.unsupportedcollectionexpr", (String)collection.getText()));
            } else if (!collectionFieldInfo.isRelationship()) {
                this.errorMsg.error(collection.getLine(), collection.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysecollectioncall.relationshipexpected", (String)collectionFieldInfo.getName()));
            }
            Type variableType = firstArg.getJQLType();
            Type elementType = collectionFieldInfo.getAssociatedClass();
            if (!elementType.isCompatibleWith(variableType)) {
                this.errorMsg.error(collection.getLine(), collection.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysecollectioncall.typemismatch", (String)elementType.getName(), (String)variableType.getName()));
            }
        }
    }

    protected void checkLikeArgs(JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() != null && firstArg.getNextSibling().getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling().getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type secondArgType;
            JQLAST secondArg;
            Type firstArgType = firstArg.getJQLType();
            if (!firstArgType.equals(this.typetab.stringType)) {
                this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)firstArgType.getName(), (String)this.typetab.stringType.getName()));
            }
            if ((secondArg = (JQLAST)firstArg.getNextSibling()) != null && !this.typetab.isCharType(secondArgType = secondArg.getJQLType())) {
                this.errorMsg.error(secondArg.getLine(), secondArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)secondArgType.getName(), (String)this.typetab.charType.getName()));
            }
        }
    }

    protected void checkTwoIntArgs(JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling().getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling().getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type firstArgType = firstArg.getJQLType();
            if (!this.typetab.isIntType(firstArgType)) {
                this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)firstArgType.getName(), (String)this.typetab.intType.getName()));
            }
            JQLAST secondArg = (JQLAST)firstArg.getNextSibling();
            Type secondArgType = firstArg.getJQLType();
            if (!this.typetab.isIntType(secondArgType)) {
                this.errorMsg.error(secondArg.getLine(), secondArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)secondArgType.getName(), (String)this.typetab.intType.getName()));
            }
        }
    }

    protected void checkIndexOfArgs(JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() != null && firstArg.getNextSibling().getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling().getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type secondArgType;
            JQLAST secondArg;
            Type firstArgType = firstArg.getJQLType();
            if (!firstArgType.equals(this.typetab.stringType)) {
                this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)firstArgType.getName(), (String)this.typetab.stringType.getName()));
            }
            if ((secondArg = (JQLAST)firstArg.getNextSibling()) != null && !this.typetab.isIntType(secondArgType = secondArg.getJQLType())) {
                this.errorMsg.error(secondArg.getLine(), secondArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)secondArgType.getName(), (String)this.typetab.intType.getName()));
            }
        }
    }

    protected void checkAbsArgs(JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type argType = firstArg.getJQLType();
            if (!this.typetab.isNumberType(argType)) {
                this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)argType.getName(), (String)"number type"));
            }
        }
    }

    protected void checkSqrtArgs(JQLAST method, JQLAST firstArg) {
        if (firstArg == null) {
            this.errorMsg.error(method.getLine(), method.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (firstArg.getNextSibling() != null) {
            JQLAST nextArg = (JQLAST)firstArg.getNextSibling();
            this.errorMsg.error(nextArg.getLine(), nextArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type argType = firstArg.getJQLType();
            if (!this.typetab.isDoubleType(argType)) {
                this.errorMsg.error(firstArg.getLine(), firstArg.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.typemismatch", (String)argType.getName(), (String)"double or Double"));
            }
        }
    }

    protected FieldInfo getCollectionField(JQLAST expr) {
        JQLAST child = (JQLAST)expr.getFirstChild();
        switch (expr.getType()) {
            case 74: 
            case 78: {
                if (child != null && child.getNextSibling() != null) {
                    ClassType classType = (ClassType)child.getJQLType();
                    String fieldName = child.getNextSibling().getText();
                    return classType.getFieldInfo(fieldName);
                }
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.getcollectionfield.missingchildren"));
                break;
            }
            case 68: {
                if (child != null && child.getNextSibling() != null) {
                    return this.getCollectionField((JQLAST)child.getNextSibling());
                }
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.getcollectionfield.missingchildren"));
            }
        }
        return null;
    }

    protected Type analyseBitwiseExpr(JQLAST op, JQLAST leftAST, JQLAST rightAST) {
        Type right;
        Type left;
        block10: {
            block9: {
                left = leftAST.getJQLType();
                right = rightAST.getJQLType();
                if (left.equals(TypeTable.errorType)) break block9;
                if (!right.equals(TypeTable.errorType)) break block10;
            }
            return TypeTable.errorType;
        }
        switch (op.getType()) {
            case 42: 
            case 44: {
                if (this.typetab.isBooleanType(left) && this.typetab.isBooleanType(right)) {
                    return this.typetab.booleanType;
                }
                if (!this.typetab.isIntegralType(left) && !this.typetab.isIntegralType(right)) break;
                this.errorMsg.unsupported(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysebitwiseexpr.integerbitwiseop", (String)op.getText()));
                return TypeTable.errorType;
            }
            case 41: {
                if (this.typetab.isBooleanType(left) && this.typetab.isBooleanType(right)) {
                    this.errorMsg.unsupported(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysebitwiseexpr.exclusiveorop"));
                    return TypeTable.errorType;
                }
                if (!this.typetab.isIntegralType(left) && !this.typetab.isIntegralType(right)) break;
                this.errorMsg.unsupported(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analysebitwiseexpr.integerbitwiseop", (String)op.getText()));
                return TypeTable.errorType;
            }
        }
        this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.invalid", (String)op.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseConditionalExpr(JQLAST op, JQLAST leftAST, JQLAST rightAST) {
        Type right;
        Type left;
        block6: {
            block5: {
                left = leftAST.getJQLType();
                right = rightAST.getJQLType();
                if (left.equals(TypeTable.errorType)) break block5;
                if (!right.equals(TypeTable.errorType)) break block6;
            }
            return TypeTable.errorType;
        }
        switch (op.getType()) {
            case 43: 
            case 45: {
                if (!this.typetab.isBooleanType(left) || !this.typetab.isBooleanType(right)) break;
                return this.typetab.booleanType;
            }
        }
        this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.invalid", (String)op.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseRelationalExpr(JQLAST op, JQLAST leftAST, JQLAST rightAST) {
        Type right;
        Type left;
        block12: {
            block11: {
                left = leftAST.getJQLType();
                right = rightAST.getJQLType();
                if (left.equals(TypeTable.errorType)) break block11;
                if (!right.equals(TypeTable.errorType)) break block12;
            }
            return TypeTable.errorType;
        }
        switch (op.getType()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (!left.isOrderable()) {
                    this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analyserelationalexpr.notorderable", (String)left.getName(), (String)op.getText()));
                    return TypeTable.errorType;
                }
                if (right.isOrderable()) break;
                this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.analyserelationalexpr.notorderable", (String)right.getName(), (String)op.getText()));
                return TypeTable.errorType;
            }
            case 28: 
            case 31: {
                if (leftAST.getType() != 76 && rightAST.getType() != 76) break;
                this.errorMsg.unsupported(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.unsupportedconstraintop", (String)op.getText()));
                return TypeTable.errorType;
            }
        }
        if (this.typetab.isNumberType(left) && this.typetab.isNumberType(right)) {
            return this.typetab.booleanType;
        }
        if (this.typetab.isBooleanType(left) && this.typetab.isBooleanType(right)) {
            return this.typetab.booleanType;
        }
        if (left.isCompatibleWith(right) || right.isCompatibleWith(left)) {
            return this.typetab.booleanType;
        }
        this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.invalid", (String)op.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseBinaryArithmeticExpr(JQLAST op, JQLAST leftAST, JQLAST rightAST) {
        Type right;
        Type left;
        block16: {
            block15: {
                left = leftAST.getJQLType();
                right = rightAST.getJQLType();
                if (left.equals(TypeTable.errorType)) break block15;
                if (!right.equals(TypeTable.errorType)) break block16;
            }
            return TypeTable.errorType;
        }
        if (this.typetab.isNumberType(left) && this.typetab.isNumberType(right)) {
            if (left.isCompatibleWith(this.typetab.bigDecimalType)) {
                return left;
            }
            if (right.isCompatibleWith(this.typetab.bigDecimalType)) {
                return right;
            }
            if (left.isCompatibleWith(this.typetab.bigIntegerType)) {
                return this.typetab.isFloatingPointType(right) ? this.typetab.bigDecimalType : left;
            }
            if (right.isCompatibleWith(this.typetab.bigIntegerType)) {
                return this.typetab.isFloatingPointType(left) ? this.typetab.bigDecimalType : right;
            }
            boolean wrapper = false;
            if (left instanceof NumericWrapperClassType) {
                left = ((NumericWrapperClassType)left).getPrimitiveType();
                wrapper = true;
            }
            if (right instanceof NumericWrapperClassType) {
                right = ((NumericWrapperClassType)right).getPrimitiveType();
                wrapper = true;
            }
            if (left instanceof NumericType && right instanceof NumericType) {
                Type promotedType = this.typetab.binaryNumericPromotion(left, right);
                if (wrapper && promotedType instanceof NumericType) {
                    promotedType = ((NumericType)promotedType).getWrapper();
                }
                return promotedType;
            }
        } else if (op.getType() == 33 && (left.equals(this.typetab.stringType) || left.equals(this.typetab.charType)) && (right.equals(this.typetab.stringType) || right.equals(this.typetab.charType))) {
            return this.typetab.stringType;
        }
        this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.invalid", (String)op.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseUnaryArithmeticExpr(JQLAST op, JQLAST argAST) {
        Type arg = argAST.getJQLType();
        if (arg.equals(TypeTable.errorType)) {
            return TypeTable.errorType;
        }
        if (arg.isCompatibleWith(this.typetab.bigDecimalType)) {
            return arg;
        }
        if (arg.isCompatibleWith(this.typetab.bigIntegerType)) {
            return arg;
        }
        boolean wrapper = false;
        if (arg instanceof NumericWrapperClassType) {
            arg = ((NumericWrapperClassType)arg).getPrimitiveType();
            wrapper = true;
        }
        if (arg instanceof NumericType) {
            Type promotedType = this.typetab.unaryNumericPromotion(arg);
            if (wrapper && promotedType instanceof NumericType) {
                promotedType = ((NumericType)promotedType).getWrapper();
            }
            return promotedType;
        }
        this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.invalid", (String)op.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseComplementExpr(JQLAST op, JQLAST argAST) {
        Type arg = argAST.getJQLType();
        if (arg.equals(TypeTable.errorType)) {
            return TypeTable.errorType;
        }
        switch (op.getType()) {
            case 30: {
                if (!this.typetab.isIntegralType(arg)) break;
                return arg;
            }
            case 29: {
                if (!this.typetab.isBooleanType(arg)) break;
                if (argAST.getType() == 76) {
                    this.errorMsg.unsupported(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.unsupportedconstraintop", (String)op.getText()));
                    return TypeTable.errorType;
                }
                return arg;
            }
        }
        this.errorMsg.error(op.getLine(), op.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.arguments.invalid", (String)op.getText()));
        return TypeTable.errorType;
    }

    protected void checkConstraints(JQLAST ast, VariableTable tab) {
        this.checkConstraints(ast, null, tab);
    }

    protected void checkConstraints(JQLAST ast, String dependentVariable, VariableTable tab) {
        if (ast == null) {
            return;
        }
        switch (ast.getType()) {
            case 82: {
                tab.markUsed(ast, dependentVariable);
                break;
            }
            case 76: {
                JQLAST expr = (JQLAST)ast.getFirstChild();
                JQLAST var = (JQLAST)expr.getNextSibling();
                this.checkConstraints(expr, var.getText(), tab);
                tab.markConstraint(var, expr);
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                JQLAST left = (JQLAST)ast.getFirstChild();
                JQLAST right = (JQLAST)left.getNextSibling();
                VariableTable copy = new VariableTable(tab);
                this.checkConstraints(left, dependentVariable, tab);
                this.checkConstraints(right, dependentVariable, copy);
                tab.merge(copy);
                break;
            }
            default: {
                for (JQLAST node = (JQLAST)ast.getFirstChild(); node != null; node = (JQLAST)node.getNextSibling()) {
                    this.checkConstraints(node, dependentVariable, tab);
                }
            }
        }
    }

    public Semantic() {
        this.tokenNames = _tokenNames;
    }

    public final void query(AST _t) throws RecognitionException {
        JQLAST query_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST query_AST = null;
        JQLAST o_AST = null;
        JQLAST o = null;
        JQLAST r_AST = null;
        JQLAST r = null;
        AST __t2 = _t;
        JQLAST tmp1_AST = null;
        JQLAST tmp1_AST_in = null;
        tmp1_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp1_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp1_AST);
        ASTPair __currentAST2 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 58);
        _t = _t.getFirstChild();
        this.symtab.enterScope();
        this.typeNames.enterScope();
        this.candidateClass(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.imports(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.symtab.enterScope();
        this.parameters(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.variables(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        o = _t == ASTNULL ? null : (JQLAST)_t;
        this.ordering(_t);
        _t = this._retTree;
        o_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        r = _t == ASTNULL ? null : (JQLAST)_t;
        this.result(_t);
        _t = this._retTree;
        r_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.filter(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.typeNames.leaveScope();
        this.symtab.leaveScope();
        this.symtab.leaveScope();
        currentAST = __currentAST2;
        _t = __t2;
        _t = _t.getNextSibling();
        this.checkResultOrdering(r_AST, o_AST);
        query_AST = (JQLAST)currentAST.root;
        this.returnAST = query_AST;
        this._retTree = _t;
    }

    public final void candidateClass(AST _t) throws RecognitionException {
        int index;
        JQLAST candidateClass_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST candidateClass_AST = null;
        JQLAST c = null;
        JQLAST c_AST = null;
        this.errorMsg.setContext("setClass");
        c = (JQLAST)_t;
        Object c_AST_in = null;
        c_AST = (JQLAST)this.astFactory.create((AST)c);
        this.astFactory.addASTChild(currentAST, (AST)c_AST);
        this.match(_t, 59);
        _t = _t.getNextSibling();
        this.candidateClass = (ClassType)c_AST.getJQLType();
        String className = this.candidateClass.getName();
        if (!this.candidateClass.isPersistenceCapable()) {
            this.errorMsg.unsupported(c_AST.getLine(), c_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.candidateclass.nonpc", (String)className));
        }
        String identName = (index = className.lastIndexOf(46)) > 0 ? className.substring(index + 1) : className;
        this.typeNames.declare(identName, new TypeName(this.candidateClass, className));
        FieldInfo[] fieldInfos = this.candidateClass.getFieldInfos();
        for (int i = 0; i < fieldInfos.length; ++i) {
            FieldInfo fieldInfo = fieldInfos[i];
            this.symtab.declare(fieldInfo.getName(), new Field(fieldInfo));
        }
        candidateClass_AST = (JQLAST)currentAST.root;
        this.returnAST = candidateClass_AST;
        this._retTree = _t;
    }

    public final void imports(AST _t) throws RecognitionException {
        JQLAST imports_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        Object imports_AST = null;
        this.errorMsg.setContext("declareImports");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 60) break;
            this.declareImport(_t);
            _t = this._retTree;
        }
        this.returnAST = imports_AST;
        this._retTree = _t;
    }

    public final void parameters(AST _t) throws RecognitionException {
        JQLAST parameters_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST parameters_AST = null;
        this.errorMsg.setContext("declareParameters");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 61) break;
            this.declareParameter(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        parameters_AST = (JQLAST)currentAST.root;
        this.returnAST = parameters_AST;
        this._retTree = _t;
    }

    public final void variables(AST _t) throws RecognitionException {
        JQLAST variables_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST variables_AST = null;
        this.errorMsg.setContext("declareVariables");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 62) break;
            this.declareVariable(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        variables_AST = (JQLAST)currentAST.root;
        this.returnAST = variables_AST;
        this._retTree = _t;
    }

    public final void ordering(AST _t) throws RecognitionException {
        JQLAST ordering_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST ordering_AST = null;
        this.errorMsg.setContext("setOrdering");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 63) break;
            this.orderSpec(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        ordering_AST = (JQLAST)currentAST.root;
        this.returnAST = ordering_AST;
        this._retTree = _t;
    }

    public final void result(AST _t) throws RecognitionException {
        JQLAST result_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST result_AST = null;
        JQLAST r = null;
        JQLAST r_AST = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        this.errorMsg.setContext("setResult");
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 86: {
                AST __t26 = _t;
                r = _t == ASTNULL ? null : (JQLAST)_t;
                Object r_AST_in = null;
                r_AST = (JQLAST)this.astFactory.create((AST)r);
                this.astFactory.addASTChild(currentAST, (AST)r_AST);
                ASTPair __currentAST26 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 86);
                _t = _t.getFirstChild();
                e = _t == ASTNULL ? null : (JQLAST)_t;
                this.resultExpr(_t);
                _t = this._retTree;
                e_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST26;
                _t = __t26;
                _t = _t.getNextSibling();
                this.checkValidResultExpr(e_AST);
                r_AST.setJQLType(e_AST.getJQLType());
                this.checkConstraints(e_AST, this.vartab);
                result_AST = (JQLAST)currentAST.root;
                break;
            }
            case 64: {
                result_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = result_AST;
        this._retTree = _t;
    }

    public final void filter(AST _t) throws RecognitionException {
        JQLAST filter_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST filter_AST = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        this.errorMsg.setContext("setFilter");
        AST __t35 = _t;
        JQLAST tmp2_AST = null;
        JQLAST tmp2_AST_in = null;
        tmp2_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp2_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp2_AST);
        ASTPair __currentAST35 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 64);
        _t = _t.getFirstChild();
        e = _t == ASTNULL ? null : (JQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        e_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST35;
        _t = __t35;
        _t = _t.getNextSibling();
        Type exprType = e_AST.getJQLType();
        if (!this.typetab.isBooleanType(exprType)) {
            if (!exprType.equals(TypeTable.errorType)) {
                this.errorMsg.error(e_AST.getLine(), e_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.filter.booleanexpected", (Object)exprType));
            }
        }
        this.checkConstraints(e_AST, this.vartab);
        this.vartab.checkConstraints();
        filter_AST = (JQLAST)currentAST.root;
        this.returnAST = filter_AST;
        this._retTree = _t;
    }

    public final void declareImport(AST _t) throws RecognitionException {
        int index;
        String identName;
        Definition old;
        JQLAST declareImport_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST declareImport_AST = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        String name = null;
        AST __t8 = _t;
        i = _t == ASTNULL ? null : (JQLAST)_t;
        Object i_AST_in = null;
        i_AST = (JQLAST)this.astFactory.create((AST)i);
        this.astFactory.addASTChild(currentAST, (AST)i_AST);
        ASTPair __currentAST8 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 60);
        _t = _t.getFirstChild();
        name = this.qualifiedName(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST8;
        _t = __t8;
        _t = _t.getNextSibling();
        Type type = this.typetab.checkType(name);
        if (type == null) {
            this.errorMsg.error(i_AST.getLine(), i_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.unknowntype", (String)name));
        }
        if ((old = this.typeNames.declare(identName = (index = name.lastIndexOf(46)) > 0 ? name.substring(index + 1) : name, new TypeName(type, name))) != null) {
            this.errorMsg.error(i_AST.getLine(), i_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.alreadydeclared", (String)identName, (String)old.getName()));
        }
        declareImport_AST = (JQLAST)currentAST.root;
        this.returnAST = declareImport_AST;
        this._retTree = _t;
    }

    public final String qualifiedName(AST _t) throws RecognitionException {
        JQLAST qualifiedName_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST qualifiedName_AST = null;
        JQLAST id1 = null;
        JQLAST id1_AST = null;
        JQLAST d = null;
        JQLAST d_AST = null;
        JQLAST id2 = null;
        JQLAST id2_AST = null;
        String name = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 56: {
                id1 = (JQLAST)_t;
                Object id1_AST_in = null;
                id1_AST = (JQLAST)this.astFactory.create((AST)id1);
                this.astFactory.addASTChild(currentAST, (AST)id1_AST);
                this.match(_t, 56);
                _t = _t.getNextSibling();
                name = id1_AST.getText();
                qualifiedName_AST = (JQLAST)currentAST.root;
                break;
            }
            case 94: {
                AST __t77 = _t;
                d = _t == ASTNULL ? null : (JQLAST)_t;
                Object d_AST_in = null;
                d_AST = (JQLAST)this.astFactory.create((AST)d);
                this.astFactory.addASTChild(currentAST, (AST)d_AST);
                ASTPair __currentAST77 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 94);
                _t = _t.getFirstChild();
                name = this.qualifiedName(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                id2 = (JQLAST)_t;
                Object id2_AST_in = null;
                id2_AST = (JQLAST)this.astFactory.create((AST)id2);
                this.astFactory.addASTChild(currentAST, (AST)id2_AST);
                this.match(_t, 56);
                _t = _t.getNextSibling();
                name = name + d_AST.getText() + id2_AST.getText();
                currentAST = __currentAST77;
                _t = __t77;
                _t = _t.getNextSibling();
                qualifiedName_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = qualifiedName_AST;
        this._retTree = _t;
        return name;
    }

    public final void declareParameter(AST _t) throws RecognitionException {
        JQLAST declareParameter_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST declareParameter_AST = null;
        JQLAST t_AST = null;
        JQLAST t = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        AST __t13 = _t;
        JQLAST tmp3_AST = null;
        JQLAST tmp3_AST_in = null;
        tmp3_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp3_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp3_AST);
        ASTPair __currentAST13 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 61);
        _t = _t.getFirstChild();
        t = _t == ASTNULL ? null : (JQLAST)_t;
        this.type(_t);
        _t = this._retTree;
        t_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        i = (JQLAST)_t;
        Object i_AST_in = null;
        i_AST = (JQLAST)this.astFactory.create((AST)i);
        this.astFactory.addASTChild(currentAST, (AST)i_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST13;
        _t = __t13;
        _t = _t.getNextSibling();
        String name = i_AST.getText();
        Type type = t_AST.getJQLType();
        Definition old = this.symtab.declare(name, new Parameter(type));
        if (old != null) {
            this.errorMsg.error(i_AST.getLine(), i_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.alreadydeclared", (String)name, (String)old.getName()));
        }
        i_AST.setJQLType(type);
        this.paramtab.add(name, type);
        declareParameter_AST = (JQLAST)currentAST.root;
        this.returnAST = declareParameter_AST;
        this._retTree = _t;
    }

    public final void type(AST _t) throws RecognitionException {
        JQLAST type_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST type_AST = null;
        JQLAST qn_AST = null;
        JQLAST qn = null;
        JQLAST p_AST = null;
        JQLAST p = null;
        String name = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 56: 
            case 94: {
                qn = _t == ASTNULL ? null : (JQLAST)_t;
                name = this.qualifiedName(_t);
                _t = this._retTree;
                qn_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                Type type = null;
                if (this.typeNames.isDeclared(name)) {
                    Definition def = this.typeNames.getDefinition(name);
                    if (def instanceof TypeName) {
                        type = def.getType();
                    } else {
                        this.errorMsg.error(qn_AST.getLine(), qn_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.type.notype", (String)name, (String)def.getName()));
                    }
                } else {
                    type = this.typetab.checkType(name);
                    if (type == null && name.indexOf(46) == -1) {
                        type = this.typetab.checkType("java.lang." + name);
                    }
                    if (type == null) {
                        this.errorMsg.error(qn_AST.getLine(), qn_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.unknowntype", (String)name));
                    }
                }
                qn_AST.setType(84);
                qn_AST.setText(name);
                qn_AST.setFirstChild(null);
                qn_AST.setJQLType(type);
                type_AST = (JQLAST)currentAST.root;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                p = _t == ASTNULL ? null : (JQLAST)_t;
                this.primitiveType(_t);
                _t = this._retTree;
                p_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                p_AST.setJQLType(this.typetab.checkType(p_AST.getText()));
                p_AST.setType(84);
                type_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = type_AST;
        this._retTree = _t;
    }

    public final void declareVariable(AST _t) throws RecognitionException {
        JQLAST declareVariable_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST declareVariable_AST = null;
        JQLAST t_AST = null;
        JQLAST t = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        AST __t18 = _t;
        JQLAST tmp4_AST = null;
        JQLAST tmp4_AST_in = null;
        tmp4_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp4_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp4_AST);
        ASTPair __currentAST18 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 62);
        _t = _t.getFirstChild();
        t = _t == ASTNULL ? null : (JQLAST)_t;
        this.type(_t);
        _t = this._retTree;
        t_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        i = (JQLAST)_t;
        Object i_AST_in = null;
        i_AST = (JQLAST)this.astFactory.create((AST)i);
        this.astFactory.addASTChild(currentAST, (AST)i_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST18;
        _t = __t18;
        _t = _t.getNextSibling();
        String name = i_AST.getText();
        Type type = t_AST.getJQLType();
        Definition old = this.symtab.declare(name, new Variable(type));
        if (old != null) {
            this.errorMsg.error(i_AST.getLine(), i_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.alreadydeclared", (String)name, (String)old.getName()));
        }
        this.vartab.add(name);
        i_AST.setJQLType(type);
        declareVariable_AST = (JQLAST)currentAST.root;
        this.returnAST = declareVariable_AST;
        this._retTree = _t;
    }

    public final void orderSpec(AST _t) throws RecognitionException {
        JQLAST orderSpec_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST orderSpec_AST = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        AST __t23 = _t;
        JQLAST tmp5_AST = null;
        JQLAST tmp5_AST_in = null;
        tmp5_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp5_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp5_AST);
        ASTPair __currentAST23 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 63);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 6: {
                JQLAST tmp6_AST = null;
                JQLAST tmp6_AST_in = null;
                tmp6_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp6_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp6_AST);
                this.match(_t, 6);
                _t = _t.getNextSibling();
                break;
            }
            case 7: {
                JQLAST tmp7_AST = null;
                JQLAST tmp7_AST_in = null;
                tmp7_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp7_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp7_AST);
                this.match(_t, 7);
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        e = _t == ASTNULL ? null : (JQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        e_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST23;
        _t = __t23;
        _t = _t.getNextSibling();
        this.analyseOrderingExpression(e_AST);
        this.checkConstraints(e_AST, this.vartab);
        orderSpec_AST = (JQLAST)currentAST.root;
        this.returnAST = orderSpec_AST;
        this._retTree = _t;
    }

    public final void expression(AST _t) throws RecognitionException {
        JQLAST expression_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST expression_AST = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        e = _t == ASTNULL ? null : (JQLAST)_t;
        String repr = this.exprNoCheck(_t, false);
        _t = this._retTree;
        e_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        if (repr != null) {
            e_AST.setJQLType(TypeTable.errorType);
            this.errorMsg.error(e_AST.getLine(), e_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.expression.undefined", (String)repr));
        }
        expression_AST = (JQLAST)currentAST.root;
        this.returnAST = expression_AST;
        this._retTree = _t;
    }

    public final void resultExpr(AST _t) throws RecognitionException {
        JQLAST resultExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST resultExpr_AST = null;
        JQLAST d = null;
        JQLAST d_AST = null;
        JQLAST e0_AST = null;
        JQLAST e0 = null;
        JQLAST a = null;
        JQLAST a_AST = null;
        JQLAST e1_AST = null;
        JQLAST e1 = null;
        JQLAST max = null;
        JQLAST max_AST = null;
        JQLAST e2_AST = null;
        JQLAST e2 = null;
        JQLAST min = null;
        JQLAST min_AST = null;
        JQLAST e3_AST = null;
        JQLAST e3 = null;
        JQLAST s = null;
        JQLAST s_AST = null;
        JQLAST e4_AST = null;
        JQLAST e4 = null;
        JQLAST c = null;
        JQLAST c_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 8: {
                AST __t28 = _t;
                d = _t == ASTNULL ? null : (JQLAST)_t;
                Object d_AST_in = null;
                d_AST = (JQLAST)this.astFactory.create((AST)d);
                this.astFactory.addASTChild(currentAST, (AST)d_AST);
                ASTPair __currentAST28 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 8);
                _t = _t.getFirstChild();
                e0 = _t == ASTNULL ? null : (JQLAST)_t;
                this.resultExpr(_t);
                _t = this._retTree;
                e0_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST28;
                _t = __t28;
                _t = _t.getNextSibling();
                d_AST.setJQLType(e0_AST.getJQLType());
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 20: {
                AST __t29 = _t;
                a = _t == ASTNULL ? null : (JQLAST)_t;
                Object a_AST_in = null;
                a_AST = (JQLAST)this.astFactory.create((AST)a);
                this.astFactory.addASTChild(currentAST, (AST)a_AST);
                ASTPair __currentAST29 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 20);
                _t = _t.getFirstChild();
                e1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.resultExpr(_t);
                _t = this._retTree;
                e1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST29;
                _t = __t29;
                _t = _t.getNextSibling();
                a_AST.setJQLType(this.typetab.getAvgReturnType(e1_AST.getJQLType()));
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 21: {
                AST __t30 = _t;
                max = _t == ASTNULL ? null : (JQLAST)_t;
                Object max_AST_in = null;
                max_AST = (JQLAST)this.astFactory.create((AST)max);
                this.astFactory.addASTChild(currentAST, (AST)max_AST);
                ASTPair __currentAST30 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 21);
                _t = _t.getFirstChild();
                e2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.resultExpr(_t);
                _t = this._retTree;
                e2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST30;
                _t = __t30;
                _t = _t.getNextSibling();
                max_AST.setJQLType(this.typetab.getMinMaxReturnType(e2_AST.getJQLType()));
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 22: {
                AST __t31 = _t;
                min = _t == ASTNULL ? null : (JQLAST)_t;
                Object min_AST_in = null;
                min_AST = (JQLAST)this.astFactory.create((AST)min);
                this.astFactory.addASTChild(currentAST, (AST)min_AST);
                ASTPair __currentAST31 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 22);
                _t = _t.getFirstChild();
                e3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.resultExpr(_t);
                _t = this._retTree;
                e3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST31;
                _t = __t31;
                _t = _t.getNextSibling();
                min_AST.setJQLType(this.typetab.getMinMaxReturnType(e3_AST.getJQLType()));
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 23: {
                AST __t32 = _t;
                s = _t == ASTNULL ? null : (JQLAST)_t;
                Object s_AST_in = null;
                s_AST = (JQLAST)this.astFactory.create((AST)s);
                this.astFactory.addASTChild(currentAST, (AST)s_AST);
                ASTPair __currentAST32 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 23);
                _t = _t.getFirstChild();
                e4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.resultExpr(_t);
                _t = this._retTree;
                e4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST32;
                _t = __t32;
                _t = _t.getNextSibling();
                s_AST.setJQLType(this.typetab.getSumReturnType(e4_AST.getJQLType()));
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 24: {
                AST __t33 = _t;
                c = _t == ASTNULL ? null : (JQLAST)_t;
                Object c_AST_in = null;
                c_AST = (JQLAST)this.astFactory.create((AST)c);
                this.astFactory.addASTChild(currentAST, (AST)c_AST);
                ASTPair __currentAST33 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 24);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST33;
                _t = __t33;
                _t = _t.getNextSibling();
                c_AST.setJQLType(this.typetab.longType);
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 66: 
            case 67: 
            case 68: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = resultExpr_AST;
        this._retTree = _t;
    }

    public final String exprNoCheck(AST _t, boolean insideDotExpr) throws RecognitionException {
        JQLAST exprNoCheck_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST exprNoCheck_AST = null;
        String repr = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 41: 
            case 42: 
            case 44: {
                this.bitwiseExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            case 43: 
            case 45: {
                this.conditionalExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            case 28: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.relationalExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.binaryArithmeticExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            case 66: 
            case 67: {
                this.unaryArithmeticExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            case 29: 
            case 30: {
                this.complementExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 68: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                repr = this.primary(_t, insideDotExpr);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                exprNoCheck_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = exprNoCheck_AST;
        this._retTree = _t;
        return repr;
    }

    public final void bitwiseExpr(AST _t) throws RecognitionException {
        JQLAST bitwiseExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST bitwiseExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        JQLAST op3 = null;
        JQLAST op3_AST = null;
        JQLAST left3_AST = null;
        JQLAST left3 = null;
        JQLAST right3_AST = null;
        JQLAST right3 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 44: {
                AST __t39 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST39 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 44);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST39;
                _t = __t39;
                _t = _t.getNextSibling();
                op1_AST.setJQLType(this.analyseBitwiseExpr(op1_AST, left1_AST, right1_AST));
                bitwiseExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 42: {
                AST __t40 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST40 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 42);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST40;
                _t = __t40;
                _t = _t.getNextSibling();
                op2_AST.setJQLType(this.analyseBitwiseExpr(op2_AST, left2_AST, right2_AST));
                bitwiseExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 41: {
                AST __t41 = _t;
                op3 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (JQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST41 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 41);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST41;
                _t = __t41;
                _t = _t.getNextSibling();
                op3_AST.setJQLType(this.analyseBitwiseExpr(op3_AST, left3_AST, right3_AST));
                bitwiseExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = bitwiseExpr_AST;
        this._retTree = _t;
    }

    public final void conditionalExpr(AST _t) throws RecognitionException {
        JQLAST conditionalExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST conditionalExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 45: {
                AST __t43 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST43 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 45);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST43;
                _t = __t43;
                _t = _t.getNextSibling();
                op1_AST.setJQLType(this.analyseConditionalExpr(op1_AST, left1_AST, right1_AST));
                conditionalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 43: {
                AST __t44 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST44 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 43);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST44;
                _t = __t44;
                _t = _t.getNextSibling();
                op2_AST.setJQLType(this.analyseConditionalExpr(op2_AST, left2_AST, right2_AST));
                conditionalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = conditionalExpr_AST;
        this._retTree = _t;
    }

    public final void relationalExpr(AST _t) throws RecognitionException {
        JQLAST relationalExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST relationalExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        JQLAST op3 = null;
        JQLAST op3_AST = null;
        JQLAST left3_AST = null;
        JQLAST left3 = null;
        JQLAST right3_AST = null;
        JQLAST right3 = null;
        JQLAST op4 = null;
        JQLAST op4_AST = null;
        JQLAST left4_AST = null;
        JQLAST left4 = null;
        JQLAST right4_AST = null;
        JQLAST right4 = null;
        JQLAST op5 = null;
        JQLAST op5_AST = null;
        JQLAST left5_AST = null;
        JQLAST left5 = null;
        JQLAST right5_AST = null;
        JQLAST right5 = null;
        JQLAST op6 = null;
        JQLAST op6_AST = null;
        JQLAST left6_AST = null;
        JQLAST left6 = null;
        JQLAST right6_AST = null;
        JQLAST right6 = null;
        Type left = null;
        Type right = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 28: {
                AST __t46 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST46 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 28);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST46;
                _t = __t46;
                _t = _t.getNextSibling();
                op1_AST.setJQLType(this.analyseRelationalExpr(op1_AST, left1_AST, right1_AST));
                left = left1_AST.getJQLType();
                right = right1_AST.getJQLType();
                if (this.typetab.isPersistenceCapableType(left) || this.typetab.isPersistenceCapableType(right)) {
                    op1_AST.setType(69);
                } else if (this.typetab.isCollectionType(left) || this.typetab.isCollectionType(right)) {
                    op1_AST.setType(71);
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 31: {
                AST __t47 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST47 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 31);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST47;
                _t = __t47;
                _t = _t.getNextSibling();
                op2_AST.setJQLType(this.analyseRelationalExpr(op2_AST, left2_AST, right2_AST));
                left = left2_AST.getJQLType();
                right = right2_AST.getJQLType();
                if (this.typetab.isPersistenceCapableType(left) || this.typetab.isPersistenceCapableType(right)) {
                    op2_AST.setType(70);
                } else if (this.typetab.isCollectionType(left) || this.typetab.isCollectionType(right)) {
                    op2_AST.setType(72);
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 40: {
                AST __t48 = _t;
                op3 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (JQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST48 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 40);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST48;
                _t = __t48;
                _t = _t.getNextSibling();
                op3_AST.setJQLType(this.analyseRelationalExpr(op3_AST, left3_AST, right3_AST));
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 38: {
                AST __t49 = _t;
                op4 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op4_AST_in = null;
                op4_AST = (JQLAST)this.astFactory.create((AST)op4);
                this.astFactory.addASTChild(currentAST, (AST)op4_AST);
                ASTPair __currentAST49 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 38);
                _t = _t.getFirstChild();
                left4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST49;
                _t = __t49;
                _t = _t.getNextSibling();
                op4_AST.setJQLType(this.analyseRelationalExpr(op4_AST, left4_AST, right4_AST));
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 39: {
                AST __t50 = _t;
                op5 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op5_AST_in = null;
                op5_AST = (JQLAST)this.astFactory.create((AST)op5);
                this.astFactory.addASTChild(currentAST, (AST)op5_AST);
                ASTPair __currentAST50 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 39);
                _t = _t.getFirstChild();
                left5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST50;
                _t = __t50;
                _t = _t.getNextSibling();
                op5_AST.setJQLType(this.analyseRelationalExpr(op5_AST, left5_AST, right5_AST));
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 37: {
                AST __t51 = _t;
                op6 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op6_AST_in = null;
                op6_AST = (JQLAST)this.astFactory.create((AST)op6);
                this.astFactory.addASTChild(currentAST, (AST)op6_AST);
                ASTPair __currentAST51 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 37);
                _t = _t.getFirstChild();
                left6 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left6_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right6 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right6_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST51;
                _t = __t51;
                _t = _t.getNextSibling();
                op6_AST.setJQLType(this.analyseRelationalExpr(op6_AST, left6_AST, right6_AST));
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = relationalExpr_AST;
        this._retTree = _t;
    }

    public final void binaryArithmeticExpr(AST _t) throws RecognitionException {
        JQLAST binaryArithmeticExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST binaryArithmeticExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        JQLAST op3 = null;
        JQLAST op3_AST = null;
        JQLAST left3_AST = null;
        JQLAST left3 = null;
        JQLAST right3_AST = null;
        JQLAST right3 = null;
        JQLAST op4 = null;
        JQLAST op4_AST = null;
        JQLAST left4_AST = null;
        JQLAST left4 = null;
        JQLAST right4_AST = null;
        JQLAST right4 = null;
        JQLAST op5 = null;
        JQLAST op5_AST = null;
        JQLAST left5_AST = null;
        JQLAST left5 = null;
        JQLAST right5_AST = null;
        JQLAST right5 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 33: {
                AST __t53 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST53 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 33);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST53;
                _t = __t53;
                _t = _t.getNextSibling();
                op1_AST.setJQLType(this.analyseBinaryArithmeticExpr(op1_AST, left1_AST, right1_AST));
                if (op1_AST.getJQLType().equals(this.typetab.stringType)) {
                    op1_AST.setType(73);
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 34: {
                AST __t54 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST54 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 34);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST54;
                _t = __t54;
                _t = _t.getNextSibling();
                op2_AST.setJQLType(this.analyseBinaryArithmeticExpr(op2_AST, left2_AST, right2_AST));
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 35: {
                AST __t55 = _t;
                op3 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (JQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST55 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 35);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST55;
                _t = __t55;
                _t = _t.getNextSibling();
                op3_AST.setJQLType(this.analyseBinaryArithmeticExpr(op3_AST, left3_AST, right3_AST));
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 32: {
                AST __t56 = _t;
                op4 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op4_AST_in = null;
                op4_AST = (JQLAST)this.astFactory.create((AST)op4);
                this.astFactory.addASTChild(currentAST, (AST)op4_AST);
                ASTPair __currentAST56 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 32);
                _t = _t.getFirstChild();
                left4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST56;
                _t = __t56;
                _t = _t.getNextSibling();
                op4_AST.setJQLType(this.analyseBinaryArithmeticExpr(op4_AST, left4_AST, right4_AST));
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 36: {
                AST __t57 = _t;
                op5 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op5_AST_in = null;
                op5_AST = (JQLAST)this.astFactory.create((AST)op5);
                this.astFactory.addASTChild(currentAST, (AST)op5_AST);
                ASTPair __currentAST57 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 36);
                _t = _t.getFirstChild();
                left5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST57;
                _t = __t57;
                _t = _t.getNextSibling();
                op5_AST.setJQLType(this.analyseBinaryArithmeticExpr(op5_AST, left5_AST, right5_AST));
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = binaryArithmeticExpr_AST;
        this._retTree = _t;
    }

    public final void unaryArithmeticExpr(AST _t) throws RecognitionException {
        JQLAST unaryArithmeticExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST unaryArithmeticExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST arg1_AST = null;
        JQLAST arg1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST arg2_AST = null;
        JQLAST arg2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 67: {
                AST __t59 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST59 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 67);
                _t = _t.getFirstChild();
                arg1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST59;
                _t = __t59;
                _t = _t.getNextSibling();
                op1_AST.setJQLType(this.analyseUnaryArithmeticExpr(op1_AST, arg1_AST));
                unaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 66: {
                AST __t60 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST60 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 66);
                _t = _t.getFirstChild();
                arg2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST60;
                _t = __t60;
                _t = _t.getNextSibling();
                op2_AST.setJQLType(this.analyseUnaryArithmeticExpr(op2_AST, arg2_AST));
                unaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = unaryArithmeticExpr_AST;
        this._retTree = _t;
    }

    public final void complementExpr(AST _t) throws RecognitionException {
        JQLAST complementExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST complementExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST arg1_AST = null;
        JQLAST arg1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST arg2_AST = null;
        JQLAST arg2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 30: {
                AST __t62 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST62 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 30);
                _t = _t.getFirstChild();
                arg1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST62;
                _t = __t62;
                _t = _t.getNextSibling();
                op1_AST.setJQLType(this.analyseComplementExpr(op1_AST, arg1_AST));
                complementExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 29: {
                AST __t63 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST63 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 29);
                _t = _t.getFirstChild();
                arg2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST63;
                _t = __t63;
                _t = _t.getNextSibling();
                op2_AST.setJQLType(this.analyseComplementExpr(op2_AST, arg2_AST));
                complementExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = complementExpr_AST;
        this._retTree = _t;
    }

    public final String primary(AST _t, boolean insideDotExpr) throws RecognitionException {
        JQLAST primary_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST primary_AST = null;
        JQLAST c = null;
        JQLAST c_AST = null;
        JQLAST t_AST = null;
        JQLAST t = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        String repr = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 68: {
                AST __t65 = _t;
                c = _t == ASTNULL ? null : (JQLAST)_t;
                Object c_AST_in = null;
                c_AST = (JQLAST)this.astFactory.create((AST)c);
                this.astFactory.addASTChild(currentAST, (AST)c_AST);
                ASTPair __currentAST65 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 68);
                _t = _t.getFirstChild();
                t = _t == ASTNULL ? null : (JQLAST)_t;
                this.type(_t);
                _t = this._retTree;
                t_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                e = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                e_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST65;
                _t = __t65;
                _t = _t.getNextSibling();
                Type type = t_AST.getJQLType();
                Type exprType = e_AST.getJQLType();
                if (!type.isCompatibleWith(exprType) && !exprType.isCompatibleWith(type)) {
                    this.errorMsg.error(c_AST.getLine(), c_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.primary.invalidcast", (String)exprType.getName(), (String)type.getName()));
                    type = TypeTable.errorType;
                }
                c_AST.setJQLType(type);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 49: 
            case 50: 
            case 53: 
            case 95: 
            case 96: 
            case 97: {
                this.literal(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 5: {
                i = (JQLAST)_t;
                Object i_AST_in = null;
                i_AST = (JQLAST)this.astFactory.create((AST)i);
                this.astFactory.addASTChild(currentAST, (AST)i_AST);
                this.match(_t, 5);
                _t = _t.getNextSibling();
                i_AST.setJQLType(this.candidateClass);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 94: {
                repr = this.dotExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 56: {
                repr = this.identifier(_t, insideDotExpr);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = primary_AST;
        this._retTree = _t;
        return repr;
    }

    public final void literal(AST _t) throws RecognitionException {
        JQLAST literal_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST literal_AST = null;
        JQLAST b1 = null;
        JQLAST b1_AST = null;
        JQLAST b2 = null;
        JQLAST b2_AST = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        JQLAST l = null;
        JQLAST l_AST = null;
        JQLAST f = null;
        JQLAST f_AST = null;
        JQLAST d = null;
        JQLAST d_AST = null;
        JQLAST c = null;
        JQLAST c_AST = null;
        JQLAST s = null;
        JQLAST s_AST = null;
        JQLAST n = null;
        JQLAST n_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 18: {
                b1 = (JQLAST)_t;
                Object b1_AST_in = null;
                b1_AST = (JQLAST)this.astFactory.create((AST)b1);
                this.astFactory.addASTChild(currentAST, (AST)b1_AST);
                this.match(_t, 18);
                _t = _t.getNextSibling();
                b1_AST.setJQLType(this.typetab.booleanType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 19: {
                b2 = (JQLAST)_t;
                Object b2_AST_in = null;
                b2_AST = (JQLAST)this.astFactory.create((AST)b2);
                this.astFactory.addASTChild(currentAST, (AST)b2_AST);
                this.match(_t, 19);
                _t = _t.getNextSibling();
                b2_AST.setJQLType(this.typetab.booleanType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 53: {
                i = (JQLAST)_t;
                Object i_AST_in = null;
                i_AST = (JQLAST)this.astFactory.create((AST)i);
                this.astFactory.addASTChild(currentAST, (AST)i_AST);
                this.match(_t, 53);
                _t = _t.getNextSibling();
                i_AST.setJQLType(this.typetab.intType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 95: {
                l = (JQLAST)_t;
                Object l_AST_in = null;
                l_AST = (JQLAST)this.astFactory.create((AST)l);
                this.astFactory.addASTChild(currentAST, (AST)l_AST);
                this.match(_t, 95);
                _t = _t.getNextSibling();
                l_AST.setJQLType(this.typetab.longType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 96: {
                f = (JQLAST)_t;
                Object f_AST_in = null;
                f_AST = (JQLAST)this.astFactory.create((AST)f);
                this.astFactory.addASTChild(currentAST, (AST)f_AST);
                this.match(_t, 96);
                _t = _t.getNextSibling();
                f_AST.setJQLType(this.typetab.floatType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 97: {
                d = (JQLAST)_t;
                Object d_AST_in = null;
                d_AST = (JQLAST)this.astFactory.create((AST)d);
                this.astFactory.addASTChild(currentAST, (AST)d_AST);
                this.match(_t, 97);
                _t = _t.getNextSibling();
                d_AST.setJQLType(this.typetab.doubleType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 49: {
                c = (JQLAST)_t;
                Object c_AST_in = null;
                c_AST = (JQLAST)this.astFactory.create((AST)c);
                this.astFactory.addASTChild(currentAST, (AST)c_AST);
                this.match(_t, 49);
                _t = _t.getNextSibling();
                c_AST.setJQLType(this.typetab.charType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 50: {
                s = (JQLAST)_t;
                Object s_AST_in = null;
                s_AST = (JQLAST)this.astFactory.create((AST)s);
                this.astFactory.addASTChild(currentAST, (AST)s_AST);
                this.match(_t, 50);
                _t = _t.getNextSibling();
                s_AST.setJQLType(this.typetab.stringType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            case 17: {
                n = (JQLAST)_t;
                Object n_AST_in = null;
                n_AST = (JQLAST)this.astFactory.create((AST)n);
                this.astFactory.addASTChild(currentAST, (AST)n_AST);
                this.match(_t, 17);
                _t = _t.getNextSibling();
                n_AST.setJQLType(TypeTable.nullType);
                literal_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = literal_AST;
        this._retTree = _t;
    }

    public final String dotExpr(AST _t) throws RecognitionException {
        JQLAST dotExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST dotExpr_AST = null;
        JQLAST dot = null;
        JQLAST dot_AST = null;
        JQLAST expr_AST = null;
        JQLAST expr = null;
        JQLAST ident = null;
        JQLAST ident_AST = null;
        JQLAST args_AST = null;
        JQLAST args = null;
        String repr = null;
        AST __t67 = _t;
        dot = _t == ASTNULL ? null : (JQLAST)_t;
        Object dot_AST_in = null;
        dot_AST = (JQLAST)this.astFactory.create((AST)dot);
        this.astFactory.addASTChild(currentAST, (AST)dot_AST);
        ASTPair __currentAST67 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 94);
        _t = _t.getFirstChild();
        expr = _t == ASTNULL ? null : (JQLAST)_t;
        repr = this.exprNoCheck(_t, true);
        _t = this._retTree;
        expr_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        ident = (JQLAST)_t;
        Object ident_AST_in = null;
        ident_AST = (JQLAST)this.astFactory.create((AST)ident);
        this.astFactory.addASTChild(currentAST, (AST)ident_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 65: {
                args = _t == ASTNULL ? null : (JQLAST)_t;
                this.argList(_t);
                _t = this._retTree;
                args_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        currentAST = __currentAST67;
        _t = __t67;
        _t = _t.getNextSibling();
        dotExpr_AST = (JQLAST)currentAST.root;
        Type type = null;
        if (repr != null) {
            String qualifiedName = repr + '.' + ident_AST.getText();
            type = this.typetab.checkType(qualifiedName);
            if (type == null) {
                repr = qualifiedName;
            } else if (args_AST == null) {
                repr = null;
                dot_AST.setType(84);
                dot_AST.setText(qualifiedName);
                dot_AST.setFirstChild(null);
            } else {
                repr = null;
                this.errorMsg.error(dot.getLine(), dot.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.invalidmethodcall"));
            }
            dot_AST.setJQLType(type);
            dot_AST.setText(expr_AST.getText() + '.' + ident_AST.getText());
        } else {
            dotExpr_AST = this.analyseDotExpr(dot_AST, expr_AST, ident_AST, args_AST);
        }
        currentAST.root = dotExpr_AST;
        currentAST.child = dotExpr_AST != null && dotExpr_AST.getFirstChild() != null ? dotExpr_AST.getFirstChild() : dotExpr_AST;
        currentAST.advanceChildToEnd();
        dotExpr_AST = (JQLAST)currentAST.root;
        this.returnAST = dotExpr_AST;
        this._retTree = _t;
        return repr;
    }

    public final String identifier(AST _t, boolean insideDotExpr) throws RecognitionException {
        JQLAST identifier_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST identifier_AST = null;
        JQLAST ident = null;
        JQLAST ident_AST = null;
        JQLAST args_AST = null;
        JQLAST args = null;
        String repr = null;
        ident = (JQLAST)_t;
        Object ident_AST_in = null;
        ident_AST = (JQLAST)this.astFactory.create((AST)ident);
        this.astFactory.addASTChild(currentAST, (AST)ident_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 65: {
                args = _t == ASTNULL ? null : (JQLAST)_t;
                this.argList(_t);
                _t = this._retTree;
                args_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                break;
            }
            case 3: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 53: 
            case 56: 
            case 66: 
            case 67: 
            case 68: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        String name = ident_AST.getText();
        Definition def = this.symtab.getDefinition(name);
        if (args_AST != null) {
            ident_AST.setJQLType(TypeTable.errorType);
            this.errorMsg.error(ident_AST.getLine(), ident_AST.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.generic.invalidmethodcall"));
        } else if (def != null) {
            ident_AST = this.analyseDefinedIdentifier(ident_AST, def);
        } else if (insideDotExpr) {
            Definition typedef = this.typeNames.getDefinition(name);
            if (typedef != null) {
                ident_AST = this.analyseDefinedIdentifier(ident_AST, typedef);
            } else {
                repr = ident_AST.getText();
            }
        } else {
            ident_AST.setJQLType(TypeTable.errorType);
            this.errorMsg.error(ident.getLine(), ident.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.semantic.identifier.undefined", (String)ident.getText()));
        }
        identifier_AST = (JQLAST)currentAST.root;
        this.returnAST = identifier_AST;
        this._retTree = _t;
        return repr;
    }

    public final void argList(AST _t) throws RecognitionException {
        JQLAST argList_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST argList_AST = null;
        AST __t70 = _t;
        JQLAST tmp8_AST = null;
        JQLAST tmp8_AST_in = null;
        tmp8_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp8_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp8_AST);
        ASTPair __currentAST70 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 65);
        _t = _t.getFirstChild();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            this.expression(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        currentAST = __currentAST70;
        _t = __t70;
        _t = _t.getNextSibling();
        argList_AST = (JQLAST)currentAST.root;
        this.returnAST = argList_AST;
        this._retTree = _t;
    }

    public final void primitiveType(AST _t) throws RecognitionException {
        JQLAST primitiveType_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST primitiveType_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 9: {
                JQLAST tmp9_AST = null;
                JQLAST tmp9_AST_in = null;
                tmp9_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp9_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp9_AST);
                this.match(_t, 9);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 10: {
                JQLAST tmp10_AST = null;
                JQLAST tmp10_AST_in = null;
                tmp10_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp10_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp10_AST);
                this.match(_t, 10);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 11: {
                JQLAST tmp11_AST = null;
                JQLAST tmp11_AST_in = null;
                tmp11_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp11_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp11_AST);
                this.match(_t, 11);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 12: {
                JQLAST tmp12_AST = null;
                JQLAST tmp12_AST_in = null;
                tmp12_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp12_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp12_AST);
                this.match(_t, 12);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 13: {
                JQLAST tmp13_AST = null;
                JQLAST tmp13_AST_in = null;
                tmp13_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp13_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp13_AST);
                this.match(_t, 13);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 14: {
                JQLAST tmp14_AST = null;
                JQLAST tmp14_AST_in = null;
                tmp14_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp14_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp14_AST);
                this.match(_t, 14);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 15: {
                JQLAST tmp15_AST = null;
                JQLAST tmp15_AST_in = null;
                tmp15_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp15_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp15_AST);
                this.match(_t, 15);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 16: {
                JQLAST tmp16_AST = null;
                JQLAST tmp16_AST_in = null;
                tmp16_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp16_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp16_AST);
                this.match(_t, 16);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = primitiveType_AST;
        this._retTree = _t;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{82824011629592608L, 16106127388L, 0L, 0L};
        return data;
    }
}

