/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.util.HashMap;
import java.util.Map;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.config.ConfigurationException;
import org.jvnet.hk2.config.Dom;

@Contract
public abstract class ConfigInjector<T> {
    private static final Map<String, Boolean> BOOLEAN_VALUES = new HashMap<String, Boolean>();

    public abstract void inject(Dom var1, T var2);

    public abstract void injectElement(Dom var1, String var2, T var3);

    public abstract void injectAttribute(Dom var1, String var2, T var3);

    public final int asInt(String v) {
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(v + " is not a number");
        }
    }

    public final boolean asBoolean(String v) {
        Boolean b = BOOLEAN_VALUES.get(v);
        if (b != null) {
            return b;
        }
        throw new ConfigurationException(v + " is not a boolean");
    }

    public final <T> T reference(Dom dom, String id, Class<T> type) {
        String name = type.getName();
        dom = dom.getSymbolSpaceRoot(name);
        return type.cast(dom.resolveReference(id, name).get());
    }

    static {
        for (String t : new String[]{"on", "true", "1", "yes", "enabled"}) {
            BOOLEAN_VALUES.put(t, true);
        }
        for (String t : new String[]{"off", "false", "0", "no", "disabled"}) {
            BOOLEAN_VALUES.put(t, false);
        }
    }
}

