/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.transform;

import org.glassfish.loadbalancer.admin.cli.beans.Cluster;
import org.glassfish.loadbalancer.admin.cli.beans.WebModule;
import org.glassfish.loadbalancer.admin.cli.reader.api.BaseReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.IdempotentUrlPatternReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.WebModuleReader;
import org.glassfish.loadbalancer.admin.cli.transform.IdempotentUrlPatternVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;

public class WebModuleVisitor
implements Visitor {
    WebModule _w = null;
    Cluster _c = null;

    public WebModuleVisitor(WebModule w, Cluster c) {
        this._w = w;
        this._c = c;
    }

    @Override
    public void visit(BaseReader br) throws Exception {
        if (br instanceof BaseReader) {
            WebModuleReader wRdr = (WebModuleReader)br;
            this._w.setContextRoot(wRdr.getContextRoot());
            String url = wRdr.getErrorUrl();
            if (url != null && !"".equals(url)) {
                this._c.createAttribute("WebModule", "error-url", "ErrorUrl", 1, null, "");
                this._w.setErrorUrl(wRdr.getErrorUrl());
            }
            this._w.setEnabled(Boolean.toString(wRdr.getLbEnabled()));
            this._w.setDisableTimeoutInMinutes(wRdr.getDisableTimeoutInMinutes());
            IdempotentUrlPatternReader[] iRdrs = wRdr.getIdempotentUrlPattern();
            if (iRdrs != null && iRdrs.length > 0) {
                for (int i = 0; i < iRdrs.length; ++i) {
                    iRdrs[i].accept(new IdempotentUrlPatternVisitor(this._w, i));
                }
            }
        }
    }
}

