/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobPatternMatcherImpl {
    private static final Logger logger = Logger.getLogger(GlobPatternMatcherImpl.class.getName());

    public boolean matchWithoutBackslashEscape(String toMatch, String pattern) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(GlobPatternMatcherImpl.class.getName(), "match", "Trying to match string: " + toMatch + " against un-normalized pattern: " + pattern);
        }
        boolean isMatch = false;
        if (pattern == null || pattern.length() == 0 || toMatch == null || toMatch.length() == 0) {
            throw new IllegalArgumentException("Pattern = " + pattern + "and string to match = " + toMatch + ", but both pattern and to-match String are required to be non-null Strings with length >=1 ");
        }
        String newPattern = pattern;
        while (newPattern.indexOf("**") >= 0) {
            newPattern = newPattern.replace("**", "*");
        }
        isMatch = this.recursiveMatch(toMatch, newPattern);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(GlobPatternMatcherImpl.class.getName(), "match", "Returning boolean: " + isMatch);
        }
        return isMatch;
    }

    private boolean recursiveMatch(String toMatch, String subpattern) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Trying to do a recursive match of string: " + toMatch + " against subpattern: " + subpattern);
        }
        int firstAsterisk = subpattern.indexOf("*");
        int secondAsterisk = subpattern.indexOf("*", firstAsterisk + 1);
        int lastAsterisk = subpattern.lastIndexOf("*");
        if (firstAsterisk == -1) {
            return this.matchNoAsterisk(toMatch, subpattern);
        }
        if (firstAsterisk > 0) {
            String beginPattern = subpattern.substring(0, firstAsterisk);
            if (toMatch.length() < beginPattern.length()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Returning false, not enough chars to match against beginning of pattern: " + beginPattern);
                }
                return false;
            }
            String beginToMatch = toMatch.substring(0, firstAsterisk);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Matching against beginning of pattern (before first asterisk).");
            }
            if (!this.matchNoAsterisk(beginToMatch, beginPattern)) {
                return false;
            }
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.finest("No beginning of pattern (before first asterisk) to match against.");
        }
        String remainingToMatch = toMatch.substring(firstAsterisk);
        if (lastAsterisk < subpattern.length() - 1) {
            String endPattern = subpattern.substring(lastAsterisk + 1);
            if (remainingToMatch.length() < endPattern.length()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Returning false, not enough chars in remaining string " + remainingToMatch + " to match against end of pattern: " + endPattern);
                }
                return false;
            }
            String endToMatch = remainingToMatch.substring(remainingToMatch.length() - endPattern.length(), remainingToMatch.length());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Matching against end of pattern (after last asterisk).");
            }
            if (!this.matchNoAsterisk(endToMatch, endPattern)) {
                return false;
            }
            remainingToMatch = remainingToMatch.substring(0, remainingToMatch.length() - endPattern.length());
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.finest("No end of pattern (after last asterisk) to match against.");
        }
        if (firstAsterisk == lastAsterisk) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Returning true, remaining string matches single '*'");
            }
            return true;
        }
        if (secondAsterisk == lastAsterisk) {
            String middlePattern = subpattern.substring(firstAsterisk + 1, lastAsterisk);
            if (remainingToMatch.length() < middlePattern.length()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Returning false, remaining string: " + remainingToMatch + " is shorter than non-asterisk middle pattern: " + middlePattern);
                }
                return false;
            }
            for (int i = 0; i <= remainingToMatch.length() - middlePattern.length(); ++i) {
                String matchCandidate = remainingToMatch.substring(i, i + middlePattern.length());
                if (!this.matchNoAsterisk(matchCandidate, middlePattern)) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Returning true, matched candidate: " + matchCandidate + " against non-asterisk middle pattern: " + middlePattern);
                }
                return true;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Returning false, no match found within string: " + remainingToMatch + " against non-asterisk middle pattern: " + middlePattern);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Trying to match: " + remainingToMatch + " against pattern containing at least three asterisks.");
        }
        String patternBetweenAsterisk1and2 = subpattern.substring(firstAsterisk + 1, secondAsterisk);
        ArrayList<String> subMatchCandidates = new ArrayList<String>();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Begin looping looking to match pattern between first and second asterisk; pattern = " + patternBetweenAsterisk1and2);
        }
        for (int i = 0; i <= remainingToMatch.length() - patternBetweenAsterisk1and2.length(); ++i) {
            String matchCandidate = remainingToMatch.substring(i, i + patternBetweenAsterisk1and2.length());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Next match candidate = " + matchCandidate);
            }
            if (!this.matchNoAsterisk(matchCandidate, patternBetweenAsterisk1and2)) continue;
            String subMatchCandidate = remainingToMatch.substring(i + patternBetweenAsterisk1and2.length());
            subMatchCandidates.add(subMatchCandidate);
        }
        if (subMatchCandidates.size() == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Returning false, no matches of pattern: " + patternBetweenAsterisk1and2 + " in remainingToMatch = " + remainingToMatch);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Found " + subMatchCandidates.size() + " candidates to recursively match against.");
        }
        String nestedPattern = subpattern.substring(secondAsterisk, lastAsterisk + 1);
        for (String candidate : subMatchCandidates) {
            boolean match;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Do a recursive match of candidate: " + candidate + " against nested pattern: " + nestedPattern);
            }
            if (!(match = this.recursiveMatch(candidate, nestedPattern))) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Found that nested, recursive match=true so returning 'true'");
            }
            return true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("No recursive match candidates matched so returning 'false'");
        }
        return false;
    }

    private boolean matchNoAsterisk(String toMatch, String subpattern) {
        int subpatternLen;
        int toMatchLen;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Entering matchNoAsterisk with  toMatch = " + toMatch + " and subpattern = " + subpattern);
        }
        if ((toMatchLen = toMatch.length()) != (subpatternLen = subpattern.length())) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("FAIL: in matchNoAsterisk:  toMatchLen = " + toMatchLen + " != subpatternLen = " + subpatternLen);
            }
            return false;
        }
        for (int i = 0; i < toMatchLen; ++i) {
            if (subpattern.substring(i, i + 1).equals("*")) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("FAIL: in matchNoAsterisk: Shouldn't have encountered a '*' in matchNoAsterisk, toMatch = " + toMatch + ", subPattern = " + subpattern);
                }
                throw new IllegalStateException("Shouldn't have encountered a '*' in matchNoAsterisk, toMatch = " + toMatch + ", subPattern = " + subpattern);
            }
            if (subpattern.substring(i, i + 1).equals("?") || subpattern.charAt(i) == toMatch.charAt(i)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("FAIL: in matchNoAsterisk: mismatch at index: " + i + ". The char subpattern.charAt(i)= " + subpattern.charAt(i) + " != toMatch.charAt(i) = " + toMatch.charAt(i));
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SUCCESS: in matchNoAsterisk");
        }
        return true;
    }
}

