/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignalHandler
implements Runnable {
    private final BlockingQueue<SignalPacket> signalQueue;
    private final Router router;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private AtomicBoolean stopped = new AtomicBoolean(false);

    public SignalHandler(BlockingQueue<SignalPacket> packetQueue, Router router) {
        this.signalQueue = packetQueue;
        this.router = router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.stopped.get()) {
                SignalPacket signalPacket = null;
                try {
                    signalPacket = this.signalQueue.take();
                    if (signalPacket == null) continue;
                    Signal[] signals = signalPacket.getSignals();
                    if (signals != null) {
                        this.handleSignals(signals);
                        continue;
                    }
                    this.handleSignal(signalPacket.getSignal());
                }
                catch (InterruptedException e) {
                    this.stopped.set(true);
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, "sig.handler.unhandled", new Object[]{Thread.currentThread().getName()});
                    this.logger.log(Level.WARNING, "stack trace", e);
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.log(Level.INFO, "sig.handler.thread.terminated", new Object[]{Thread.currentThread().getName()});
            throw throwable;
        }
        this.logger.log(Level.INFO, "sig.handler.thread.terminated", new Object[]{Thread.currentThread().getName()});
    }

    private void handleSignal(Signal signal) {
        this.analyzeSignal(signal);
    }

    private void handleSignals(Signal[] signals) {
        for (Signal signal : signals) {
            this.analyzeSignal(signal);
        }
    }

    private void analyzeSignal(Signal signal) {
        if (signal == null) {
            throw new IllegalArgumentException("Signal is null. Cannot analyze.");
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "SignalHandler : processing a received signal " + signal.getClass().getName());
        }
        try {
            if (signal instanceof FailureRecoverySignal) {
                this.router.notifyFailureRecoveryAction((FailureRecoverySignal)signal);
            } else if (signal instanceof FailureNotificationSignal) {
                this.router.aliveAndReadyView.processNotification(signal);
                this.router.notifyFailureNotificationAction((FailureNotificationSignal)signal);
            } else if (signal instanceof MessageSignal) {
                this.router.notifyMessageAction((MessageSignal)signal);
            } else if (signal instanceof JoinNotificationSignal) {
                this.router.notifyJoinNotificationAction((JoinNotificationSignal)signal);
            } else if (signal instanceof PlannedShutdownSignal) {
                this.router.aliveAndReadyView.processNotification(signal);
                this.router.notifyPlannedShutdownAction((PlannedShutdownSignal)signal);
            } else if (signal instanceof FailureSuspectedSignal) {
                this.router.notifyFailureSuspectedAction((FailureSuspectedSignal)signal);
            } else if (signal instanceof JoinedAndReadyNotificationSignal) {
                this.router.aliveAndReadyView.processNotification(signal);
                this.router.notifyJoinedAndReadyNotificationAction((JoinedAndReadyNotificationSignal)signal);
            } else if (signal instanceof GroupLeadershipNotificationSignal) {
                this.router.notifyGroupLeadershipNotificationAction((GroupLeadershipNotificationSignal)signal);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "sig.handler.ignoring.exception", new Object[]{t.getLocalizedMessage()});
            this.logger.log(Level.WARNING, t.getLocalizedMessage(), t);
        }
    }

    public void stop(Thread t) {
        this.stopped.set(true);
        t.interrupt();
    }
}

