/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.customization.ClassCustomizationBuilder;
import org.eclipse.yasson.internal.model.customization.CreatorCustomization;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;

public class CreatorModel {
    private final String name;
    private final Type type;
    private final CreatorCustomization creatorCustomization;

    public CreatorModel(String name, Parameter parameter, JsonbContext context) {
        this.name = name;
        this.type = parameter.getType();
        AnnotationIntrospector annotationIntrospector = context.getAnnotationIntrospector();
        JsonbAnnotatedElement<Parameter> annotated = new JsonbAnnotatedElement<Parameter>(parameter);
        JsonbNumberFormatter constructorNumberFormatter = context.getAnnotationIntrospector().getConstructorNumberFormatter(annotated);
        JsonbDateFormatter constructorDateFormatter = context.getAnnotationIntrospector().getConstructorDateFormatter(annotated);
        JsonbAnnotatedElement<Class<?>> clsElement = annotationIntrospector.collectAnnotations(parameter.getType());
        ClassCustomizationBuilder builder = new ClassCustomizationBuilder();
        builder.setAdapterInfo(annotationIntrospector.getAdapterBinding(clsElement));
        builder.setDeserializerBinding(annotationIntrospector.getDeserializerBinding(clsElement));
        builder.setSerializerBinding(annotationIntrospector.getSerializerBinding(clsElement));
        this.creatorCustomization = new CreatorCustomization(builder, constructorNumberFormatter, constructorDateFormatter);
    }

    public String getName() {
        return this.name;
    }

    public CreatorCustomization getCustomization() {
        return this.creatorCustomization;
    }

    public Type getType() {
        return this.type;
    }
}

