/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.event;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.faces.event.AbortProcessingException;

public abstract class Command
implements Serializable {
    public static final String COMMAND_KEY = "jsftCommand";
    private static final long serialVersionUID = 6945415932011238909L;
    private List<Command> childCommands = null;
    private Command elseCommand = null;

    public Command() {
    }

    public Command(List<Command> children, Command elseCommand) {
        this.setChildCommands(children);
        this.setElseCommand(elseCommand);
    }

    public abstract Object invoke() throws AbortProcessingException;

    public Command getElseCommand() {
        return this.elseCommand;
    }

    public List<Command> getChildCommands() {
        return this.childCommands;
    }

    public void invokeChildCommands() {
        if (this.childCommands != null) {
            for (Command childCommand : this.childCommands) {
                childCommand.invoke();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("");
        if (this.childCommands != null) {
            buf.append("{\n");
            Iterator<Command> it = this.childCommands.iterator();
            while (it.hasNext()) {
                buf.append(it.next().toString());
            }
            buf.append("}\n");
        } else {
            buf.append(";\n");
        }
        return buf.toString();
    }

    private void setChildCommands(List<Command> commands) {
        this.childCommands = commands;
    }

    private void setElseCommand(Command command) {
        this.elseCommand = command;
    }
}

