/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ConnectionPool;
import java.util.Hashtable;
import javax.transaction.Transaction;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class UnpooledResource
extends ConnectionPool {
    private int poolSize;

    public UnpooledResource(PoolInfo poolInfo, Hashtable env) throws PoolingException {
        super(poolInfo, env);
        this.failAllConnections = false;
    }

    @Override
    protected synchronized void initPool(ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.poolSize = 0;
        this.poolInitialized = true;
    }

    @Override
    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) {
        return null;
    }

    @Override
    protected void reconfigureSteadyPoolSize(int oldSteadyPoolSize, int newSteadyPoolSize) throws PoolingException {
    }

    @Override
    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle handle = null;
        if (this.incrementPoolSize()) {
            try {
                handle = this.createSingleResource(alloc);
            }
            catch (PoolingException ex) {
                this.decrementPoolSize();
                throw ex;
            }
            ResourceState state = new ResourceState();
            handle.setResourceState(state);
            state.setEnlisted(false);
            this.setResourceStateToBusy(handle);
            return handle;
        }
        String msg = localStrings.getStringWithDefault("poolmgr.max.pool.size.reached", "In-use connections equal max-pool-size therefore cannot allocate any more connections.");
        throw new PoolingException(msg);
    }

    @Override
    public void resourceErrorOccurred(ResourceHandle resourceHandle) throws IllegalStateException {
        this.freeResource(resourceHandle);
    }

    @Override
    protected void freeResource(ResourceHandle resourceHandle) {
        this.decrementPoolSize();
        this.deleteResource(resourceHandle);
    }

    private synchronized boolean incrementPoolSize() {
        if (this.poolSize >= this.maxPoolSize) {
            _logger.info("Fail as poolSize : " + this.poolSize);
            return false;
        }
        ++this.poolSize;
        return true;
    }

    private synchronized void decrementPoolSize() {
        --this.poolSize;
    }
}

