/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;

public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
        super("<one-to-many>");
    }

    public OneToManyAccessor(MetadataAnnotation oneToMany, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(oneToMany, (MetadataAccessibleObject)annotatedElement, classAccessor);
        if (oneToMany != null) {
            this.setOrphanRemoval(oneToMany.getAttributeBooleanDefaultFalse("orphanRemoval"));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof OneToManyAccessor;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        if (this.getDescriptor().getClassDescriptor().isEISDescriptor()) {
            this.processManyToManyMapping();
        } else if (this.hasMappedBy()) {
            this.processOneToManyMapping();
        } else if (this.getJoinColumns().isEmpty()) {
            this.processManyToManyMapping();
        } else {
            this.processUnidirectionalOneToManyMapping();
        }
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isUnidirectionalOneToManyMapping()) {
            UnidirectionalOneToManyMapping overrideMapping = new UnidirectionalOneToManyMapping();
            overrideMapping.setAttributeName(this.getAttributeName());
            this.processUnidirectionalOneToManyTargetForeignKeyRelationship(overrideMapping, associationOverride.getJoinColumns(), owningDescriptor);
            embeddableMapping.addOverrideUnidirectionalOneToManyMapping(overrideMapping);
            this.setOverrideMapping((DatabaseMapping)overrideMapping);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processManyToManyMapping() {
        CollectionMapping mapping = this.getDescriptor().getClassDescriptor().newManyToManyMapping();
        this.process(mapping);
        if (mapping instanceof ManyToManyMapping) {
            ((ManyToManyMapping)mapping).setDefinedAsOneToManyMapping(true);
            this.processJoinTable((ForeignReferenceMapping)mapping, ((ManyToManyMapping)mapping).getRelationTableMechanism(), this.getJoinTableMetadata());
        } else if (mapping instanceof EISOneToManyMapping) {
            this.processEISOneToManyMapping((EISOneToManyMapping)mapping);
        }
    }

    protected void processOneToManyMapping() {
        DatabaseMapping owningMapping = this.getOwningMapping();
        if (owningMapping.isOneToOneMapping()) {
            OneToOneMapping ownerMapping = (OneToOneMapping)owningMapping;
            if (ownerMapping.hasRelationTableMechanism()) {
                ManyToManyMapping mapping = new ManyToManyMapping();
                this.process((CollectionMapping)mapping);
                this.processMappedByRelationTable(ownerMapping.getRelationTableMechanism(), mapping.getRelationTableMechanism());
                mapping.setIsReadOnly(true);
                mapping.setMappedBy(this.getMappedBy());
            } else {
                OneToManyMapping mapping = new OneToManyMapping();
                this.process((CollectionMapping)mapping);
                Map keys = ownerMapping.getSourceToTargetKeyFields();
                for (DatabaseField fkField : keys.keySet()) {
                    DatabaseField pkField = (DatabaseField)keys.get(fkField);
                    if (this.getDescriptor().usesTablePerClassInheritanceStrategy() && !pkField.getTable().equals(this.getDescriptor().getPrimaryTable())) {
                        pkField = pkField.clone();
                        pkField.setTable(this.getDescriptor().getPrimaryTable());
                    }
                    mapping.addTargetForeignKeyField(fkField, pkField);
                }
                mapping.setMappedBy(this.getMappedBy());
            }
        } else {
            throw ValidationException.invalidMapping((Object)this.getJavaClass(), (Object)this.getReferenceClass());
        }
    }

    protected void processUnidirectionalOneToManyMapping() {
        UnidirectionalOneToManyMapping mapping = new UnidirectionalOneToManyMapping();
        this.process((CollectionMapping)mapping);
        this.processUnidirectionalOneToManyTargetForeignKeyRelationship(mapping, this.getJoinColumns(this.getJoinColumns(), this.getOwningDescriptor()), this.getOwningDescriptor());
    }

    protected void processUnidirectionalOneToManyTargetForeignKeyRelationship(UnidirectionalOneToManyMapping mapping, List<JoinColumnMetadata> joinColumns, MetadataDescriptor owningDescriptor) {
        String defaultFKFieldName = String.valueOf(this.getDefaultAttributeName()) + "_" + owningDescriptor.getPrimaryKeyFieldName();
        for (JoinColumnMetadata joinColumn : joinColumns) {
            MappingAccessor mappingAccessor;
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), owningDescriptor, "metadata_default_pk_column");
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            this.setFieldName(fkField, defaultFKFieldName, "metadata_default_fk_column");
            if (!fkField.hasTableName()) {
                fkField.setTable(this.getReferenceDescriptor().getPrimaryTable());
            }
            if ((mappingAccessor = owningDescriptor.getPrimaryKeyAccessorForField(pkField)) != null) {
                Class fieldClassification = mappingAccessor.getMapping().getFieldClassification(mappingAccessor.getMapping().getField());
                String typeName = fieldClassification == null ? mappingAccessor.getRawClass().getName() : fieldClassification.getName();
                fkField.setTypeName(typeName);
            }
            mapping.addTargetForeignKeyField(fkField, pkField);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }
}

