/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.glassfish.cdi.transaction.TransactionScopedCDIUtil;
import org.glassfish.cdi.transaction.TransactionScopedContextImpl;

public class TransactionScopedBean<T>
implements Synchronization {
    private T contextualInstance;
    private Contextual<T> contextual;
    private CreationalContext<T> creationalContext;
    private TransactionScopedContextImpl transactionScopedContext;

    public TransactionScopedBean(Contextual<T> contextual, CreationalContext<T> creationalContext, TransactionScopedContextImpl transactionScopedContext) {
        this.contextual = contextual;
        this.creationalContext = creationalContext;
        this.transactionScopedContext = transactionScopedContext;
        this.contextualInstance = contextual.create(creationalContext);
    }

    public T getContextualInstance() {
        return this.contextualInstance;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        try {
            Set<TransactionScopedBean> transactionScopedBeanSet;
            TransactionSynchronizationRegistry transactionSynchronizationRegistry = this.getTransactionSynchronizationRegistry();
            if (transactionSynchronizationRegistry != null && this.transactionScopedContext != null && (transactionScopedBeanSet = this.transactionScopedContext.beansPerTransaction.get(transactionSynchronizationRegistry)) != null) {
                if (transactionScopedBeanSet.contains(this)) {
                    transactionScopedBeanSet.remove(this);
                }
                if (transactionScopedBeanSet.size() == 0) {
                    TransactionScopedCDIUtil.fireEvent("DESTORYED_EVENT");
                    this.transactionScopedContext.beansPerTransaction.remove(transactionSynchronizationRegistry);
                }
            }
        }
        catch (NamingException ne) {
            TransactionScopedCDIUtil.log("Can't get instance of TransactionSynchronizationRegistry to process TransactionScoped Destroyed CDI Event!");
            ne.printStackTrace();
        }
        finally {
            this.contextual.destroy(this.contextualInstance, this.creationalContext);
        }
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() throws NamingException {
        InitialContext initialContext = new InitialContext();
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)initialContext.lookup("java:comp/TransactionSynchronizationRegistry");
        return transactionSynchronizationRegistry;
    }
}

