/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Profiler {
    Map<String, String> config;
    List<String> jvmOptions;
    private boolean enabled;

    Profiler(Map<String, String> config, List<String> jvmOptions, Map<String, String> sysProps) {
        this.config = config;
        this.enabled = Boolean.parseBoolean(this.config.get("enabled"));
        this.jvmOptions = jvmOptions;
        jvmOptions.addAll(this.getPropertiesAsJvmOptions(sysProps));
    }

    List<String> getJvmOptions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return this.jvmOptions;
    }

    Map<String, String> getConfig() {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        return this.config;
    }

    List<File> getClasspath() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        String cp = this.config.get("classpath");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return Collections.emptyList();
    }

    List<File> getNativePath() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        String cp = this.config.get("native-library-path");
        if (GFLauncherUtils.ok((String)cp)) {
            return GFLauncherUtils.stringToFiles((String)cp);
        }
        return Collections.emptyList();
    }

    boolean isEnabled() {
        return this.enabled;
    }

    private List<String> getPropertiesAsJvmOptions(Map<String, String> props) {
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, String>> entries = props.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                list.add("-D" + name + "=" + value);
                continue;
            }
            list.add("-D" + name);
        }
        return list;
    }
}

