/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.Base64;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;

public class ByteArrayBase64Deserializer
extends AbstractValueTypeDeserializer<byte[]> {
    public ByteArrayBase64Deserializer(Customization customization) {
        super(byte[].class, customization);
    }

    @Override
    protected byte[] deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.getDecoder(unmarshaller.getJsonbContext().getConfigProperties().getBinaryDataStrategy()).decode(jsonValue);
    }

    private Base64.Decoder getDecoder(String strategy) {
        switch (strategy) {
            case "BASE_64": {
                return Base64.getDecoder();
            }
            case "BASE_64_URL": {
                return Base64.getUrlDecoder();
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Invalid strategy: " + strategy));
    }
}

