/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemAdvertisementImpl
implements SystemAdvertisement {
    static final long serialVersionUID = -6635044542343387957L;
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private static final List<String> EMPTY_LIST = new ArrayList<String>();
    private String hwarch;
    private String hwvendor;
    private PeerID id;
    private String name;
    private String osname;
    private String osversion;
    private String osarch;
    private List<String> endpointAddresses = null;
    private HashMap<String, String> customTags = null;

    @Override
    public void setHWArch(String hwarch) {
        this.hwarch = hwarch;
    }

    @Override
    public void setOSArch(String osarch) {
        this.osarch = osarch;
    }

    @Override
    public void setHWVendor(String hwvendor) {
        this.hwvendor = hwvendor;
    }

    @Override
    public void setID(PeerID id) {
        this.id = id;
    }

    @Override
    public void addEndpointAddress(String value) {
        if (this.endpointAddresses == null) {
            this.endpointAddresses = new ArrayList<String>();
        }
        this.endpointAddresses.add(value);
    }

    @Override
    public void setEndpointAddresses(List<String> endpoints) {
        for (String endpoint : endpoints) {
            this.addEndpointAddress(endpoint);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOSName(String osname) {
        this.osname = osname;
    }

    @Override
    public void setOSVersion(String osversion) {
        this.osversion = osversion;
    }

    @Override
    public void setCustomTags(Map<String, String> tags) {
        if (tags == null) {
            return;
        }
        if (this.customTags == null) {
            this.customTags = new HashMap();
        }
        this.customTags.putAll(tags);
    }

    @Override
    public Map<String, String> getCustomTags() {
        if (this.customTags == null) {
            return new HashMap<String, String>();
        }
        return (HashMap)this.customTags.clone();
    }

    @Override
    public void setCustomTag(String tag, String value) {
        if (this.customTags == null) {
            this.customTags = new HashMap();
        }
        this.customTags.put(tag, value);
    }

    @Override
    public String getHWArch() {
        return this.hwarch;
    }

    @Override
    public String getOSArch() {
        return this.osarch;
    }

    @Override
    public String getHWVendor() {
        return this.hwvendor;
    }

    @Override
    public PeerID getID() {
        return this.id;
    }

    @Override
    public List<String> getEndpointAddresses() {
        if (this.endpointAddresses == null) {
            return EMPTY_LIST;
        }
        return this.endpointAddresses;
    }

    @Override
    public List<URI> getURIs() {
        List<String> endpoints = this.getEndpointAddresses();
        ArrayList<URI> uriList = new ArrayList<URI>(endpoints.size());
        for (int i = 0; i < endpoints.size(); ++i) {
            try {
                uriList.add(new URI(endpoints.get(i)));
                continue;
            }
            catch (URISyntaxException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "Exception occurred : ", e);
            }
        }
        return uriList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOSName() {
        return this.osname;
    }

    @Override
    public String getOSVersion() {
        return this.osversion;
    }

    @Override
    public String getCustomTagValue(String tagName) throws NoSuchFieldException {
        if (this.customTags != null) {
            return this.customTags.get(tagName);
        }
        throw new NoSuchFieldException(tagName);
    }

    public SystemAdvertisement clone() throws CloneNotSupportedException {
        try {
            SystemAdvertisement likeMe = (SystemAdvertisement)super.clone();
            likeMe.setID(this.getID());
            likeMe.setName(this.getName());
            likeMe.setOSName(this.getName());
            likeMe.setOSVersion(this.getOSVersion());
            likeMe.setOSArch(this.getOSArch());
            if (this.endpointAddresses != null && !this.endpointAddresses.isEmpty()) {
                likeMe.setEndpointAddresses(this.getEndpointAddresses());
            }
            likeMe.setHWArch(this.getHWArch());
            likeMe.setHWVendor(this.getHWVendor());
            if (this.customTags != null && !this.customTags.isEmpty()) {
                likeMe.setCustomTags(this.getCustomTags());
            }
            return likeMe;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (this == obj) {
            retVal = true;
        } else if (obj instanceof SystemAdvertisement) {
            SystemAdvertisement adv = (SystemAdvertisement)obj;
            retVal = this.getID().equals(adv.getID());
        }
        return retVal;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getID().hashCode();
        String name = this.getName();
        if (name != null) {
            result = 37 * result + name.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(SystemAdvertisement other) {
        return this.getID().compareTo(other.getID());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(120);
        sb.append("PEERID[");
        sb.append(this.id.toString());
        sb.append("]\n");
        sb.append("CUSTOMTAGS[");
        boolean firstTime = true;
        for (Map.Entry<String, String> entry : this.customTags.entrySet()) {
            if (!firstTime) {
                sb.append(", ");
            } else {
                firstTime = false;
            }
            String key = entry.getKey();
            sb.append(key.toUpperCase());
            if (key.equals(CustomTagNames.START_TIME.toString())) {
                sb.append("[");
                sb.append(MessageFormat.format("{0,time,full} on {0,date}", new Date(Long.parseLong(entry.getValue()))));
                sb.append("]");
                continue;
            }
            sb.append(":");
            sb.append(entry.getValue());
        }
        sb.append("], ");
        sb.append("ENDPONTADDRESSES[");
        sb.append(this.endpointAddresses.toString());
        sb.append("], ");
        sb.append("NAME:");
        sb.append(this.name);
        sb.append(", ");
        sb.append("OSNAME:");
        sb.append(this.osname);
        sb.append(", ");
        sb.append("OSVERSION:");
        sb.append(this.osversion);
        sb.append(", ");
        sb.append("OSARCH:");
        sb.append(this.osarch);
        sb.append(", ");
        sb.append("HWARCH:");
        sb.append(this.hwarch);
        sb.append(", ");
        sb.append("HWVENDOR:");
        sb.append(this.hwvendor);
        return sb.toString();
    }
}

