/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.RelationRoleDescriptor;

public final class RelationshipDescriptor
extends Descriptor {
    private RelationRoleDescriptor source;
    private RelationRoleDescriptor sink;
    private boolean isBidirectional = true;

    public boolean isOneOne() {
        return !this.source.getIsMany() && !this.sink.getIsMany();
    }

    public boolean isOneMany() {
        return !this.source.getIsMany() && this.sink.getIsMany();
    }

    public boolean isManyOne() {
        return this.source.getIsMany() && !this.sink.getIsMany();
    }

    public boolean isManyMany() {
        return this.source.getIsMany() && this.sink.getIsMany();
    }

    public boolean hasParticipant(Descriptor desc) {
        return this.source.getOwner() == desc || this.sink.getOwner() == desc;
    }

    public RelationRoleDescriptor getSource() {
        return this.source;
    }

    public void setSource(RelationRoleDescriptor source) {
        this.source = source;
    }

    public void setSink(RelationRoleDescriptor sink) {
        this.sink = sink;
    }

    public RelationRoleDescriptor getSink() {
        return this.sink;
    }

    public void setIsBidirectional(boolean isBidirectional) {
        this.isBidirectional = isBidirectional;
    }

    public boolean getIsBidirectional() {
        return this.isBidirectional;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("From EJB ").append(this.getSource().getName()).append(" cmr field : ").append(this.getSource().getCMRField()).append("(").append(this.getSource().getCMRFieldType()).append(")  to EJB ").append(this.getSink().getName()).append(" isMany ").append(this.getSource().getIsMany()).append(" cascade-delete ").append(this.getSource().getCascadeDelete());
    }
}

