/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.utils.installer;

import com.sun.jck.utils.installer.Node;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;

class Root {
    String m_rootPath;
    File m_rootFile;
    TreeMap m_nodes;

    private Root() {
    }

    public Root(File file) throws IOException, Fault {
        this.m_nodes = new TreeMap();
        this.m_rootFile = file;
        this.m_rootPath = file.getAbsolutePath();
        this.generateNodes(this.m_rootFile);
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public File getRootFile() {
        return this.m_rootFile;
    }

    public TreeMap getNodes() {
        return this.m_nodes;
    }

    public Iterator iterator() {
        return this.getNodes().entrySet().iterator();
    }

    private void generateNodes(File file) throws IOException, Fault {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.generateNodes(fileArray[i]);
            }
        } else {
            try {
                Node node = new Node(this.m_rootPath, file);
                this.m_nodes.put(file.getCanonicalPath(), node);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Fault("Illegal argument exception thrown while generating node list for root " + this.m_rootPath + "\n" + illegalArgumentException.getMessage());
            }
            catch (IOException iOException) {
                throw new Fault("IO exception thrown while generating node list for root " + this.m_rootPath + "\n" + iOException.getMessage());
            }
        }
    }

    class Fault
    extends Exception {
        public Fault(String string) {
            super(string);
        }
    }
}

