/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ServerSet {
    protected ServerSet() {
    }

    public abstract LDAPConnection getConnection() throws LDAPException;

    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        LDAPConnection c = this.getConnection();
        if (healthCheck != null) {
            try {
                healthCheck.ensureNewConnectionValid(c);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                c.close();
                throw le;
            }
        }
        return c;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ServerSet(className=");
        buffer.append(this.getClass().getName());
        buffer.append(')');
    }
}

