/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class LogWrapper {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private final Set<ServiceReference> m_loggerRefs = new HashSet<ServiceReference>();
    private BundleContext m_context;
    private ServiceListener m_logServiceListener;
    private int m_logLevel = 2;

    public static LogWrapper getLogger() {
        return LogWrapperLoader.m_singleton;
    }

    public static void setContext(BundleContext context) {
        LogWrapper logWrapper = LogWrapperLoader.m_singleton;
        if (context == null) {
            if (logWrapper.m_logServiceListener != null) {
                logWrapper.m_context.removeServiceListener(logWrapper.m_logServiceListener);
                logWrapper.m_logServiceListener = null;
            }
            logWrapper.removeLoggerRefs();
        }
        logWrapper.setBundleContext(context);
        if (context != null) {
            try {
                ServiceListener listener = new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                        if (1 == event.getType()) {
                            LogWrapperLoader.m_singleton.addLoggerRef(event.getServiceReference());
                        }
                    }
                };
                context.addServiceListener(listener, "(objectClass=org.osgi.service.log.LogService)");
                logWrapper.m_logServiceListener = listener;
                ServiceReference[] refs = context.getServiceReferences("org.osgi.service.log.LogService", null);
                if (null != refs) {
                    for (int i = 0; i < refs.length; ++i) {
                        logWrapper.addLoggerRef(refs[i]);
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    LogWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoggerRefs() {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            this.m_loggerRefs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoggerRef(ServiceReference ref) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            this.m_loggerRefs.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBundleContext(BundleContext context) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            this.m_context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String msg) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            if (level > this.m_logLevel) {
                return;
            }
            String logMsg = "EventAdmin: " + msg;
            if (!this.m_loggerRefs.isEmpty()) {
                Iterator<ServiceReference> iter = this.m_loggerRefs.iterator();
                while (iter.hasNext()) {
                    ServiceReference next = iter.next();
                    LogService logger = (LogService)this.m_context.getService(next);
                    if (null != logger) {
                        logger.log(level, logMsg);
                        this.m_context.ungetService(next);
                        continue;
                    }
                    iter.remove();
                }
            } else {
                this._log(null, level, logMsg, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String msg, Throwable ex) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            if (level > this.m_logLevel) {
                return;
            }
            String logMsg = "EventAdmin: " + msg;
            if (!this.m_loggerRefs.isEmpty()) {
                Iterator<ServiceReference> iter = this.m_loggerRefs.iterator();
                while (iter.hasNext()) {
                    ServiceReference next = iter.next();
                    LogService logger = (LogService)this.m_context.getService(next);
                    if (null != logger) {
                        logger.log(level, logMsg, ex);
                        this.m_context.ungetService(next);
                        continue;
                    }
                    iter.remove();
                }
            } else {
                this._log(null, level, logMsg, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference sr, int level, String msg) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            if (level > this.m_logLevel) {
                return;
            }
            String logMsg = "EventAdmin: " + msg;
            if (!this.m_loggerRefs.isEmpty()) {
                Iterator<ServiceReference> iter = this.m_loggerRefs.iterator();
                while (iter.hasNext()) {
                    ServiceReference next = iter.next();
                    LogService logger = (LogService)this.m_context.getService(next);
                    if (null != logger) {
                        logger.log(sr, level, logMsg);
                        this.m_context.ungetService(next);
                        continue;
                    }
                    iter.remove();
                }
            } else {
                this._log(sr, level, logMsg, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference sr, int level, String msg, Throwable ex) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            if (level > this.m_logLevel) {
                return;
            }
            String logMsg = "EventAdmin: " + msg;
            if (!this.m_loggerRefs.isEmpty()) {
                Iterator<ServiceReference> iter = this.m_loggerRefs.iterator();
                while (iter.hasNext()) {
                    ServiceReference next = iter.next();
                    LogService logger = (LogService)this.m_context.getService(next);
                    if (null != logger) {
                        logger.log(sr, level, logMsg, ex);
                        this.m_context.ungetService(next);
                        continue;
                    }
                    iter.remove();
                }
            } else {
                this._log(sr, level, logMsg, ex);
            }
        }
    }

    private void _log(ServiceReference sr, int level, String msg, Throwable ex) {
        String s = sr == null ? null : "SvcRef " + sr;
        s = s == null ? msg : s + " " + msg;
        s = ex == null ? s : s + " (" + ex + ")";
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (ex == null) break;
                if (ex instanceof BundleException && ((BundleException)ex).getNestedException() != null) {
                    ex = ((BundleException)ex).getNestedException();
                }
                ex.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogLevel(int logLevel) {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            this.m_logLevel = logLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogLevel() {
        Set<ServiceReference> set = this.m_loggerRefs;
        synchronized (set) {
            return this.m_logLevel;
        }
    }

    private static class LogWrapperLoader {
        static final LogWrapper m_singleton = new LogWrapper();

        private LogWrapperLoader() {
        }
    }
}

