/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Session;

public class EISConnectionSpec
implements Connector {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    protected ConnectionSpec connectionSpec;
    protected ConnectionFactory connectionFactory;
    protected Context context;
    protected Name name;
    protected Writer log;

    public EISConnectionSpec() {
    }

    public EISConnectionSpec(Context context, String name) throws ValidationException {
        this.context = context;
        this.setName(name);
    }

    public EISConnectionSpec(String name) throws ValidationException {
        this();
        this.setName(name);
    }

    public EISConnectionSpec(Context context, Name name) {
        this.context = context;
        this.name = name;
    }

    public EISConnectionSpec(Name name) {
        this();
        this.name = name;
    }

    public Writer getLog() {
        return this.log;
    }

    public void setLog(Writer log) {
        this.log = log;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    @Override
    public java.sql.Connection connect(Properties properties, Session session) {
        throw EISException.incorrectLoginInstanceProvided(EISLogin.class);
    }

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory == null) {
            try {
                connectionFactory = (ConnectionFactory)this.getContext().lookup(this.getName());
                this.setConnectionFactory(connectionFactory);
            }
            catch (Exception exception) {
                throw ValidationException.cannotAcquireDataSource(this.getName(), exception);
            }
        }
        try {
            accessor.setRecordFactory(connectionFactory.getRecordFactory());
            if (this.getConnectionSpec() == null) {
                return connectionFactory.getConnection();
            }
            return connectionFactory.getConnection(this.getConnectionSpec());
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public Context getContext() {
        if (this.context == null) {
            try {
                this.context = new InitialContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.context;
    }

    public String getPasswordFromProperties(Properties properties) {
        Object passwordObject = properties.get(PASSWORD);
        String password = null;
        if (passwordObject instanceof char[]) {
            password = new String((char[])passwordObject);
        } else if (passwordObject instanceof String) {
            password = (String)passwordObject;
        }
        return password;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public String getConnectionDetails() {
        return this.getName().toString();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setConnectionFactoryObject(Object connectionFactory) {
        this.setConnectionFactory((ConnectionFactory)connectionFactory);
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public void setConnectionSpecObject(Object connectionFactory) {
        this.setConnectionSpec((ConnectionSpec)connectionFactory);
    }

    public void setName(String name) throws ValidationException {
        try {
            this.name = new CompositeName(name);
        }
        catch (InvalidNameException e) {
            throw ValidationException.invalidDataSourceName(name, e);
        }
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String toString() {
        if (this.getName() != null) {
            return String.valueOf(Helper.getShortClassName(this.getClass())) + "(connection manager url => " + this.getName() + ")";
        }
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "()";
    }

    @Override
    public void toString(PrintWriter writer) {
        writer.println(this.toString());
    }
}

