/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.IndexedObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class OrderedListContainerPolicy
extends ListContainerPolicy {
    protected static final String NOT_SET = "NOT_SET";
    protected DatabaseField listOrderField;
    protected OrderCorrectionType orderCorrectionType;

    public OrderedListContainerPolicy() {
    }

    public OrderedListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public OrderedListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    @Override
    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, ObjectBuildingQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        if (this.listOrderField == null) {
            return super.addAll(elements, container, session, dbRows, query, parentCacheKey, isTargetProtected);
        }
        return this.addAll(elements, container, session, dbRows, query, parentCacheKey);
    }

    @Override
    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, DataReadQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        if (this.listOrderField == null) {
            return super.addAll(elements, container, session, dbRows, query, parentCacheKey, isTargetProtected);
        }
        return this.addAll(elements, container, session, dbRows, query, parentCacheKey);
    }

    protected boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, ReadQuery query, CacheKey parentCacheKey) {
        int i;
        int size = dbRows.size();
        if (this.elementDescriptor != null && this.elementDescriptor.getObjectBuilder().hasWrapperPolicy()) {
            ObjectBuilder objectBuilder = this.elementDescriptor.getObjectBuilder();
            ArrayList<Object> wrappedElements = new ArrayList<Object>(size);
            i = 0;
            while (i < size) {
                wrappedElements.add(objectBuilder.wrapObject(elements.get(i), session));
                ++i;
            }
            elements = wrappedElements;
        }
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        int i2 = 0;
        while (i2 < size) {
            ((List)container).add(NOT_SET);
            ++i2;
        }
        boolean failed = false;
        i = 0;
        while (i < size) {
            block16: {
                AbstractRecord row = dbRows.get(i);
                Object orderValue = row.get(this.listOrderField);
                if (orderValue == null) {
                    failed = true;
                    break;
                }
                int intOrderValue = (Integer)conversionManager.convertObject(orderValue, Integer.class);
                try {
                    if (NOT_SET != ((List)container).set(intOrderValue, elements.get(i))) {
                        failed = true;
                    }
                    break block16;
                }
                catch (IndexOutOfBoundsException indexException) {
                    failed = true;
                }
                break;
            }
            ++i;
        }
        if (failed) {
            ((List)container).clear();
            ArrayList<Integer> orderList = new ArrayList<Integer>(size);
            int i3 = 0;
            while (i3 < size) {
                AbstractRecord row = dbRows.get(i3);
                Object orderValue = row.get(this.listOrderField);
                if (orderValue == null) {
                    orderList.add(null);
                } else {
                    orderList.add((Integer)conversionManager.convertObject(orderValue, Integer.class));
                }
                ++i3;
            }
            if (this.orderCorrectionType == OrderCorrectionType.READ || this.orderCorrectionType == OrderCorrectionType.READ_WRITE) {
                ArrayList<IndexedObject> indexedElements = new ArrayList<IndexedObject>(size);
                int i4 = 0;
                while (i4 < size) {
                    indexedElements.add(new IndexedObject((Integer)orderList.get(i4), elements.get(i4)));
                    ++i4;
                }
                ((List)container).addAll(this.correctOrderList(indexedElements));
                if (this.orderCorrectionType == OrderCorrectionType.READ_WRITE) {
                    ((IndirectList)container).setIsListOrderBrokenInDb(true);
                }
            } else {
                throw QueryException.listOrderFieldWrongValue(query, this.listOrderField, orderList);
            }
        }
        return size > 0;
    }

    protected void addIntoAtIndex(Integer index, Object object, Object container, AbstractSession session) {
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().wrapObject(object, session);
        }
        try {
            if (index == null || index > this.sizeFor(container)) {
                ((List)container).add(object);
            } else {
                ((List)container).add(index, object);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(object, container, ex1);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotAddElement(object, container, ex2);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotAddElement(object, container, ex3);
        }
    }

    @Override
    public void compareCollectionsForChange(Object oldList, Object newList, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        ListIterator iterator;
        ArrayList<Object> orderedObjectsToAdd = new ArrayList<Object>();
        HashMap<Integer, Integer> indicesToRemove = new HashMap<Integer, Integer>();
        HashMap oldListIndexValue = new HashMap();
        IdentityHashMap oldListValueIndex = new IdentityHashMap();
        IdentityHashMap objectsToAdd = new IdentityHashMap();
        IdentityHashMap<Object, Integer> newListValueIndex = new IdentityHashMap<Object, Integer>();
        if (oldList != null) {
            iterator = (ListIterator)this.iteratorFor(oldList);
            while (iterator.hasNext()) {
                Integer index = iterator.nextIndex();
                Object value = iterator.next();
                oldListValueIndex.put(value, index);
                oldListIndexValue.put(index, value);
                indicesToRemove.put(index, index);
            }
        }
        if (newList != null) {
            iterator = (ListIterator)this.iteratorFor(newList);
            while (iterator.hasNext()) {
                newListValueIndex.put(iterator.next(), iterator.previousIndex());
            }
            int index = 0;
            int offset = 0;
            iterator = (ListIterator)this.iteratorFor(newList);
            while (iterator.hasNext()) {
                index = iterator.nextIndex();
                Object currentObject = iterator.next();
                if (currentObject != null) {
                    if (oldListValueIndex.containsKey(currentObject)) {
                        int oldIndex = (Integer)oldListValueIndex.get(currentObject);
                        oldListValueIndex.remove(currentObject);
                        if (index == oldIndex) {
                            indicesToRemove.remove(oldIndex);
                            offset = 0;
                            continue;
                        }
                        if (index == oldIndex + offset) {
                            indicesToRemove.remove(oldIndex);
                            continue;
                        }
                        int movedObjects = 0;
                        int deletedObjects = 0;
                        boolean moved = true;
                        if (oldIndex < index) {
                            ++offset;
                        } else {
                            int i = oldIndex - 1;
                            while (i >= index) {
                                Object oldObject = oldListIndexValue.get(i);
                                if (newListValueIndex.containsKey(oldObject)) {
                                    ++movedObjects;
                                } else {
                                    ++deletedObjects;
                                }
                                --i;
                            }
                            if (index == oldIndex + offset - deletedObjects) {
                                offset -= deletedObjects;
                                moved = false;
                            } else if (movedObjects > 1) {
                                ++offset;
                            } else {
                                Object oldObject = oldListIndexValue.get(index);
                                if (newListValueIndex.containsKey(oldObject) && (Integer)newListValueIndex.get(oldObject) - index > 1) {
                                    moved = false;
                                    --offset;
                                }
                            }
                        }
                        if (moved) {
                            orderedObjectsToAdd.add(currentObject);
                            continue;
                        }
                        indicesToRemove.remove(oldIndex);
                        continue;
                    }
                    ++offset;
                    objectsToAdd.put(currentObject, currentObject);
                    orderedObjectsToAdd.add(currentObject);
                    continue;
                }
                --offset;
            }
        }
        ArrayList<Integer> orderedIndicesToRemove = new ArrayList<Integer>(indicesToRemove.values());
        Collections.sort(orderedIndicesToRemove);
        changeRecord.addAdditionChange(objectsToAdd, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(oldListValueIndex, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedAdditionChange(orderedObjectsToAdd, newListValueIndex, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedRemoveChange(orderedIndicesToRemove, oldListIndexValue, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public List correctOrderList(List<IndexedObject> indexedObjects) {
        Collections.sort(indexedObjects);
        int size = indexedObjects.size();
        ArrayList<Object> objects = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            objects.add(indexedObjects.get(i).getObject());
            ++i;
        }
        return objects;
    }

    @Override
    public Iterator getChangeValuesFrom(Map map) {
        return map.keySet().iterator();
    }

    public DatabaseField getListOrderField() {
        return this.listOrderField;
    }

    public void setListOrderField(DatabaseField field) {
        this.listOrderField = field;
    }

    public OrderCorrectionType getOrderCorrectionType() {
        return this.orderCorrectionType;
    }

    public void setOrderCorrectionType(OrderCorrectionType orderCorrectionType) {
        if (this.orderCorrectionType == orderCorrectionType) {
            return;
        }
        if (!(orderCorrectionType != OrderCorrectionType.READ_WRITE || this.getContainerClass() != null && IndirectList.class.isAssignableFrom(this.getContainerClass()))) {
            this.setContainerClass(IndirectList.class);
        }
        this.orderCorrectionType = orderCorrectionType;
    }

    @Override
    public Object iteratorFor(Object container) {
        return ((List)container).listIterator();
    }

    @Override
    public boolean isOrderedListPolicy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession targetSession, boolean isSynchronizeOnMerge) {
        if (isSynchronizeOnMerge && !changeRecord.getOwner().isNew()) {
            Object synchronizedValueOfTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizedValueOfTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
            }
            Object object = synchronizedValueOfTarget;
            synchronized (object) {
                this.mergeChanges(changeRecord, valueOfTarget, shouldMergeCascadeParts, mergeManager, targetSession);
            }
        } else {
            this.mergeChanges(changeRecord, valueOfTarget, shouldMergeCascadeParts, mergeManager, targetSession);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession targetSession) {
        block20: {
            block18: {
                if (changeRecord.orderHasBeenRepaired() && valueOfTarget instanceof IndirectList) {
                    ((IndirectList)valueOfTarget).setIsListOrderBrokenInDb(false);
                }
                if (changeRecord.getOrderedChangeObjectList().isEmpty()) break block18;
                for (OrderedChangeObject changeObject : changeRecord.getOrderedChangeObjectList()) {
                    block19: {
                        objectChanges = changeObject.getChangeSet();
                        if (changeObject.getChangeType() != 1) break block19;
                        objectRemoved = changeRecord.getRemoveObjectList().containsKey(objectChanges);
                        objectToRemove = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession);
                        if (objectToRemove == null) continue;
                        index = changeObject.getIndex();
                        if (index == null) ** GOTO lbl18
                        if (objectToRemove.equals(this.get(index, valueOfTarget, mergeManager.getSession()))) {
                            this.removeFromAtIndex(index, valueOfTarget);
                        } else {
                            key = changeRecord.getOwner().getId();
                            targetSession.getIdentityMapAccessor().invalidateObject(key, changeRecord.getOwner().getClassType(targetSession));
                            return;
lbl18:
                            // 1 sources

                            this.removeFrom(objectToRemove, valueOfTarget, targetSession);
                        }
                        if (mergeManager.shouldMergeChangesIntoDistributedCache() || !changeRecord.getMapping().isPrivateOwned() || !objectRemoved) continue;
                        mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
                        continue;
                    }
                    objectAdded = changeRecord.getAddObjectList().containsKey(objectChanges);
                    object = null;
                    if (objectAdded && shouldMergeCascadeParts) {
                        object = this.mergeCascadeParts(objectChanges, mergeManager, targetSession);
                    }
                    if (object == null) {
                        object = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession);
                    }
                    if (objectAdded && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                        if (this.contains(object, valueOfTarget, mergeManager.getSession())) continue;
                        this.addIntoAtIndex(changeObject.getIndex(), object, valueOfTarget, mergeManager.getSession());
                        continue;
                    }
                    this.addIntoAtIndex(changeObject.getIndex(), object, valueOfTarget, targetSession);
                }
                break block20;
            }
            removedIndices = changeRecord.getOrderedRemoveObjectIndices();
            if (removedIndices.isEmpty()) {
                for (ObjectChangeSet objectChanges : changeRecord.getRemoveObjectList().keySet()) {
                    this.removeFrom(objectChanges.getOldKey(), objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession), valueOfTarget, targetSession);
                    this.registerRemoveNewObjectIfRequired(objectChanges, mergeManager);
                }
            } else {
                i = removedIndices.size() - 1;
                while (i >= 0) {
                    index = removedIndices.get(i);
                    objectChanges = (ObjectChangeSet)changeRecord.getOrderedRemoveObject(index);
                    objectToRemove = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession);
                    if (objectToRemove != null && objectToRemove.equals(this.get(index, valueOfTarget, mergeManager.getSession()))) {
                        this.removeFromAtIndex(index, valueOfTarget);
                        if (changeRecord.getRemoveObjectList().containsKey(objectChanges)) {
                            this.registerRemoveNewObjectIfRequired(objectChanges, mergeManager);
                        }
                    } else {
                        key = changeRecord.getOwner().getId();
                        targetSession.getIdentityMapAccessor().invalidateObject(key, changeRecord.getOwner().getClassType(targetSession));
                        return;
                    }
                    --i;
                }
            }
            var9_15 = changeRecord.getOrderedAddObjects().iterator();
            while (var9_15.hasNext()) {
                objectChanges = addChangeSet = var9_15.next();
                objectAdded = changeRecord.getAddObjectList().containsKey(objectChanges);
                object = null;
                if (objectAdded && shouldMergeCascadeParts) {
                    object = this.mergeCascadeParts(objectChanges, mergeManager, targetSession);
                }
                if (object == null) {
                    object = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession);
                }
                if (objectAdded && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object, valueOfTarget, mergeManager.getSession())) continue;
                    this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges), object, valueOfTarget, mergeManager.getSession());
                    continue;
                }
                this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges), object, valueOfTarget, targetSession);
            }
        }
    }

    protected void registerRemoveNewObjectIfRequired(ObjectChangeSet objectChanges, MergeManager mergeManager) {
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
        }
    }

    protected void removeFromAtIndex(int index, Object container) {
        try {
            ((List)container).remove(index);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotRemoveFromContainer(index, container, this);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotRemoveFromContainer(index, container, this);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotRemoveFromContainer(index, container, this);
        }
    }

    @Override
    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(0, null, changeSetToAdd);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    @Override
    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(1, null, changeSetToRemove);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    @Override
    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, CollectionChangeRecord collectionChangeRecord) {
        int changeType = event.getChangeType();
        if (changeType == 0) {
            super.recordAddToCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else if (changeType == 1) {
            super.recordRemoveFromCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(changeType);
        }
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(changeType, event.getIndex(), changeSet, event.getNewValue());
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    @Override
    public boolean shouldAddAll() {
        return this.listOrderField != null;
    }

    @Override
    public List<DatabaseField> getAdditionalFieldsForJoin(CollectionMapping baseMapping) {
        if (this.listOrderField != null) {
            ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(1);
            fields.add(this.listOrderField);
            return fields;
        }
        return null;
    }

    @Override
    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> indexList, int index) {
        if (this.listOrderField != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void updateChangeRecordForSelfMerge(ChangeRecord changeRecord, Object source, Object target, ForeignReferenceMapping mapping, UnitOfWorkChangeSet parentUOWChangeSet, UnitOfWorkImpl unitOfWork) {
        ObjectChangeSet sourceSet = parentUOWChangeSet.getCloneToObjectChangeSet().get(source);
        Iterator<OrderedChangeObject> iterator = ((CollectionChangeRecord)changeRecord).getOrderedChangeObjectList().iterator();
        if (iterator.hasNext()) {
            OrderedChangeObject changeObject = iterator.next();
            if (changeObject.getChangeSet() == sourceSet) {
                changeObject.setChangeSet(((UnitOfWorkChangeSet)unitOfWork.getUnitOfWorkChangeSet()).findOrCreateLocalObjectChangeSet(target, mapping.getReferenceDescriptor(), unitOfWork.isCloneNewObject(target)));
            }
            return;
        }
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        if (this.listOrderField != null) {
            ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>(1);
            tables.add(this.listOrderField.getTable());
            return tables;
        }
        return null;
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        if (this.listOrderField != null) {
            if (selectionQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(baseExpression.getField(this.listOrderField));
            } else {
                ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(baseExpression.getField(this.listOrderField));
            }
        }
    }
}

