/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login.common;

import java.util.Arrays;

public class PasswordCredential {
    private String username;
    private char[] password;
    private String realm;
    private boolean readOnly = false;
    private byte[] target_name = new byte[0];

    public PasswordCredential(String user, char[] password, String realm) {
        this.username = user;
        char[] passwordCopy = password == null ? null : Arrays.copyOf(password, password.length);
        this.password = passwordCopy;
        this.realm = realm;
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = new char[0];
        }
        if (this.realm == null) {
            this.realm = "";
        }
    }

    public PasswordCredential(String user, char[] password, String realm, byte[] target_name) {
        this(user, password, realm);
        this.target_name = target_name;
        this.readOnly = true;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUser() {
        return this.username;
    }

    public void setRealm(String realm) {
        if (!this.readOnly) {
            this.realm = realm;
        }
    }

    public char[] getPassword() {
        char[] passwordCopy = this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
        return passwordCopy;
    }

    public byte[] getTargetName() {
        return this.target_name;
    }

    public boolean equals(Object o) {
        PasswordCredential pc;
        return o instanceof PasswordCredential && (pc = (PasswordCredential)o).getUser().equals(this.username) && Arrays.equals(pc.getPassword(), this.password) && pc.getRealm().equals(this.realm);
    }

    public int hashCode() {
        return this.username.hashCode() + Arrays.hashCode(this.password) + this.realm.hashCode();
    }

    public String toString() {
        String s = "Realm=" + this.realm;
        s = s + " Username=" + this.username;
        s = s + " Password=########";
        s = s + " TargetName = " + new String(this.target_name);
        return s;
    }
}

