/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.EpochCarrier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;

public abstract class AuthConfigHelper {
    String loggerName;
    EpochCarrier providerEpoch;
    long epoch;
    MessagePolicyDelegate mpDelegate;
    String layer;
    String appContext;
    CallbackHandler cbh;
    private ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private Lock instanceReadLock = this.instanceReadWriteLock.readLock();
    private Lock instanceWriteLock = this.instanceReadWriteLock.writeLock();

    public AuthConfigHelper(String loggerName, EpochCarrier providerEpoch, MessagePolicyDelegate mpDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        this.loggerName = loggerName;
        this.providerEpoch = providerEpoch;
        this.mpDelegate = mpDelegate;
        this.layer = layer;
        this.appContext = appContext;
        this.cbh = cbh;
        this.initialize();
    }

    private void initialize() throws AuthException {
        this.instanceWriteLock.lock();
        try {
            this.epoch = this.providerEpoch.getEpoch();
            this.initializeContextMap();
        }
        finally {
            this.instanceWriteLock.unlock();
        }
    }

    private void doRefreshIfNeeded() {
        boolean hasChanged = false;
        this.instanceReadLock.lock();
        try {
            hasChanged = this.providerEpoch.hasChanged(this.epoch);
        }
        finally {
            this.instanceReadLock.unlock();
        }
        if (hasChanged) {
            this.refresh();
        }
    }

    private Integer getHashCode(Map properties) {
        if (properties == null) {
            return Integer.valueOf("0");
        }
        return properties.hashCode();
    }

    private <M> M getContextFromMap(HashMap<String, HashMap<Integer, M>> contextMap, String authContextID, Map properties) {
        M rvalue = null;
        HashMap<Integer, M> internalMap = contextMap.get(authContextID);
        if (internalMap != null) {
            rvalue = internalMap.get(this.getHashCode(properties));
        }
        if (rvalue != null && this.isLoggable(Level.FINE)) {
            this.logIfLevel(Level.FINE, null, "AuthContextID found in Map: ", authContextID);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <M> M getContext(HashMap<String, HashMap<Integer, M>> contextMap, String authContextID, Subject subject, Map properties) throws AuthException {
        Object rvalue = null;
        this.doRefreshIfNeeded();
        this.instanceReadLock.lock();
        try {
            rvalue = this.getContextFromMap(contextMap, authContextID, properties);
            if (rvalue != null) {
                Object v = rvalue;
                return (M)v;
            }
        }
        finally {
            this.instanceReadLock.unlock();
        }
        this.instanceWriteLock.lock();
        try {
            rvalue = this.getContextFromMap(contextMap, authContextID, properties);
            if (rvalue == null) {
                rvalue = this.createAuthContext(authContextID, properties);
                HashMap<Integer, Object> internalMap = contextMap.get(authContextID);
                if (internalMap == null) {
                    internalMap = new HashMap();
                    contextMap.put(authContextID, internalMap);
                }
                internalMap.put(this.getHashCode(properties), rvalue);
            }
            Object v = rvalue;
            return (M)v;
        }
        finally {
            this.instanceWriteLock.unlock();
        }
    }

    protected boolean isLoggable(Level level) {
        Logger logger = Logger.getLogger(this.loggerName);
        return logger.isLoggable(level);
    }

    protected void logIfLevel(Level level, Throwable t, String ... msgParts) {
        Logger logger = Logger.getLogger(this.loggerName);
        if (logger.isLoggable(level)) {
            StringBuffer msgB = new StringBuffer("");
            for (String m : msgParts) {
                msgB.append(m);
            }
            String msg = msgB.toString();
            if (!msg.isEmpty() && t != null) {
                logger.log(level, msg, t);
            } else if (!msg.isEmpty()) {
                logger.log(level, msg);
            }
        }
    }

    protected void checkMessageTypes(Class[] supportedMessageTypes) throws AuthException {
        Class[] requiredMessageTypes;
        for (Class requiredType : requiredMessageTypes = this.mpDelegate.getMessageTypes()) {
            boolean supported = false;
            for (Class supportedType : supportedMessageTypes) {
                if (!requiredType.isAssignableFrom(supportedType)) continue;
                supported = true;
            }
            if (supported) continue;
            throw new AuthException("module does not support message type: " + requiredType.getName());
        }
    }

    protected abstract void initializeContextMap();

    protected abstract <M> M createAuthContext(String var1, Map var2) throws AuthException;

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return this.mpDelegate.getAuthContextID(messageInfo);
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public void refresh() {
        try {
            this.initialize();
        }
        catch (AuthException ae) {
            throw new RuntimeException(ae);
        }
    }
}

