/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormattedWriterRecord
extends WriterRecord {
    private String tab;
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;
    private final String cr = Constants.cr();
    private static final String DEFAULT_TAB = "   ".intern();

    private String tab() {
        if (this.tab == null) {
            if (DEFAULT_TAB.equals(((XMLMarshaller)this.getMarshaller()).getIndentString())) {
                this.tab = DEFAULT_TAB;
                return DEFAULT_TAB;
            }
            StringBuilder sb = new StringBuilder();
            this.writeValue(((XMLMarshaller)this.getMarshaller()).getIndentString(), false, sb);
            this.tab = sb.toString();
        }
        return this.tab;
    }

    @Override
    public void startDocument(String encoding, String version) {
        super.startDocument(encoding, version);
        this.builder.append(this.cr);
    }

    @Override
    public void endDocument() {
        this.builder.append(this.cr);
    }

    @Override
    public void writeHeader() {
        this.builder.append(((XMLMarshaller)this.getMarshaller()).getXmlHeader());
        this.builder.append(this.cr);
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.builder.append('>');
        }
        if (!this.isLastEventText) {
            if (this.numberOfTabs > 0) {
                this.builder.append(this.cr);
            }
            int x = 0;
            while (x < this.numberOfTabs) {
                this.builder.append(this.tab());
                ++x;
            }
        }
        this.isStartElementOpen = true;
        this.builder.append('<');
        this.builder.append(this.getNameForFragment(xPathFragment));
        if (xPathFragment.isGeneratedPrefix()) {
            this.namespaceDeclaration(xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
        }
        ++this.numberOfTabs;
        this.isLastEventText = false;
    }

    @Override
    public void element(XPathFragment frag) {
        this.isLastEventText = false;
        if (this.isStartElementOpen) {
            this.builder.append('>');
            this.isStartElementOpen = false;
        }
        this.builder.append(Constants.cr());
        int x = 0;
        while (x < this.numberOfTabs) {
            this.builder.append(this.tab());
            ++x;
        }
        super.element(frag);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.isLastEventText = false;
        --this.numberOfTabs;
        if (this.isStartElementOpen) {
            this.builder.append('/');
            this.builder.append('>');
            this.isStartElementOpen = false;
            return;
        }
        if (this.complexType) {
            this.builder.append(this.cr);
            int x = 0;
            while (x < this.numberOfTabs) {
                this.builder.append(this.tab());
                ++x;
            }
        } else {
            this.complexType = true;
        }
        super.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void characters(String value) {
        super.characters(value);
        this.isLastEventText = true;
        this.complexType = false;
    }

    @Override
    public void cdata(String value) {
        if (this.isStartElementOpen) {
            this.builder.append('>');
            this.isStartElementOpen = false;
        }
        super.cdata(value);
        this.complexType = false;
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String newNamespace, String newName) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.namespaceDeclaration(attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                FormattedWriterRecordContentHandler wrcHandler = new FormattedWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node, newNamespace, newName);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    private class FormattedWriterRecordContentHandler
    extends WriterRecord.WriterRecordContentHandler {
        private FormattedWriterRecordContentHandler() {
            super(FormattedWriterRecord.this);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (FormattedWriterRecord.this.isStartElementOpen) {
                FormattedWriterRecord.this.builder.append('>');
            }
            if (!FormattedWriterRecord.this.isLastEventText) {
                FormattedWriterRecord.this.builder.append(FormattedWriterRecord.this.cr);
                int x = 0;
                while (x < FormattedWriterRecord.this.numberOfTabs) {
                    FormattedWriterRecord.this.builder.append(FormattedWriterRecord.this.tab());
                    ++x;
                }
            }
            FormattedWriterRecord.this.builder.append('<');
            FormattedWriterRecord.this.builder.append(qName);
            FormattedWriterRecord formattedWriterRecord = FormattedWriterRecord.this;
            formattedWriterRecord.numberOfTabs = formattedWriterRecord.numberOfTabs + 1;
            FormattedWriterRecord.this.isStartElementOpen = true;
            FormattedWriterRecord.this.isLastEventText = false;
            this.handleAttributes(atts);
            this.writePrefixMappings();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            FormattedWriterRecord.this.isLastEventText = false;
            FormattedWriterRecord formattedWriterRecord = FormattedWriterRecord.this;
            formattedWriterRecord.numberOfTabs = formattedWriterRecord.numberOfTabs - 1;
            if (FormattedWriterRecord.this.isStartElementOpen) {
                FormattedWriterRecord.this.builder.append('/');
                FormattedWriterRecord.this.builder.append('>');
                FormattedWriterRecord.this.isStartElementOpen = false;
                FormattedWriterRecord.this.complexType = true;
                return;
            }
            if (FormattedWriterRecord.this.complexType) {
                FormattedWriterRecord.this.builder.append(FormattedWriterRecord.this.cr);
                int x = 0;
                while (x < FormattedWriterRecord.this.numberOfTabs) {
                    FormattedWriterRecord.this.builder.append(FormattedWriterRecord.this.tab());
                    ++x;
                }
            } else {
                FormattedWriterRecord.this.complexType = true;
            }
            super.endElement(namespaceURI, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (FormattedWriterRecord.this.isProcessingCData) {
                FormattedWriterRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (new String(ch).trim().length() == 0) {
                return;
            }
            super.characters(ch, start, length);
            FormattedWriterRecord.this.isLastEventText = true;
            FormattedWriterRecord.this.complexType = false;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (FormattedWriterRecord.this.isStartElementOpen) {
                FormattedWriterRecord.this.builder.append('>');
                FormattedWriterRecord.this.builder.append(FormattedWriterRecord.this.cr);
                FormattedWriterRecord.this.isStartElementOpen = false;
            }
            this.writeComment(ch, start, length);
            FormattedWriterRecord.this.complexType = false;
        }
    }
}

