/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.annotated;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionFactory;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.TSEISConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

@ConnectionDefinitions(value={@ConnectionDefinition(connectionFactory=TSConnectionFactory.class, connectionFactoryImpl=TSEISDataSource.class, connection=TSConnection.class, connectionImpl=TSEISConnection.class)})
public class AnnoManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
Referenceable,
Serializable {
    private Reference reference;
    private ResourceAdapter resourceAdapter;
    private int count;
    private String tsrValue;
    private String password;
    private String user;
    private String userName;
    private String setterMethodVal = "DEFAULT";
    @ConfigProperty(defaultValue="10", type=Integer.class, description={"Integer value"}, ignore=false)
    private Integer integer;
    @ConfigProperty
    private String factoryName = "AnnoManagedConnectionFactory";

    public AnnoManagedConnectionFactory() {
        String str = "AnnoManagedConnectionFactory factoryName=" + this.factoryName;
        ConnectorStatus.getConnectorStatus().logState(str);
        this.setSetterMethodVal("NONDEFAULT");
        this.debug(str);
    }

    @ConfigProperty
    public void setSetterMethodVal(String val) {
        this.setterMethodVal = val;
        String str = "AnnotatedResourceAdapterImpl.setSetterMethodVal=" + this.setterMethodVal;
        ConnectorStatus.getConnectorStatus().logState(str);
    }

    public String getSetterMethodVal() {
        return this.setterMethodVal;
    }

    public void setFactoryName(String name) {
        this.factoryName = name;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public Integer getInteger() {
        return this.integer;
    }

    public void setInteger(Integer val) {
        this.integer = val;
    }

    public String getUser() {
        this.debug("AnnoManagedConnectionFactory.getUser() returning:  " + this.user);
        return this.user;
    }

    public void setUser(String val) {
        this.debug("AnnoManagedConnectionFactory.setUser() with val = " + val);
        this.user = val;
    }

    public String getUserName() {
        this.debug("AnnoManagedConnectionFactory.getUserName() returning:  " + this.userName);
        return this.userName;
    }

    public void setUserName(String val) {
        this.debug("AnnoManagedConnectionFactory.setUserName() with val = " + val);
        this.userName = val;
    }

    public String getPassword() {
        this.debug("AnnoManagedConnectionFactory.getPassword() returning:  " + this.password);
        return this.password;
    }

    public void setPassword(String val) {
        this.debug("AnnoManagedConnectionFactory.setPassword() with val = " + val);
        this.password = val;
    }

    public String getTsrValue() {
        this.debug("AnnoManagedConnectionFactory getTsrValue called" + this.tsrValue);
        return this.tsrValue;
    }

    public void setTsrValue(String name) {
        this.debug("AnnoManagedConnectionFactory setTsrValue called" + name);
        this.tsrValue = name;
    }

    public void lookupTSR(String lookup) {
        try {
            TSNamingContext ncxt = new TSNamingContext();
            String newStr = "java:".concat(lookup);
            Object obj = ncxt.lookup(newStr);
            if (obj != null) {
                this.debug("TSR NOT Null");
            } else {
                this.debug("TSR Null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new TSEISDataSource((ManagedConnectionFactory)this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new TSEISDataSource((ManagedConnectionFactory)this, null);
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        ++this.count;
        String newStr1 = "AnnoManagedConnectionFactory setResourceAdapter " + this.count;
        this.debug(newStr1);
        this.resourceAdapter = ra;
    }

    public ResourceAdapter getResourceAdapter() {
        this.debug("AnnoManagedConnectionFactory.getResource");
        return this.resourceAdapter;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            TSConnection con = null;
            PasswordCredential pc = Util.getPasswordCredential((ManagedConnectionFactory)this, (Subject)subject, (ConnectionRequestInfo)info);
            if (pc == null) {
                this.debug("AnnoManagedConnectionFactory.createManagedConnection():  pc == null");
                this.debug("TSConnectionImpl.getConnection()");
                con = new TSConnectionImpl().getConnection();
            } else {
                this.debug("AnnoManagedConnectionFactory.createManagedConnection():  pc != null");
                this.setUser(pc.getUserName());
                this.setUserName(pc.getUserName());
                this.setPassword(new String(pc.getPassword()));
                this.debug("TSConnectionImpl.getConnection(u,p)");
                con = new TSConnectionImpl().getConnection(pc.getUserName(), pc.getPassword());
            }
            TSManagedConnection mcon = new TSManagedConnection((ManagedConnectionFactory)this, pc, null, con, false, true);
            this.dumpConnectionMetaData((ManagedConnection)mcon);
            return mcon;
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("Exception: " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public void dumpConnectionMetaData(ManagedConnection mcon) {
        String hdr = "AnnoManagedConnectionFactory: ";
        boolean bLocal = false;
        boolean bXA = false;
        try {
            ManagedConnectionMetaData mdata = mcon.getMetaData();
            String out = hdr + "displayName=" + mdata.getEISProductName();
            this.debug(out);
            out = hdr + "version=" + mdata.getEISProductVersion();
            this.debug(out);
            try {
                mcon.getLocalTransaction();
                bLocal = true;
            }
            catch (ResourceException ex) {
                System.out.println(hdr + "not a localTransaction type");
            }
            try {
                mcon.getXAResource();
                bXA = true;
            }
            catch (ResourceException ex) {
                System.out.println(hdr + "not a XAResource type");
            }
            out = hdr + "transactionSupport=";
            out = bLocal ? out + "LocalTransaction" : (bXA ? out + "XATransaction" : out + "NoTransaction");
            this.debug(out);
        }
        catch (ResourceException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential((ManagedConnectionFactory)this, (Subject)subject, (ConnectionRequestInfo)info);
        for (Object obj : connectionSet) {
            if (!(obj instanceof TSManagedConnection)) continue;
            TSManagedConnection mc = (TSManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual((PasswordCredential)mc.getPasswordCredential(), (PasswordCredential)pc) || mcf == null || !mcf.equals((Object)this)) continue;
            return mc;
        }
        System.out.println("matchManagedConnections: couldnt find match");
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AnnoManagedConnectionFactory)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AnnoManagedConnectionFactory that = (AnnoManagedConnectionFactory)obj;
        if (this.reference != null && !this.reference.equals(that.getReference())) {
            return false;
        }
        if (this.reference == null && that.getReference() != null) {
            return false;
        }
        if (this.resourceAdapter != null && !this.resourceAdapter.equals(that.getResourceAdapter())) {
            return false;
        }
        if (this.resourceAdapter == null && that.getResourceAdapter() != null) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (this.integer != null && !this.integer.equals(that.getInteger())) {
            return false;
        }
        if (this.integer == null && that.getInteger() != null) {
            return false;
        }
        if (!Util.isEqual((String)this.password, (String)that.getPassword())) {
            return false;
        }
        if (!Util.isEqual((String)this.user, (String)that.getUser())) {
            return false;
        }
        if (!Util.isEqual((String)this.userName, (String)that.getUserName())) {
            return false;
        }
        if (!Util.isEqual((String)this.tsrValue, (String)that.getTsrValue())) {
            return false;
        }
        if (!Util.isEqual((String)this.setterMethodVal, (String)that.getSetterMethodVal())) {
            return false;
        }
        return Util.isEqual((String)this.factoryName, (String)that.getFactoryName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Reference getReference() {
        Reference ref = this.reference;
        return ref;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public void debug(String out) {
        Debug.trace((String)("AnnoManagedConnectionFactory:  " + out));
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int val) {
        this.count = val;
    }
}

