/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectQueryPlan;
import com.sun.jdo.spi.persistence.utility.ParameterInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class RetrieveDescImpl
implements RetrieveDesc,
Cloneable {
    private static final int OPINFO_FIELD_DISALLOWED = 1;
    private static final int OPINFO_FIELD_REQUIRED = 2;
    private static final int OPINFO_VAL_DISALLOWED = 4;
    private static final int OPINFO_VAL_REQUIRED = 8;
    private static final int OPINFO_VAL_IS_PCOUNT = 16;
    private static final int OPINFO_ILLEGAL = 32;
    private static final int OPINFO_NO_OPERATION = 64;
    public static final int OPT_PROJECTION = 1;
    public static final int OPT_DISTINCT = 2;
    public static final int OPT_FOR_UPDATE = 4;
    public static final int OPT_AVG = 8;
    public static final int OPT_MIN = 16;
    public static final int OPT_MAX = 32;
    public static final int OPT_SUM = 64;
    public static final int OPT_COUNT = 128;
    public static final int OPT_COUNT_PC = 256;
    public static final int OPT_AGGREGATE = 504;
    public static final int OPT_AGGREGATE_NON_COUNT_PC = 248;
    public static final int OPT_ADD_FETCHGROUPS = 512;
    public static final int OPT_ADD_KEYS_ONLY = 1024;
    public static final int OPT_DISABLE_RELATIONSHIP_PREFETCH = 2048;
    public static final int OPT_VERIFY = 4096;
    private ArrayList fields;
    private Constraint constraint;
    private int options;
    private Class pcClass;
    private ClassDesc config;
    private SelectQueryPlan plan;
    private Object navigationalId;
    private int aggregateResultType = 0;
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)RetrieveDescImpl.class.getClassLoader());

    public RetrieveDescImpl(Class pcClass, ClassDesc config) {
        this.pcClass = pcClass;
        this.config = config;
        this.fields = new ArrayList();
        this.constraint = new Constraint();
    }

    @Override
    public void addResult(String name, RetrieveDesc foreignConstraint, boolean projection) {
        ConstraintFieldName cfName = new ConstraintFieldName(name, foreignConstraint);
        if (projection) {
            if ((this.options & 1) > 0) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.retrievedesc.toomanyprojections"));
            }
            if (foreignConstraint != null) {
                ((RetrieveDescImpl)foreignConstraint).options |= 1;
            } else {
                cfName.setProjection();
            }
        }
        this.fields.add(cfName);
    }

    @Override
    public void addResult(int opCode, int aggregateResultType) {
        switch (opCode) {
            case 7: {
                this.options |= 2;
                break;
            }
            case 58: {
                this.options |= 8;
                break;
            }
            case 59: {
                this.options |= 0x10;
                break;
            }
            case 61: {
                this.options |= 0x20;
                break;
            }
            case 60: {
                this.options |= 0x40;
                break;
            }
            case 62: {
                this.options |= 0x80;
                break;
            }
            case 63: {
                this.options |= 0x100;
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + opCode)));
            }
        }
        if (aggregateResultType != 0) {
            if (this.aggregateResultType == 0) {
                this.aggregateResultType = aggregateResultType;
            } else {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.retrievedesc.toomanyresulttypes"));
            }
        }
    }

    public void addPrefetchedField(String name, RetrieveDesc foreignConstraint) {
        this.fields.add(new ConstraintFieldName(name, foreignConstraint, true));
    }

    @Override
    public void setPrefetchEnabled(boolean prefetchEnabled) {
        if (!prefetchEnabled) {
            this.options |= 0x800;
        }
    }

    @Override
    public void addConstraint(String name, RetrieveDesc foreignConstraint) {
        if (name == null) {
            this.constraint.addField(null, foreignConstraint);
        } else {
            this.constraint.addForeignField(name, foreignConstraint);
        }
    }

    @Override
    public void addConstraint(String name, int operation, RetrieveDesc foreignConstraint, String foreignName) {
        this.constraint.addField(foreignName, foreignConstraint);
        this.constraint.addField(name, null);
        this.constraint.addOperation(operation);
    }

    @Override
    public void addConstraint(String name, int operation, Object value) {
        int info = RetrieveDescImpl.getOperationInfo(operation);
        if ((info & 0x20) > 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + operation)));
        }
        if ((info & 2) > 0 && name == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.fieldrequired", (String)("" + operation)));
        }
        if ((info & 1) > 0 && name != null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.fielddisallowed", (String)("" + operation)));
        }
        if ((info & 8) > 0 && value == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.valrequired", (String)("" + operation)));
        }
        if ((info & 4) > 0 && value != null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.valdisallowed", (String)("" + operation)));
        }
        if ((info & 0x10) > 0) {
            if (name != null) {
                this.constraint.addField(name, null);
            }
            this.addValueConstraint(name, value);
        } else {
            switch (operation) {
                case 53: {
                    this.addParameterConstraint(value);
                    break;
                }
                case 14: 
                case 55: {
                    this.constraint.addConstraintFieldSubQuery(name, (ActionDesc)value);
                    break;
                }
                default: {
                    if (value != null) {
                        this.addValueConstraint(name, value);
                    }
                    if (name == null) break;
                    this.constraint.addField(name, null);
                }
            }
        }
        if ((info & 0x40) == 0) {
            this.constraint.addOperation(operation);
        }
    }

    public void addParameterConstraints(LocalFieldDesc[] fields, int startIndex) {
        for (int i = 0; i < fields.length; ++i) {
            LocalFieldDesc field = fields[i];
            this.addParameterConstraint(field, i + startIndex);
        }
    }

    public void addParameterConstraint(LocalFieldDesc field, int index) {
        String fieldName = field.getName();
        int type = field.getEnumType();
        this.addConstraint(null, 53, new ParameterInfo(index, type, fieldName));
        this.addConstraint(fieldName, 5, null);
        this.addConstraint(null, 9, null);
    }

    private void addValueConstraint(String name, Object value) {
        this.constraint.addValue(value, this.getLocalFieldDesc(name));
    }

    private void addParameterConstraint(Object value) {
        if (!(value instanceof ParameterInfo)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalParameterInfo"));
        }
        ParameterInfo parameterInfo = (ParameterInfo)value;
        this.constraint.addParamIndex(parameterInfo.getIndex(), parameterInfo.getType(), this.getLocalFieldDesc(parameterInfo.getAssociatedField()));
    }

    private LocalFieldDesc getLocalFieldDesc(String name) {
        return name == null ? null : this.config.getLocalFieldDesc(name);
    }

    private static int getOperationInfo(int operation) {
        int info;
        switch (operation) {
            case 1: {
                info = 4;
                break;
            }
            case 2: {
                info = 0;
                break;
            }
            case 3: {
                info = 0;
                break;
            }
            case 5: {
                info = 70;
                break;
            }
            case 6: {
                info = 0;
                break;
            }
            case 8: {
                info = 0;
                break;
            }
            case 9: {
                info = 0;
                break;
            }
            case 25: {
                info = 0;
                break;
            }
            case 10: {
                info = 0;
                break;
            }
            case 26: {
                info = 5;
                break;
            }
            case 12: {
                info = 0;
                break;
            }
            case 13: {
                info = 0;
                break;
            }
            case 14: 
            case 55: {
                info = 10;
                break;
            }
            case 15: {
                info = 0;
                break;
            }
            case 16: {
                info = 0;
                break;
            }
            case 17: {
                info = 4;
                break;
            }
            case 19: {
                info = 0;
                break;
            }
            case 48: {
                info = 0;
                break;
            }
            case 21: {
                info = 0;
                break;
            }
            case 22: {
                info = 4;
                break;
            }
            case 24: {
                info = 0;
                break;
            }
            case 29: {
                info = 0;
                break;
            }
            case 30: {
                info = 0;
                break;
            }
            case 31: {
                info = 0;
                break;
            }
            case 32: {
                info = 89;
                break;
            }
            case 33: {
                info = 0;
                break;
            }
            case 34: {
                info = 4;
                break;
            }
            case 47: {
                info = 4;
                break;
            }
            case 36: {
                info = 0;
                break;
            }
            case 49: {
                info = 0;
                break;
            }
            case 50: {
                info = 0;
                break;
            }
            case 51: {
                info = 0;
                break;
            }
            case 54: {
                info = 2;
                break;
            }
            case 44: {
                info = 0;
                break;
            }
            case 40: {
                info = 73;
                break;
            }
            case 53: {
                info = 73;
                break;
            }
            case 27: 
            case 28: {
                info = 0;
                break;
            }
            case 57: {
                info = 0;
                break;
            }
            default: {
                info = 32;
            }
        }
        return info;
    }

    public synchronized SelectQueryPlan buildQueryPlan(SQLStoreManager store, Concurrency concurrency) {
        if (this.plan == null) {
            this.handleProjection();
            this.plan = SelectQueryPlan.newInstance(this, store, concurrency);
            this.plan.build();
            ArrayList statements = this.plan.getStatements();
            if (statements.size() > 1) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.retrievedesc.stmntsnotjoined"));
            }
        }
        return this.plan;
    }

    private void handleProjection() {
        int queryOptions = this.options & 0x9F8;
        RetrieveDescImpl projectedDesc = this.distributeQueryOptions(queryOptions, this.aggregateResultType);
        if (projectedDesc == null) {
            this.options |= 1;
            this.setFetchGroupOptions(queryOptions);
        }
    }

    private RetrieveDescImpl distributeQueryOptions(int queryOptions, int aggregateResultType) {
        RetrieveDescImpl projectedDesc = null;
        if ((this.options & 1) > 0) {
            this.setFetchGroupOptions(queryOptions);
            this.aggregateResultType = aggregateResultType;
            projectedDesc = this;
        }
        this.options |= queryOptions;
        for (int i = 0; i < this.fields.size(); ++i) {
            ConstraintFieldName cfn = (ConstraintFieldName)this.fields.get(i);
            if (cfn.isProjection()) {
                this.aggregateResultType = aggregateResultType;
                projectedDesc = this;
                continue;
            }
            if (cfn.desc == null) continue;
            projectedDesc = ((RetrieveDescImpl)cfn.desc).distributeQueryOptions(queryOptions, aggregateResultType);
        }
        return projectedDesc;
    }

    private void setFetchGroupOptions(int queryOptions) {
        if ((queryOptions & 0xF8) == 0) {
            this.options |= 0x200;
            if (queryOptions == 256) {
                this.options |= 0x400;
            }
        }
    }

    @Override
    public void setNavigationalId(Object navigationalId) {
        this.navigationalId = navigationalId;
    }

    public Object getNavigationalId() {
        return this.navigationalId;
    }

    public void setOption(int option) {
        this.options |= option;
    }

    public int getAggregateResultType() {
        return this.aggregateResultType;
    }

    public int getOptions() {
        return this.options;
    }

    public SelectQueryPlan getPlan() {
        return this.plan;
    }

    public ClassDesc getConfig() {
        return this.config;
    }

    public void setPlan(SelectQueryPlan plan) {
        this.plan = plan;
    }

    @Override
    public Class getPersistenceCapableClass() {
        return this.pcClass;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Iterator getFields() {
        return this.fields.iterator();
    }

    public Object clone() {
        try {
            RetrieveDescImpl clone = (RetrieveDescImpl)super.clone();
            clone.fields = new ArrayList();
            clone.constraint = new Constraint();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

