/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.session;

import java.net.URLEncoder;

public final class SessionCookieConfig {
    public static final String DYNAMIC_SECURE = "dynamic";
    private String _name = null;
    private String _path = null;
    private Integer _maxAge = null;
    private String _domain = null;
    private String _comment = null;
    private String _secure = "dynamic";
    private Boolean _httpOnly = null;

    public SessionCookieConfig() {
    }

    public SessionCookieConfig(String name, String path, int maxAge, String domain, String comment) {
        this.setName(name);
        this.setPath(path);
        this.setMaxAge(maxAge);
        this.setDomain(domain);
        this.setComment(comment);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    public void setMaxAge(Integer maxAge) {
        this._maxAge = maxAge;
    }

    public Integer getMaxAge() {
        return this._maxAge;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setComment(String comment) {
        this._comment = comment;
        if (comment != null) {
            this._comment = URLEncoder.encode(comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void setSecure(String secure) throws IllegalArgumentException {
        if (secure == null || !secure.equalsIgnoreCase("true") && !secure.equalsIgnoreCase("false") && !secure.equalsIgnoreCase(DYNAMIC_SECURE)) {
            throw new IllegalArgumentException();
        }
        this._secure = secure;
    }

    public String getSecure() {
        return this._secure;
    }

    public void setHttpOnly(Boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public Boolean getHttpOnly() {
        return this._httpOnly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionCookieConfig[");
        if (this._name != null) {
            sb.append("name=");
            sb.append(this._name);
        }
        if (this._path != null) {
            sb.append(", path=");
            sb.append(this._path);
        }
        sb.append(", maxAge=");
        sb.append(this._maxAge);
        if (this._domain != null) {
            sb.append(", domain=");
            sb.append(this._domain);
        }
        if (this._comment != null) {
            sb.append(", comment=");
            sb.append(this._comment);
        }
        sb.append(", secure=");
        sb.append(this._secure);
        if (this._httpOnly != null) {
            sb.append(", httpOnly=");
            sb.append(this._httpOnly);
        }
        sb.append("]");
        return sb.toString();
    }
}

