/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.batch.spi.impl.BatchRuntimeHelper;
import org.glassfish.batch.spi.impl.GlassFishBatchSecurityHelper;

public abstract class AbstractListCommand
implements AdminCommand {
    @Inject
    BatchRuntimeHelper helper;
    @Inject
    protected Logger logger;
    @Param(name="terse", optional=true, defaultValue="false", shortName="t")
    public boolean isTerse = false;
    @Param(name="output", shortName="o", optional=true)
    protected String outputHeaderList;
    @Param(name="header", shortName="h", optional=true)
    protected boolean header;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    protected String[] outputHeaders;
    protected String[] displayHeaders;
    @Inject
    GlassFishBatchSecurityHelper glassFishBatchSecurityHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        try {
            this.calculateHeaders();
            this.helper.checkAndInitializeBatchRuntime();
            this.glassFishBatchSecurityHelper.markInvocationPrivilege(true);
            this.executeCommand(context, extraProperties);
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception ex) {
            this.logger.log(Level.FINE, "Exception during command ", ex);
            actionReport.setMessage(ex.getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        finally {
            this.glassFishBatchSecurityHelper.markInvocationPrivilege(false);
        }
    }

    private void calculateHeaders() {
        String[] headers = this.getDefaultHeaders();
        if (this.outputHeaderList != null) {
            headers = this.outputHeaderList.split("[,]");
            if (headers.length == 0) {
                headers = this.getDefaultHeaders();
            }
        } else if (this.supportsLongFormat()) {
            headers = this.getAllHeaders();
        }
        HashMap<String, String> validHeaders = new HashMap<String, String>();
        for (String h : this.getAllHeaders()) {
            validHeaders.put(h.toLowerCase(Locale.US), h);
        }
        for (int i = 0; i < headers.length; ++i) {
            String val = (String)validHeaders.get(headers[i].toLowerCase(Locale.US));
            if (val == null) {
                throw new IllegalArgumentException("Invalid header " + headers[i]);
            }
            headers[i] = val;
        }
        this.outputHeaders = headers;
        this.displayHeaders = new String[this.outputHeaders.length];
        for (int index = 0; index < this.displayHeaders.length; ++index) {
            this.displayHeaders[index] = this.isHeaderRequired() ? this.outputHeaders[index].toUpperCase(Locale.US) : "";
        }
    }

    protected static JobOperator getJobOperatorFromBatchRuntime() {
        try {
            return BatchRuntime.getJobOperator();
        }
        catch (ServiceConfigurationError error) {
            throw new IllegalStateException("Could not get JobOperator.  Check if the Batch DataSource is configured properly and Check if the Database is up and running", error);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not get JobOperator. ", ex);
        }
    }

    protected boolean isHeaderRequired() {
        return !this.isTerse || this.header;
    }

    protected boolean supportsLongFormat() {
        return true;
    }

    protected abstract void executeCommand(AdminCommandContext var1, Properties var2) throws Exception;

    protected abstract String[] getAllHeaders();

    protected abstract String[] getDefaultHeaders();

    protected String[] getOutputHeaders() {
        return this.outputHeaders;
    }

    protected String[] getDisplayHeaders() {
        return this.displayHeaders;
    }
}

