/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.AsyncProvider;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import org.glassfish.webservices.WebServiceContextImpl;

public class InvokerImpl
extends Invoker {
    protected final Invoker core;
    protected final Object invokeObject;
    protected final WebServiceContextImpl injectedWSCtxt;
    private static final boolean jaxwsDirect = Boolean.getBoolean("com.sun.enterprise.webservice.jaxwsDirect");
    private static final Method invokeMethod;
    private static final Method asyncInvokeMethod;

    public InvokerImpl(Invoker core, Object inv, WebServiceContextImpl wsc) {
        this.core = core;
        this.injectedWSCtxt = wsc;
        this.invokeObject = inv;
    }

    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        if (this.injectedWSCtxt != null) {
            this.injectedWSCtxt.setContextDelegate(wsc);
        }
        this.core.start((WSWebServiceContext)this.injectedWSCtxt, endpoint);
    }

    public void dispose() {
        this.core.dispose();
    }

    public Object invoke(Packet p, Method m, Object ... args) throws InvocationTargetException, IllegalAccessException {
        if (jaxwsDirect) {
            return this.core.invoke(p, m, args);
        }
        Object ret = null;
        if (this.invokeObject != null) {
            ret = m.invoke(this.invokeObject, args);
        }
        return ret;
    }

    public <T> T invokeProvider(Packet p, T arg) throws IllegalAccessException, InvocationTargetException {
        if (jaxwsDirect) {
            return (T)this.core.invokeProvider(p, arg);
        }
        Object ret = null;
        if (this.invokeObject != null) {
            ret = invokeMethod.invoke(this.invokeObject, arg);
        }
        return (T)ret;
    }

    public <T> void invokeAsyncProvider(Packet p, T arg, AsyncProviderCallback cbak, WebServiceContext ctxt) throws IllegalAccessException, InvocationTargetException {
        if (jaxwsDirect) {
            this.core.invokeAsyncProvider(p, arg, cbak, ctxt);
        }
        if (this.invokeObject != null) {
            asyncInvokeMethod.invoke(this.invokeObject, arg);
        }
    }

    static {
        try {
            invokeMethod = Provider.class.getMethod("invoke", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        try {
            asyncInvokeMethod = AsyncProvider.class.getMethod("invoke", Object.class, AsyncProviderCallback.class, WebServiceContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

