/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModeler;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModeler101;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModeler103;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModelerBase;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralExceptionModeler;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralExceptionModeler111;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralSimpleTypeCreator;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class RmiModeler
implements RmiConstants,
Modeler {
    private final String modelName;
    private final String typeUri;
    private final String wsdlUri;
    private final RmiModelInfo modelInfo;
    private ProcessorEnvironment env;
    private Map structMap;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private Map messageMap;
    private NamespaceMappingRegistryInfo namespaceMappingRegistry;
    private Model model;
    private static final Set excludedInterfaces = new HashSet();
    private Class remoteExceptionClass = null;
    private Class defHolder = null;
    private Class defRemote = null;
    private RmiTypeModeler rmiTypeModeler_11;
    private RmiTypeModeler rmiTypeModeler_12;
    private LiteralTypeModeler literalTypeModeler;
    private ExceptionModelerBase exceptionModeler_11;
    private ExceptionModelerBase exceptionModeler_12;
    private ExceptionModelerBase literalExceptionModeler;
    private boolean useDocLiteral = false;
    private boolean useWSIBasicProfile = false;
    private boolean useRPCLiteral = false;
    private boolean generateOneWayOperations = false;
    private boolean strictCompliance = false;
    private Properties options;
    private String sourceVersion;

    public RmiModeler(RmiModelInfo rmiModelInfo, Properties options) {
        this.modelInfo = rmiModelInfo;
        this.options = options;
        this.modelName = rmiModelInfo.getName();
        this.typeUri = rmiModelInfo.getTypeNamespaceURI();
        this.wsdlUri = rmiModelInfo.getTargetNamespaceURI();
        this.env = (ProcessorEnvironment)rmiModelInfo.getConfiguration().getEnvironment();
        try {
            this.remoteExceptionClass = RmiUtils.getClassForName(REMOTE_EXCEPTION_CLASSNAME, this.env.getClassLoader());
            this.defHolder = RmiUtils.getClassForName(HOLDER_CLASSNAME, this.env.getClassLoader());
            this.defRemote = RmiUtils.getClassForName(REMOTE_CLASSNAME, this.env.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String className = REMOTE_CLASSNAME;
            if (this.remoteExceptionClass == null) {
                className = REMOTE_EXCEPTION_CLASSNAME;
            } else if (this.defHolder == null) {
                className = HOLDER_CLASSNAME;
            }
            throw new ModelerException("rmimodeler.class.not.found", className);
        }
        this.typeMappingRegistry = rmiModelInfo.getTypeMappingRegistry();
        this.namespaceMappingRegistry = rmiModelInfo.getNamespaceMappingRegistry();
        this.useDocLiteral = Boolean.valueOf(options.getProperty("useDocumentLiteralEncoding"));
        this.useWSIBasicProfile = Boolean.valueOf(options.getProperty("useWSIBasicProfile"));
        this.useRPCLiteral = Boolean.valueOf(options.getProperty("useRPCLiteralEncoding"));
        this.generateOneWayOperations = Boolean.valueOf(options.getProperty("generateOneWayOperations"));
        this.strictCompliance = Boolean.valueOf(options.getProperty("strictCompliance"));
        if (this.useDocLiteral && this.useRPCLiteral) {
            throw new ModelerException("rmimodeler.invalid.encoding", new LocalizableExceptionAdapter(new Exception("Both -f:docliteral and -f:rpcliteral specified.")));
        }
        this.rmiTypeModeler_11 = new RmiTypeModeler(this, this.env, SOAPVersion.SOAP_11);
        this.rmiTypeModeler_12 = new RmiTypeModeler(this, this.env, SOAPVersion.SOAP_12);
        this.exceptionModeler_11 = this.getExceptionModeler(this.rmiTypeModeler_11);
        this.exceptionModeler_12 = new ExceptionModeler(this, this.rmiTypeModeler_12);
        this.literalTypeModeler = new LiteralTypeModeler(this, this.env);
        this.literalExceptionModeler = this.getLiteralExceptionModeler(this.literalTypeModeler);
        this.sourceVersion = options.getProperty("sourceVersion");
    }

    private ExceptionModelerBase getExceptionModeler(RmiTypeModeler rmiTypeModeler_11) {
        if (VersionUtil.isVersion101(this.options.getProperty("sourceVersion"))) {
            return new ExceptionModeler101(this, rmiTypeModeler_11);
        }
        if (VersionUtil.isVersion103(this.options.getProperty("sourceVersion"))) {
            return new ExceptionModeler103(this, rmiTypeModeler_11);
        }
        if (VersionUtil.isVersion11(this.options.getProperty("sourceVersion"))) {
            return new ExceptionModeler(this, rmiTypeModeler_11);
        }
        return new ExceptionModeler(this, rmiTypeModeler_11);
    }

    private ExceptionModelerBase getLiteralExceptionModeler(LiteralTypeModeler typeModeler) {
        String version = this.options.getProperty("sourceVersion");
        if (VersionUtil.isVersion11(version) || VersionUtil.isVersion111(version)) {
            return new LiteralExceptionModeler111(this, typeModeler);
        }
        return new LiteralExceptionModeler(this, typeModeler);
    }

    public ProcessorEnvironment getProcessorEnvironment() {
        return this.env;
    }

    protected Properties getOptions() {
        return this.options;
    }

    public TypeMappingRegistryInfo getTypeMappingRegistryInfo() {
        return this.typeMappingRegistry;
    }

    public NamespaceMappingRegistryInfo getNamespaceMappingRegistryInfo() {
        return this.namespaceMappingRegistry;
    }

    public Class getDefHolder() {
        return this.defHolder;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isStrictCompliant() {
        return this.strictCompliance;
    }

    public String getServicePackage() {
        String servicePackage = "";
        if (this.model != null) {
            int idx;
            Iterator services = this.getModel().getServices();
            Service service = null;
            while (services != null && services.hasNext()) {
                service = (Service)services.next();
            }
            if (service != null) {
                servicePackage = service.getJavaInterface().getName();
            }
            servicePackage = (idx = servicePackage.lastIndexOf(".")) > 0 ? servicePackage.substring(0, idx) : "";
        }
        return servicePackage;
    }

    public LiteralElementMember modelTypeLiteral(QName elemName, String typeUri, RmiType type) {
        return this.literalTypeModeler.modelTypeLiteral(elemName, typeUri, type);
    }

    public LiteralSimpleTypeCreator getLieralTypes() {
        return this.literalTypeModeler.getLiteralTypes();
    }

    protected void addFaultParent(Fault fault, ExceptionModelerBase exceptionModeler) {
        try {
            Class javaClass = RmiUtils.getClassForName(fault.getJavaException().getRealName(), this.env.getClassLoader());
            javaClass = javaClass.getSuperclass();
            if (javaClass != null && !javaClass.getName().equals(EXCEPTION_CLASSNAME)) {
                Fault parentFault = exceptionModeler.modelException(this.typeUri, this.wsdlUri, javaClass);
                parentFault.addSubfault(fault);
                parentFault.getJavaException().addSubclass(fault.getJavaException());
                if (parentFault.getJavaException().getOwner() instanceof SOAPStructureType) {
                    ((SOAPStructureType)parentFault.getJavaException().getOwner()).addSubtype((SOAPStructureType)fault.getJavaException().getOwner());
                } else if (parentFault.getJavaException().getOwner() instanceof LiteralStructuredType) {
                    ((LiteralStructuredType)parentFault.getJavaException().getOwner()).addSubtype((LiteralStructuredType)fault.getJavaException().getOwner());
                }
                Block block = parentFault.getBlock();
                block.setType((AbstractType)parentFault.getJavaException().getOwner());
                this.addFaultParent(parentFault, exceptionModeler);
                if (parentFault.getJavaException().getOwner() instanceof SOAPStructureType) {
                    RmiModeler.markInheritedMembers((SOAPStructureType)fault.getJavaException().getOwner(), (SOAPStructureType)parentFault.getJavaException().getOwner());
                } else if (parentFault.getJavaException().getOwner() instanceof LiteralStructuredType) {
                    RmiModeler.markInheritedMembers((LiteralStructuredType)fault.getJavaException().getOwner(), (LiteralStructuredType)parentFault.getJavaException().getOwner());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
    }

    public static void markInheritedMembers(SOAPStructureType type1, SOAPStructureType type2) {
        Iterator members1 = type1.getMembers();
        block0: while (members1.hasNext()) {
            Iterator members2 = type2.getMembers();
            SOAPStructureMember member1 = (SOAPStructureMember)members1.next();
            while (members2.hasNext()) {
                SOAPStructureMember member2 = (SOAPStructureMember)members2.next();
                if (!RmiModeler.membersMatch(member1, member2)) continue;
                member1.setInherited(true);
                member1.getJavaStructureMember().setInherited(true);
                continue block0;
            }
        }
    }

    public static boolean membersMatch(SOAPStructureMember member1, SOAPStructureMember member2) {
        return member1.getName().equals(member2.getName()) && member1.getType().equals(member2.getType());
    }

    public static void markInheritedMembers(LiteralStructuredType type1, LiteralStructuredType type2) {
        Iterator members2;
        Iterator members1 = type1.getElementMembers();
        block0: while (members1.hasNext()) {
            members2 = type2.getElementMembers();
            LiteralElementMember member1 = (LiteralElementMember)members1.next();
            while (members2.hasNext()) {
                LiteralElementMember member2 = (LiteralElementMember)members2.next();
                if (!RmiModeler.membersMatch(member1, member2)) continue;
                member1.setInherited(true);
                member1.getJavaStructureMember().setInherited(true);
                continue block0;
            }
        }
        members1 = type1.getAttributeMembers();
        block2: while (members1.hasNext()) {
            members2 = type2.getAttributeMembers();
            LiteralAttributeMember attr1 = (LiteralAttributeMember)members1.next();
            while (members2.hasNext()) {
                LiteralAttributeMember attr2 = (LiteralAttributeMember)members2.next();
                if (!RmiModeler.membersMatch(attr1, attr2)) continue;
                attr1.setInherited(true);
                attr1.getJavaStructureMember().setInherited(true);
                continue block2;
            }
        }
    }

    public static boolean membersMatch(LiteralElementMember member1, LiteralElementMember member2) {
        return member1.getName().equals(member2.getName()) && member1.getType().equals(member2.getType());
    }

    public static boolean membersMatch(LiteralAttributeMember member1, LiteralAttributeMember member2) {
        return member1.getName().equals(member2.getName()) && member1.getType().equals(member2.getType());
    }

    @Override
    public Model buildModel() {
        this.log("creating model: " + this.modelName);
        this.model = new Model(new QName(null, this.modelName));
        this.model.setProperty("com.sun.xml.rpc.processor.model.ModelerName", this.getClass().getName());
        this.model.setTargetNamespaceURI(this.wsdlUri);
        if (this.useDocLiteral || this.useWSIBasicProfile || this.useRPCLiteral) {
            return this.buildLiteralModel();
        }
        return this.buildEncodedModel();
    }

    private Model buildEncodedModel() {
        try {
            if (this.typeMappingRegistry != null) {
                Iterator iter = this.typeMappingRegistry.getImportedDocuments();
                while (iter.hasNext()) {
                    this.model.addImportedDocument((ImportedDocumentInfo)iter.next());
                }
                Iterator iter2 = this.typeMappingRegistry.getExtraTypeNames();
                while (iter2.hasNext()) {
                    RmiType type = RmiType.getRmiType(RmiUtils.getClassForName((String)iter2.next(), this.env.getClassLoader()));
                    if (RmiModeler.isException(this.env, type)) {
                        Fault fault = this.exceptionModeler_11.modelException(this.typeUri, this.wsdlUri, type.getTypeClass(this.env.getClassLoader()));
                        this.addFaultParent(fault, this.exceptionModeler_11);
                        continue;
                    }
                    SOAPType extraType = this.rmiTypeModeler_11.modelTypeSOAP(this.typeUri, type);
                    this.model.addExtraType(extraType);
                }
            }
            this.structMap = new HashMap();
            String javaServiceName = StringUtils.capitalize(this.modelInfo.getName());
            this.log("creating service: " + javaServiceName);
            String serviceInterface = this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("") ? this.modelInfo.getJavaPackageName() + "." + javaServiceName : javaServiceName;
            Service service = new Service(new QName(this.wsdlUri, javaServiceName), new JavaInterface(serviceInterface, serviceInterface + "Impl"));
            this.model.addService(service);
            Iterator interfaces = this.modelInfo.getInterfaces();
            while (interfaces.hasNext()) {
                RmiInterfaceInfo interfaceInfo = (RmiInterfaceInfo)interfaces.next();
                service.addPort(this.modelPort(interfaceInfo));
            }
            this.rmiTypeModeler_11.modelSubclasses(this.typeUri);
            this.messageMap = null;
        }
        catch (ModelerException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new ModelerException(e);
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
        this.structMap = null;
        return this.model;
    }

    private Model buildLiteralModel() {
        try {
            if (this.typeMappingRegistry != null) {
                Iterator iter = this.typeMappingRegistry.getImportedDocuments();
                while (iter.hasNext()) {
                    this.model.addImportedDocument((ImportedDocumentInfo)iter.next());
                }
                Iterator iter2 = this.typeMappingRegistry.getExtraTypeNames();
                while (iter2.hasNext()) {
                    RmiType type = RmiType.getRmiType(RmiUtils.getClassForName((String)iter2.next(), this.env.getClassLoader()));
                    if (RmiModeler.isException(this.env, type)) {
                        Fault fault = this.literalExceptionModeler.modelException(this.typeUri, this.wsdlUri, type.getTypeClass(this.env.getClassLoader()));
                        this.addFaultParent(fault, this.literalExceptionModeler);
                        continue;
                    }
                    QName elemName = new QName(type.getTypeSignature());
                    LiteralElementMember member = this.literalTypeModeler.modelTypeLiteral(elemName, this.typeUri, type);
                    this.model.addExtraType(member.getType());
                }
            }
            this.structMap = new HashMap();
            String javaServiceName = StringUtils.capitalize(this.modelInfo.getName());
            this.log("creating service: " + javaServiceName);
            String serviceInterface = this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("") ? this.modelInfo.getJavaPackageName() + "." + javaServiceName : javaServiceName;
            Service service = new Service(new QName(this.wsdlUri, javaServiceName), new JavaInterface(serviceInterface, serviceInterface + "Impl"));
            this.model.addService(service);
            Iterator interfaces = this.modelInfo.getInterfaces();
            while (interfaces.hasNext()) {
                RmiInterfaceInfo interfaceInfo = (RmiInterfaceInfo)interfaces.next();
                service.addPort(this.modelPort(interfaceInfo));
            }
            this.literalTypeModeler.modelSubclasses(this.typeUri);
            if (this.useDocLiteral) {
                this.checkForDocLiteralNameClashes(this.model);
            }
            this.messageMap = null;
        }
        catch (ModelerException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new ModelerException(e);
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
        this.structMap = null;
        return this.model;
    }

    private void checkForDocLiteralNameClashes(Model model) throws ModelerException {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            Iterator ports = ((Service)services.next()).getPorts();
            while (ports.hasNext()) {
                Iterator operations = ((Port)ports.next()).getOperations();
                while (operations.hasNext()) {
                    Operation operation = (Operation)operations.next();
                    this.checkForMessageNameClash(operation.getRequest());
                    this.checkForMessageNameClash(operation.getResponse());
                }
            }
        }
    }

    private void checkForMessageNameClash(Message message) throws ModelerException {
        if (message != null) {
            Iterator bodyBlocks = message.getBodyBlocks();
            while (bodyBlocks.hasNext()) {
                Block block = (Block)bodyBlocks.next();
                if (!this.literalTypeModeler.nameClashes(block.getType().getName().getLocalPart())) continue;
                throw new ModelerException("rmimodeler.operation.name.clashes.with.type.name", block.getType().getName().getLocalPart());
            }
        }
    }

    public static boolean isException(ProcessorEnvironment env, RmiType type) {
        try {
            if (type.getTypeCode() != 10) {
                return false;
            }
            for (Class typeClass = type.getTypeClass(env.getClassLoader()); typeClass != null; typeClass = typeClass.getSuperclass()) {
                if (!typeClass.getName().equals(EXCEPTION_CLASSNAME)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private Port modelPort(RmiInterfaceInfo interfaceInfo) {
        Port port = null;
        try {
            String implClassName = RmiUtils.getRealName(interfaceInfo.getName(), this.env.getClassLoader());
            Class def = RmiUtils.getClassForName(implClassName, this.env.getClassLoader());
            this.validateEndpointClass(def);
            port = this.processInterface(def, implClassName, interfaceInfo);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        return port;
    }

    private void validateEndpointClass(Class endpointClass) throws ModelerException {
        if (!endpointClass.isInterface()) {
            throw new ModelerException("rmimodeler.service.endpoint.must.be.interface", endpointClass.getName());
        }
        if (!this.defRemote.isAssignableFrom(endpointClass)) {
            throw new ModelerException("rmimodeler.must.implement.remote", endpointClass.getName());
        }
    }

    private Port processInterface(Class endpointClass, String intfName, RmiInterfaceInfo interfaceInfo) {
        this.messageMap = new HashMap();
        String servant = interfaceInfo.getServantName();
        this.log("creating port: " + ClassNameInfo.replaceInnerClassSym(endpointClass.getName()));
        String portName = ClassNameInfo.getName(endpointClass.getName().replace('$', '_'));
        String packageName = endpointClass.getPackage().getName();
        String namespace = this.wsdlUri;
        Port port = new Port(new QName(namespace, portName));
        port.setSOAPVersion(interfaceInfo.getSOAPVersion());
        JavaInterface javaInterface = new JavaInterface(intfName, servant);
        port.setJavaInterface(javaInterface);
        Class<?>[] remoteInterfaces = endpointClass.getInterfaces();
        for (int i = 0; i < remoteInterfaces.length; ++i) {
            String interfaceName = this.env.getNames().removeCharacter(32, remoteInterfaces[i].getName());
            if (interfaceName.equals(javaInterface.getName())) continue;
            javaInterface.addInterface(interfaceName);
        }
        Iterator methods = this.sortMethods(endpointClass, endpointClass.getMethods());
        while (methods.hasNext()) {
            Method method = (Method)methods.next();
            if (!this.verifyRemoteMethod(method)) {
                throw new ModelerException("rmimodeler.must.throw.remoteexception", new Object[]{endpointClass.getName(), method.getName()});
            }
            port.addOperation(this.processMethod(interfaceInfo, endpointClass, method, namespace));
        }
        port.setClientHandlerChainInfo(interfaceInfo.getClientHandlerChainInfo());
        port.setServerHandlerChainInfo(interfaceInfo.getServerHandlerChainInfo());
        String stubClassName = this.env.getNames().stubFor(port, null);
        String tieClassName = this.env.getNames().tieFor(port, this.env.getNames().getSerializerNameInfix());
        port.setProperty("com.sun.xml.rpc.processor.model.StubClassName", stubClassName);
        port.setProperty("com.sun.xml.rpc.processor.model.TieClassName", tieClassName);
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortName", this.getWSDLPortName(portName));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName", this.getWSDLPortTypeName(portName));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLBindingName", this.getWSDLBindingName(portName));
        this.messageMap = null;
        return port;
    }

    private Iterator sortMethods(Class endpointClass, Method[] methods) {
        if (VersionUtil.isVersion101(this.options.getProperty("sourceVersion"))) {
            return Arrays.asList(methods).iterator();
        }
        TreeSet<Method> sortedMethods = new TreeSet<Method>(new MethodComparator());
        HashSet<String> methodSigs = new HashSet<String>();
        for (int i = 0; i < methods.length; ++i) {
            String sig = RmiModeler.getMethodSig(methods[i]);
            if (methodSigs.contains(sig)) continue;
            sortedMethods.add(methods[i]);
            methodSigs.add(sig);
        }
        return sortedMethods.iterator();
    }

    private boolean verifyRemoteMethod(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        boolean hasRemoteException = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (!RemoteException.class.isAssignableFrom(exceptions[i])) continue;
            return true;
        }
        return false;
    }

    private Operation processMethod(RmiInterfaceInfo interfaceInfo, Class endpointClass, Method method, String namespaceURI) {
        if (this.useDocLiteral) {
            return this.processDocumentLiteralMethod(interfaceInfo, endpointClass, method, namespaceURI);
        }
        if (this.useWSIBasicProfile || this.useRPCLiteral) {
            return this.processRpcLiteralMethod(interfaceInfo, endpointClass, method, namespaceURI);
        }
        return this.processRpcEncodedMethod(interfaceInfo, endpointClass, method, namespaceURI);
    }

    private Operation processRpcEncodedMethod(RmiInterfaceInfo interfaceInfo, Class endpointClass, Method method, String namespaceURI) {
        int i;
        ExceptionModelerBase exceptionModeler;
        String portName = ClassNameInfo.getName(endpointClass.getName());
        portName = portName.replace('$', '_');
        RmiType returnType = RmiType.getRmiType(method.getReturnType());
        RmiType[] paramTypes = this.getParameterTypes(method);
        String[] paramNames = this.nameParameters(paramTypes);
        Class<?>[] exceptions = method.getExceptionTypes();
        String messageName = method.getName();
        String operationName = this.getOperationName(messageName);
        String methodName = method.getName().toString();
        this.log("creating operation: " + methodName);
        Operation operation = new Operation(new QName(operationName));
        operation.setSOAPAction(this.getSOAPAction(interfaceInfo, operationName));
        JavaMethod javaMethod = new JavaMethod(methodName);
        javaMethod.setDeclaringClass(method.getDeclaringClass().getName());
        operation.setJavaMethod(javaMethod);
        String packageName = endpointClass.getPackage().getName();
        String typeNamespace = this.getNamespaceURI(packageName);
        SOAPVersion soapVersion = interfaceInfo.getSOAPVersion();
        RmiTypeModeler rmiTypeModeler = soapVersion == SOAPVersion.SOAP_11 ? this.rmiTypeModeler_11 : this.rmiTypeModeler_12;
        ExceptionModelerBase exceptionModelerBase = exceptionModeler = soapVersion == SOAPVersion.SOAP_11 ? this.exceptionModeler_11 : this.exceptionModeler_12;
        if (typeNamespace == null) {
            typeNamespace = this.typeUri;
        }
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        operation.setStyle(SOAPStyle.RPC);
        operation.setUse(SOAPUse.ENCODED);
        SOAPStructureMember member = null;
        JavaStructureMember javaMember = null;
        JavaStructureType javaRespStructure = null;
        RPCResponseStructureType responseStruct = null;
        JavaParameter javaParameter = null;
        Block responseBlock = null;
        Response response = null;
        boolean hasHolders = false;
        for (int i2 = 0; i2 < paramTypes.length && !hasHolders; ++i2) {
            hasHolders = RmiTypeModeler.getHolderValueType(this.env, this.defHolder, paramTypes[i2]) != null;
        }
        if (!this.generateOneWayOperations || returnType.getTypeCode() != 11 || hasHolders || exceptions.length > 1) {
            responseStruct = new RPCResponseStructureType(new QName(typeNamespace, this.env.getNames().getResponseName(operationName)), soapVersion);
            javaRespStructure = new JavaStructureType(this.getStructName(packageName + portName + "_" + methodName + "_ResponseStruct"), false, responseStruct);
            responseStruct.setJavaType(javaRespStructure);
            response = new Response();
            responseBlock = new Block(new QName(namespaceURI, this.env.getNames().getResponseName(operationName)));
            SOAPType resultType = rmiTypeModeler.modelTypeSOAP(this.typeUri, returnType);
            if (returnType.getTypeCode() != 11) {
                member = soapVersion.equals(SOAPVersion.SOAP_12) ? new SOAPStructureMember(new QName(namespaceURI, "result"), resultType) : new SOAPStructureMember(new QName(null, "result"), resultType);
                javaMember = new JavaStructureMember(member.getName().getLocalPart(), member.getType().getJavaType(), member, false);
                this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
                member.setJavaStructureMember(javaMember);
                javaRespStructure.add(javaMember);
                responseStruct.add(member);
            }
            response.addBodyBlock(responseBlock);
            Parameter resultParam = new Parameter("result");
            resultParam.setEmbedded(true);
            resultParam.setType(resultType);
            resultParam.setBlock(responseBlock);
            responseBlock.setType(responseStruct);
            javaParameter = new JavaParameter(null, resultType.getJavaType(), resultParam);
            javaMethod.setReturnType(resultType.getJavaType());
            resultParam.setJavaParameter(javaParameter);
            response.addParameter(resultParam);
            response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLOutputMessageName(portName + "_" + operationName));
            operation.setResponse(response);
        } else {
            javaMethod.setReturnType(rmiTypeModeler.modelTypeSOAP(this.typeUri, returnType).getJavaType());
        }
        RPCRequestOrderedStructureType paramStruct = new RPCRequestOrderedStructureType(new QName(typeNamespace, operationName), soapVersion);
        JavaStructureType javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + paramStruct.getName().getLocalPart() + "_RequestStruct"), false, paramStruct);
        paramStruct.setJavaType(javaStruct);
        Request request = new Request();
        JavaStructureType javaStructure = (JavaStructureType)paramStruct.getJavaType();
        Block block = new Block(new QName(namespaceURI, operationName));
        for (i = 0; i < paramTypes.length; ++i) {
            QName typeName = new QName(null, paramNames[i]);
            SOAPType memberType = rmiTypeModeler.modelTypeSOAP(this.typeUri, paramTypes[i]);
            boolean isHolder = RmiTypeModeler.getHolderValueType(this.env, this.defHolder, paramTypes[i]) != null;
            member = new SOAPStructureMember(typeName, memberType);
            javaMember = new JavaStructureMember(member.getName().getLocalPart(), member.getType().getJavaType(), member, false);
            this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
            member.setJavaStructureMember(javaMember);
            javaStructure.add(javaMember);
            paramStruct.add(member);
            Parameter parameter = new Parameter(paramNames[i]);
            if (isHolder) {
                javaRespStructure.add(javaMember);
                responseStruct.add(member);
                Parameter responseParam = new Parameter(paramNames[i]);
                responseParam.setEmbedded(true);
                javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), responseParam, true);
                javaParameter.setHolderName(paramTypes[i].toString());
                responseParam.setJavaParameter(javaParameter);
                responseParam.setType(member.getType());
                responseParam.setBlock(responseBlock);
                parameter.setLinkedParameter(responseParam);
                responseParam.setLinkedParameter(parameter);
                response.addParameter(responseParam);
            }
            parameter.setEmbedded(true);
            javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), parameter, isHolder);
            if (isHolder) {
                javaParameter.setHolderName(paramTypes[i].toString());
            }
            parameter.setJavaParameter(javaParameter);
            parameter.setType(member.getType());
            parameter.setBlock(block);
            javaMethod.addParameter(javaParameter);
            request.addParameter(parameter);
        }
        block.setType(paramStruct);
        request.addBodyBlock(block);
        request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLInputMessageName(portName + "_" + operationName));
        operation.setRequest(request);
        if (exceptions.length > 0) {
            for (i = 0; i < exceptions.length; ++i) {
                if (this.isRemoteException(this.env, exceptions[i].getName().toString())) continue;
                javaMethod.addException(exceptions[i].getName().toString());
                if (exceptions[i].getName().toString().equals(EXCEPTION_CLASSNAME)) continue;
                Fault fault = exceptionModeler.modelException(this.typeUri, this.wsdlUri, exceptions[i]);
                fault.setElementName(fault.getBlock().getName());
                response.addFaultBlock(fault.getBlock());
                fault.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLFaultMessageName(fault.getName()));
                operation.addFault(fault);
                this.addFaultParent(fault, exceptionModeler);
            }
        }
        return operation;
    }

    private Operation processDocumentLiteralMethod(RmiInterfaceInfo interfaceInfo, Class endpointClass, Method method, String namespaceURI) {
        JavaParameter javaParameter;
        JavaStructureMember javaMember;
        LiteralElementMember member;
        String portName = ClassNameInfo.getName(endpointClass.getName());
        portName = portName.replace('$', '_');
        RmiType returnType = RmiType.getRmiType(method.getReturnType());
        RmiType[] paramTypes = this.getParameterTypes(method);
        String[] paramNames = this.nameParameters(paramTypes);
        Class<?>[] exceptions = method.getExceptionTypes();
        String messageName = method.getName();
        String operationName = this.getOperationName(messageName);
        String methodName = method.getName().toString();
        this.log("creating operation: " + methodName);
        Operation operation = new Operation(new QName(namespaceURI, operationName));
        operation.setSOAPAction(this.getSOAPAction(interfaceInfo, operationName));
        JavaMethod javaMethod = new JavaMethod(methodName);
        javaMethod.setDeclaringClass(method.getDeclaringClass().getName());
        operation.setJavaMethod(javaMethod);
        String packageName = endpointClass.getPackage().getName();
        String typeNamespace = this.getNamespaceURI(packageName);
        if (typeNamespace == null) {
            typeNamespace = this.typeUri;
        }
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        SOAPVersion soapVersion = interfaceInfo.getSOAPVersion();
        operation.setStyle(SOAPStyle.DOCUMENT);
        operation.setUse(SOAPUse.LITERAL);
        boolean ver111Above = VersionUtil.compare(this.sourceVersion, "1.1.1") >= 0;
        LiteralSequenceType paramStruct = new LiteralSequenceType();
        if (ver111Above) {
            paramStruct.setUnwrapped(true);
        }
        paramStruct.setName(new QName(typeNamespace, operationName));
        JavaStructureType javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + paramStruct.getName().getLocalPart() + "_RequestStruct"), false, paramStruct);
        paramStruct.setJavaType(javaStruct);
        Request request = new Request();
        Block block = new Block(new QName(typeNamespace, paramStruct.getName().getLocalPart()));
        for (int i = 0; i < paramTypes.length; ++i) {
            QName elemName = new QName(paramNames[i]);
            member = this.literalTypeModeler.modelTypeLiteral(elemName, this.typeUri, paramTypes[i]);
            javaMember = member.getJavaStructureMember();
            javaMember.setName(paramNames[i]);
            this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
            javaStruct.add(javaMember);
            paramStruct.add(member);
            Parameter parameter = new Parameter(paramNames[i]);
            parameter.setEmbedded(true);
            javaParameter = new JavaParameter(paramNames[i], member.getJavaStructureMember().getType(), parameter, false);
            parameter.setJavaParameter(javaParameter);
            parameter.setType(member.getType());
            parameter.setBlock(block);
            parameter.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", parameter.getName());
            javaMethod.addParameter(javaParameter);
            request.addParameter(parameter);
        }
        block.setType(paramStruct);
        request.addBodyBlock(block);
        request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLInputMessageName(portName + "_" + operationName));
        operation.setRequest(request);
        QName elemName = new QName("result");
        member = this.literalTypeModeler.modelTypeLiteral(elemName, this.typeUri, returnType);
        Response response = null;
        boolean genResponsePart = true;
        if (this.generateOneWayOperations && returnType.getTypeCode() == 11 && exceptions.length <= 1) {
            genResponsePart = false;
        }
        if (genResponsePart) {
            LiteralSequenceType responseStruct = new LiteralSequenceType();
            responseStruct.setName(new QName(typeNamespace, this.env.getNames().getResponseName(operationName)));
            javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + methodName + "_ResponseStruct"), false, responseStruct);
            responseStruct.setJavaType(javaStruct);
            response = new Response();
            block = new Block(new QName(typeNamespace, responseStruct.getName().getLocalPart()));
            if (returnType.getTypeCode() != 11) {
                javaMember = member.getJavaStructureMember();
                javaMember.setName("result");
                javaStruct.add(javaMember);
                responseStruct.add(member);
                Parameter resultParam = new Parameter("result");
                resultParam.setEmbedded(true);
                resultParam.setType(responseStruct);
                resultParam.setBlock(block);
                block.setType(responseStruct);
                response.addBodyBlock(block);
                javaParameter = new JavaParameter(null, block.getType().getJavaType(), resultParam);
                resultParam.setJavaParameter(javaParameter);
                resultParam.setProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName", resultParam.getName());
                response.addParameter(resultParam);
            } else if (ver111Above) {
                block.setType(responseStruct);
                response.addBodyBlock(block);
            }
            response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLOutputMessageName(portName + "_" + operationName));
            operation.setResponse(response);
        }
        javaMethod.setReturnType(member.getJavaStructureMember().getType());
        if (exceptions.length > 0) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (this.isRemoteException(this.env, exceptions[i].getName().toString())) continue;
                javaMethod.addException(exceptions[i].getName().toString());
                if (exceptions[i].getName().toString().equals(EXCEPTION_CLASSNAME)) continue;
                Fault fault = this.literalExceptionModeler.modelException(this.typeUri, this.wsdlUri, exceptions[i]);
                fault.setElementName(new QName(fault.getBlock().getType().getName().getNamespaceURI(), fault.getBlock().getType().getName().getLocalPart()));
                if (response == null) {
                    response = new Response();
                    operation.setResponse(response);
                }
                response.addFaultBlock(fault.getBlock());
                fault.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLFaultMessageName(fault.getName()));
                operation.addFault(fault);
                this.addFaultParent(fault, this.literalExceptionModeler);
            }
        }
        return operation;
    }

    private Operation processRpcLiteralMethod(RmiInterfaceInfo interfaceInfo, Class endpointClass, Method method, String namespaceURI) {
        int i;
        JavaParameter javaParameter;
        String portName = ClassNameInfo.getName(endpointClass.getName());
        portName = portName.replace('$', '_');
        RmiType returnType = RmiType.getRmiType(method.getReturnType());
        RmiType[] paramTypes = this.getParameterTypes(method);
        String[] paramNames = this.nameParameters(paramTypes);
        Class<?>[] exceptions = method.getExceptionTypes();
        String messageName = method.getName();
        String operationName = this.getOperationName(messageName);
        String methodName = method.getName().toString();
        this.log("creating operation: " + methodName);
        Operation operation = new Operation(new QName(namespaceURI, operationName));
        operation.setSOAPAction(this.getSOAPAction(interfaceInfo, operationName));
        JavaMethod javaMethod = new JavaMethod(methodName);
        javaMethod.setDeclaringClass(method.getDeclaringClass().getName());
        operation.setJavaMethod(javaMethod);
        String packageName = endpointClass.getPackage().getName();
        String typeNamespace = this.getNamespaceURI(packageName);
        if (typeNamespace == null) {
            typeNamespace = this.typeUri;
        }
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        SOAPVersion soapVersion = interfaceInfo.getSOAPVersion();
        operation.setStyle(SOAPStyle.RPC);
        operation.setUse(SOAPUse.LITERAL);
        JavaStructureMember javaMember = null;
        JavaStructureType javaRespStructure = null;
        Block responseBlock = null;
        String elemNamespaceURI = null;
        if (soapVersion.equals(SOAPVersion.SOAP_12)) {
            elemNamespaceURI = typeNamespace;
        }
        QName elemName = new QName(elemNamespaceURI, "result");
        LiteralElementMember member = this.literalTypeModeler.modelTypeLiteral(elemName, this.typeUri, returnType, true, true);
        member.setRequired(true);
        Response response = null;
        boolean hasHolders = false;
        for (int i2 = 0; i2 < paramTypes.length && !hasHolders; ++i2) {
            hasHolders = LiteralTypeModeler.getHolderValueType(this.env, this.defHolder, paramTypes[i2]) != null;
        }
        LiteralSequenceType responseStruct = null;
        if (!this.generateOneWayOperations || returnType.getTypeCode() != 11 || hasHolders || exceptions.length > 1) {
            responseStruct = new LiteralSequenceType();
            responseStruct.setName(new QName(elemNamespaceURI, this.env.getNames().getResponseName(operationName)));
            responseStruct.setRpcWrapper(true);
            javaRespStructure = new JavaStructureType(this.getStructName(packageName + portName + "_" + methodName + "_ResponseStruct"), false, responseStruct);
            responseStruct.setJavaType(javaRespStructure);
            response = new Response();
            responseBlock = new Block(new QName(namespaceURI, this.env.getNames().getResponseName(operationName)));
            javaMember = member.getJavaStructureMember();
            javaMember.setName("result");
            if (returnType.getTypeCode() != 11) {
                javaRespStructure.add(javaMember);
                responseStruct.add(member);
            }
            Parameter resultParam = new Parameter("result");
            response.addBodyBlock(responseBlock);
            resultParam.setEmbedded(true);
            resultParam.setType(member.getType());
            resultParam.setBlock(responseBlock);
            responseBlock.setType(responseStruct);
            javaParameter = new JavaParameter(null, responseStruct.getJavaType(), resultParam);
            javaMethod.setReturnType(javaMember.getType());
            resultParam.setJavaParameter(javaParameter);
            response.addParameter(resultParam);
            response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLOutputMessageName(portName + "_" + operationName));
            operation.setResponse(response);
        } else {
            javaMethod.setReturnType(member.getJavaStructureMember().getType());
        }
        LiteralSequenceType paramStruct = new LiteralSequenceType();
        paramStruct.setName(new QName(typeNamespace, operationName));
        paramStruct.setRpcWrapper(true);
        JavaStructureType javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + paramStruct.getName().getLocalPart() + "_RequestStruct"), false, paramStruct);
        paramStruct.setJavaType(javaStruct);
        Request request = new Request();
        Block requestBlock = new Block(new QName(namespaceURI, paramStruct.getName().getLocalPart()));
        for (i = 0; i < paramTypes.length; ++i) {
            elemName = new QName(paramNames[i]);
            member = this.literalTypeModeler.modelTypeLiteral(elemName, this.typeUri, paramTypes[i], true, true);
            member.setRequired(true);
            boolean isHolder = LiteralTypeModeler.getHolderValueType(this.env, this.defHolder, paramTypes[i]) != null;
            javaMember = member.getJavaStructureMember();
            Parameter parameter = new Parameter(paramNames[i]);
            if (isHolder) {
                javaRespStructure.add(javaMember);
                responseStruct.add(member);
                Parameter responseParam = new Parameter(paramNames[i]);
                responseParam.setEmbedded(true);
                javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), responseParam, true);
                javaParameter.setHolderName(paramTypes[i].toString());
                responseParam.setJavaParameter(javaParameter);
                responseParam.setType(member.getType());
                responseParam.setBlock(responseBlock);
                parameter.setLinkedParameter(responseParam);
                responseParam.setLinkedParameter(parameter);
                response.addParameter(responseParam);
            }
            parameter.setEmbedded(true);
            javaStruct.add(javaMember);
            paramStruct.add(member);
            javaParameter = new JavaParameter(paramNames[i], member.getJavaStructureMember().getType(), parameter, isHolder);
            if (isHolder) {
                javaParameter.setHolderName(paramTypes[i].toString());
            }
            parameter.setJavaParameter(javaParameter);
            parameter.setType(member.getType());
            parameter.setBlock(requestBlock);
            javaMethod.addParameter(javaParameter);
            request.addParameter(parameter);
        }
        requestBlock.setType(paramStruct);
        request.addBodyBlock(requestBlock);
        request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLInputMessageName(portName + "_" + operationName));
        operation.setRequest(request);
        if (exceptions.length > 0) {
            for (i = 0; i < exceptions.length; ++i) {
                if (this.isRemoteException(this.env, exceptions[i].getName().toString())) continue;
                javaMethod.addException(exceptions[i].getName().toString());
                if (exceptions[i].getName().toString().equals(EXCEPTION_CLASSNAME)) continue;
                Fault fault = this.literalExceptionModeler.modelException(this.typeUri, this.wsdlUri, exceptions[i]);
                fault.setElementName(new QName(fault.getBlock().getType().getName().getNamespaceURI(), fault.getBlock().getType().getName().getLocalPart()));
                if (response == null) {
                    response = new Response();
                    operation.setResponse(response);
                }
                response.addFaultBlock(fault.getBlock());
                fault.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLFaultMessageName(fault.getName()));
                operation.addFault(fault);
                this.addFaultParent(fault, this.literalExceptionModeler);
            }
        }
        return operation;
    }

    private RmiType[] getParameterTypes(Method method) {
        Class<?>[] args = method.getParameterTypes();
        RmiType[] types = new RmiType[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = RmiType.getRmiType(args[i]);
        }
        return types;
    }

    private String getStructName(String name) {
        String tmp = name.toLowerCase();
        Integer count = (Integer)this.structMap.get(tmp);
        if (count != null) {
            count = new Integer(count + 1);
            name = name + count;
        } else {
            count = new Integer(0);
        }
        this.structMap.put(tmp, count);
        return name;
    }

    public boolean isRemoteException(ProcessorEnvironment env, String exceptionName) {
        try {
            Class exceptionClass = RmiUtils.getClassForName(exceptionName, env.getClassLoader());
            return this.remoteExceptionClass.isAssignableFrom(exceptionClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", exceptionName);
        }
    }

    private String[] nameParameters(RmiType[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.generateNameFromType(types[i], this.env) + "_" + (i + 1);
        }
        return names;
    }

    public String generateNameFromType(RmiType type, ProcessorEnvironment env) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf" + this.generateNameFromType(type.getElementType(), env);
            }
            case 10: {
                RmiType holderValueType = RmiTypeModeler.getHolderValueType(env, this.defHolder, type);
                if (holderValueType != null) {
                    return this.generateNameFromType(holderValueType, env);
                }
                String tmp = ClassNameInfo.getName(type.getClassName());
                return ClassNameInfo.replaceInnerClassSym(tmp);
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    public String getSOAPAction(RmiInterfaceInfo interfaceInfo, String operationName) {
        if (interfaceInfo.getSOAPAction() != null) {
            return interfaceInfo.getSOAPAction();
        }
        if (interfaceInfo.getSOAPActionBase() != null) {
            return interfaceInfo.getSOAPActionBase() + operationName;
        }
        return "";
    }

    public String getOperationName(String messageName) {
        String operationName = null;
        Integer cnt = (Integer)this.messageMap.get(messageName);
        if (cnt == null) {
            cnt = new Integer(0);
            operationName = messageName;
        }
        this.messageMap.put(messageName, new Integer(cnt + 1));
        if (operationName == null) {
            operationName = messageName + (cnt + 1);
        }
        return operationName;
    }

    public String getNamespaceURI(String javaPackageName) {
        NamespaceMappingInfo i;
        if (this.namespaceMappingRegistry != null && (i = this.namespaceMappingRegistry.getNamespaceMappingInfo(javaPackageName)) != null) {
            return i.getNamespaceURI();
        }
        return null;
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + msg + "]");
        }
    }

    private QName getWSDLPortName(String portName) {
        return new QName(this.wsdlUri, portName + "Port");
    }

    private QName getWSDLBindingName(String portName) {
        return new QName(this.wsdlUri, portName + "Binding");
    }

    private QName getWSDLPortTypeName(String portName) {
        return new QName(this.wsdlUri, portName);
    }

    private QName getWSDLInputMessageName(String operationName) {
        return new QName(this.wsdlUri, operationName);
    }

    private QName getWSDLOutputMessageName(String operationName) {
        return new QName(this.wsdlUri, operationName + "Response");
    }

    private QName getWSDLFaultMessageName(String faultName) {
        return new QName(this.wsdlUri, faultName);
    }

    public static String getMethodSig(Method method) {
        String sig = method.getName() + "(";
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sig = sig + ", ";
            }
            sig = sig + params[i].getName();
        }
        return sig + ")";
    }

    static {
        excludedInterfaces.add(SERIALIZABLE_CLASSNAME);
        excludedInterfaces.add(HOLDER_CLASSNAME);
        excludedInterfaces.add(REMOTE_CLASSNAME);
    }

    public static class MethodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method method1 = (Method)o1;
            Method method2 = (Method)o2;
            return this.sort(method1, method2);
        }

        protected int sort(Method method1, Method method2) {
            Class<?> class2;
            String sig1 = RmiModeler.getMethodSig(method1);
            String sig2 = RmiModeler.getMethodSig(method2);
            Class<?> class1 = method1.getDeclaringClass();
            if (class1.equals(class2 = method2.getDeclaringClass())) {
                return sig1.compareTo(sig2);
            }
            if (class1.isAssignableFrom(class2)) {
                return -1;
            }
            return 1;
        }
    }
}

