/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.deployment;

import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.webservices.WebServiceDeploymentNotifier;
import org.glassfish.webservices.deployment.DeployedEndpointData;

@AMXMetadata(type="web-service-mon", group="monitoring")
@ManagedObject
@Description(value="Deployed Web Services")
public class WebServicesDeploymentMBean {
    private final Map<String, Application> applications = new HashMap<String, Application>();

    public synchronized void deploy(@ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        com.sun.enterprise.deployment.Application app = endpoint.getBundleDescriptor().getApplication();
        String appName = app.getAppName();
        String moduleName = endpoint.getBundleDescriptor().getModuleName();
        String endpointName = endpoint.getEndpointName();
        String path = endpoint.getEndpointAddressPath();
        DeployedEndpointData data = new DeployedEndpointData(path, app, endpoint);
        Application application = this.applications.get(appName);
        if (application == null) {
            application = new Application(appName);
            this.applications.put(appName, application);
        }
        application.addEndpoint(moduleName, endpointName, data);
    }

    public synchronized void undeploy(@ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        com.sun.enterprise.deployment.Application app = endpoint.getBundleDescriptor().getApplication();
        String appName = app.getAppName();
        String moduleName = endpoint.getBundleDescriptor().getModuleName();
        String endpointName = endpoint.getEndpointName();
        Application application = this.applications.get(appName);
        if (application != null) {
            application.removeEndpoint(moduleName, endpointName);
            if (application.isEmpty()) {
                this.applications.remove(appName);
            }
        }
    }

    public synchronized void deploy(WebServicesDescriptor wsDesc, WebServiceDeploymentNotifier notifier) {
        for (WebService svc : wsDesc.getWebServices()) {
            for (WebServiceEndpoint endpoint : svc.getEndpoints()) {
                this.deploy(endpoint);
                notifier.notifyDeployed(endpoint);
            }
        }
    }

    public synchronized void undeploy(String appName) {
        this.applications.remove(appName);
    }

    public synchronized Map<String, Map<String, Map<String, DeployedEndpointData>>> getEndpoints() {
        if (this.applications.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = new HashMap<String, Map<String, Map<String, DeployedEndpointData>>>();
        for (Map.Entry<String, Application> e : this.applications.entrySet()) {
            endpoints.put(e.getKey(), e.getValue().getDeployedEndpointData());
        }
        return endpoints;
    }

    public synchronized Map<String, Map<String, Map<String, DeployedEndpointData>>> getEndpoints(String appName) {
        Application app = this.applications.get(appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = new HashMap<String, Map<String, Map<String, DeployedEndpointData>>>();
        endpoints.put(appName, app.getDeployedEndpointData());
        return endpoints;
    }

    public synchronized Map<String, Map<String, Map<String, DeployedEndpointData>>> getEndpoints(String appName, String moduleName) {
        Application app = this.applications.get(appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = new HashMap<String, Map<String, Map<String, DeployedEndpointData>>>();
        endpoints.put(appName, app.getDeployedEndpointData(moduleName));
        return endpoints;
    }

    public synchronized Map<String, Map<String, Map<String, DeployedEndpointData>>> getEndpoint(String appName, String moduleName, String endpointName) {
        Application app = this.applications.get(appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, DeployedEndpointData>>> endpoints = new HashMap<String, Map<String, Map<String, DeployedEndpointData>>>();
        endpoints.put(appName, app.getDeployedEndpointData(moduleName, endpointName));
        return endpoints;
    }

    @ManagedOperation
    public synchronized Map<String, String> getServlet109Endpoint(String appName, String moduleName, String servletLink) {
        return Collections.emptyMap();
    }

    @ManagedOperation
    public synchronized Map<String, String> getEjb109Endpoint(String appName, String moduleName, String ejbLink) {
        return Collections.emptyMap();
    }

    private static class Endpoint {
        final String appName;
        final String moduleName;
        final String endpointName;
        final DeployedEndpointData endpointData;

        Endpoint(String appName, String moduleName, String endpointName, DeployedEndpointData endpointData) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.endpointName = endpointName;
            this.endpointData = endpointData;
        }

        DeployedEndpointData getDeployedEndpointData() {
            return this.endpointData;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Endpoint) {
                Endpoint other = (Endpoint)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.endpointName.equals(other.endpointName)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode() + this.endpointName.hashCode();
        }

        public String toString() {
            return this.appName + "#" + this.moduleName + "#" + this.endpointName;
        }
    }

    private static class Module {
        final String moduleName;
        final Map<String, Endpoint> endpoints;
        final String appName;

        Module(String appName, String moduleName) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.endpoints = new HashMap<String, Endpoint>();
        }

        Map<String, DeployedEndpointData> getDeployedEndpointData() {
            HashMap<String, DeployedEndpointData> tempEndpoints = new HashMap<String, DeployedEndpointData>();
            for (Map.Entry<String, Endpoint> e : this.endpoints.entrySet()) {
                tempEndpoints.put(e.getKey(), e.getValue().getDeployedEndpointData());
            }
            return tempEndpoints;
        }

        Map<String, DeployedEndpointData> getDeployedEndpointData(String endpointName) {
            Endpoint endpoint = this.endpoints.get(endpointName);
            if (endpoint == null) {
                return Collections.emptyMap();
            }
            HashMap<String, DeployedEndpointData> tempEndpoints = new HashMap<String, DeployedEndpointData>();
            tempEndpoints.put(endpointName, endpoint.getDeployedEndpointData());
            return tempEndpoints;
        }

        void addEndpoint(String endpointName, DeployedEndpointData endpointData) {
            Endpoint endpoint = this.endpoints.get(endpointName);
            if (endpoint == null) {
                endpoint = new Endpoint(this.appName, this.moduleName, endpointName, endpointData);
                this.endpoints.put(endpointName, endpoint);
            }
        }

        void removeEndpoint(String endpointName) {
            this.endpoints.remove(endpointName);
        }

        boolean isEmpty() {
            return this.endpoints.isEmpty();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Module) {
                Module other = (Module)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode();
        }

        public String toString() {
            return this.appName + "#" + this.moduleName;
        }
    }

    private static class Application {
        final String appName;
        final Map<String, Module> modules;

        Application(String appName) {
            this.appName = appName;
            this.modules = new HashMap<String, Module>();
        }

        Map<String, Map<String, DeployedEndpointData>> getDeployedEndpointData() {
            HashMap<String, Map<String, DeployedEndpointData>> tempEndpoints = new HashMap<String, Map<String, DeployedEndpointData>>();
            for (Map.Entry<String, Module> e : this.modules.entrySet()) {
                tempEndpoints.put(e.getKey(), e.getValue().getDeployedEndpointData());
            }
            return tempEndpoints;
        }

        Map<String, Map<String, DeployedEndpointData>> getDeployedEndpointData(String moduleName) {
            Module module = this.modules.get(moduleName);
            if (module == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Map<String, DeployedEndpointData>> tempEndpoints = new HashMap<String, Map<String, DeployedEndpointData>>();
            tempEndpoints.put(moduleName, module.getDeployedEndpointData());
            return tempEndpoints;
        }

        Map<String, Map<String, DeployedEndpointData>> getDeployedEndpointData(String moduleName, String endpointName) {
            Module module = this.modules.get(moduleName);
            if (module == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Map<String, DeployedEndpointData>> tempEndpoints = new HashMap<String, Map<String, DeployedEndpointData>>();
            tempEndpoints.put(moduleName, module.getDeployedEndpointData(endpointName));
            return tempEndpoints;
        }

        void addEndpoint(String moduleName, String endpointName, DeployedEndpointData endpointData) {
            Module module = this.modules.get(moduleName);
            if (module == null) {
                module = new Module(this.appName, moduleName);
                this.modules.put(moduleName, module);
            }
            module.addEndpoint(endpointName, endpointData);
        }

        void removeEndpoint(String moduleName, String endpointName) {
            Module module = this.modules.get(moduleName);
            if (module != null) {
                module.removeEndpoint(endpointName);
                if (module.isEmpty()) {
                    this.modules.remove(moduleName);
                }
            }
        }

        boolean isEmpty() {
            return this.modules.isEmpty();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Application) {
                Application other = (Application)obj;
                if (this.appName.equals(other.appName)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode();
        }

        public String toString() {
            return this.appName;
        }
    }
}

