/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecordImpl;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public class SAXUnmarshallerHandler
implements ExtendedContentHandler {
    private XMLReader xmlReader;
    private Context xmlContext;
    private UnmarshalRecord rootRecord;
    private Object object;
    private Descriptor descriptor;
    private boolean shouldWrap;
    private Unmarshaller unmarshaller;
    private CoreAbstractSession session;
    private UnmarshalNamespaceResolver unmarshalNamespaceResolver;
    private UnmarshalKeepAsElementPolicy keepAsElementPolicy = new UnmarshalKeepAsElementPolicy(){

        @Override
        public boolean isKeepAllAsElement() {
            return false;
        }

        @Override
        public boolean isKeepNoneAsElement() {
            return true;
        }

        @Override
        public boolean isKeepUnknownAsElement() {
            return false;
        }
    };
    private SAXDocumentBuilder documentBuilder;
    private Locator2 locator;
    private boolean isNil;

    public SAXUnmarshallerHandler(Context xmlContext) {
        this.xmlContext = xmlContext;
        this.shouldWrap = true;
        this.unmarshalNamespaceResolver = new StackUnmarshalNamespaceResolver();
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public Object getObject() {
        if (this.object == null) {
            if (this.descriptor != null) {
                this.object = this.unmarshaller.isResultAlwaysXMLRoot() || this.descriptor.isResultAlwaysXMLRoot() || this.shouldWrap ? this.descriptor.wrapObjectInXMLRoot(this.rootRecord, this.unmarshaller.isResultAlwaysXMLRoot() || this.descriptor.isResultAlwaysXMLRoot()) : this.rootRecord.getCurrentObject();
            } else if (this.documentBuilder != null) {
                Element node = this.documentBuilder.getDocument().getDocumentElement();
                Object root = this.unmarshaller.createRoot();
                ((Root)root).setLocalName(node.getLocalName());
                ((Root)root).setNamespaceURI(node.getNamespaceURI());
                ((Root)root).setObject(node);
                this.object = root;
            } else if (this.rootRecord != null) {
                this.object = this.rootRecord.getCurrentObject();
            }
        }
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            this.locator = (Locator2)locator;
            if (this.xmlReader != null) {
                this.xmlReader.setLocator(locator);
            }
        }
    }

    public UnmarshalNamespaceResolver getUnmarshalNamespaceResolver() {
        return this.unmarshalNamespaceResolver;
    }

    public void setUnmarshalNamespaceResolver(UnmarshalNamespaceResolver unmarshalNamespaceResolver) {
        this.unmarshalNamespaceResolver = unmarshalNamespaceResolver;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.unmarshalNamespaceResolver.push(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.unmarshalNamespaceResolver.pop(prefix);
    }

    public void resolveReferences() {
        if (this.rootRecord != null) {
            this.rootRecord.resolveReferences(this.session, this.unmarshaller.getIDResolver());
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            Object obj;
            String name = localName == null || localName.length() == 0 ? qName : localName;
            XPathQName rootQName = namespaceURI == null || namespaceURI.length() == 0 ? new XPathQName(name, this.xmlReader.isNamespaceAware()) : new XPathQName(namespaceURI, name, this.xmlReader.isNamespaceAware());
            Class<?> primitiveWrapperClass = null;
            Object xmlDescriptor = this.xmlContext.getDescriptor(rootQName);
            if (xmlDescriptor == null || this.unmarshaller.getMediaType() == MediaType.APPLICATION_JSON && this.unmarshaller.getJsonTypeConfiguration().getJsonTypeAttributeName() != null && !"type".equals(this.unmarshaller.getJsonTypeConfiguration().getJsonTypeAttributeName())) {
                boolean isPrimitiveType = false;
                String type = null;
                if (this.xmlReader.isNamespaceAware()) {
                    type = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                } else if (this.unmarshaller.getMediaType() != MediaType.APPLICATION_JSON || this.unmarshaller.getJsonTypeConfiguration().useJsonTypeCompatibility()) {
                    type = atts.getValue("", "type");
                } else if (this.unmarshaller.getMediaType() == MediaType.APPLICATION_JSON && this.unmarshaller.getJsonTypeConfiguration().getJsonTypeAttributeName() != null) {
                    type = atts.getValue("", this.unmarshaller.getJsonTypeConfiguration().getJsonTypeAttributeName());
                }
                if (type != null) {
                    Object lookupDescriptor;
                    XPathFragment typeFragment = new XPathFragment(type, this.xmlReader.getNamespaceSeparator(), this.xmlReader.isNamespaceAware());
                    if (this.xmlReader.isNamespaceAware() && this.unmarshalNamespaceResolver != null) {
                        typeFragment.setNamespaceURI(this.unmarshalNamespaceResolver.getNamespaceURI(typeFragment.getPrefix()));
                    }
                    if ((lookupDescriptor = this.xmlContext.getDescriptorByGlobalType(typeFragment)) == null) {
                        QName lookupQName = null;
                        lookupQName = typeFragment.getNamespaceURI() == null ? new QName("http://www.w3.org/2001/XMLSchema", typeFragment.getLocalName()) : new QName(typeFragment.getNamespaceURI(), typeFragment.getLocalName());
                        if (this.session == null) {
                            this.session = (CoreAbstractSession)this.xmlContext.getSession();
                        }
                        ConversionManager conversionManager = (ConversionManager)this.session.getDatasourcePlatform().getConversionManager();
                        primitiveWrapperClass = conversionManager.javaType(lookupQName);
                    } else {
                        xmlDescriptor = lookupDescriptor;
                        this.session = this.xmlContext.getSession(xmlDescriptor);
                    }
                }
            } else {
                String descLocalName;
                if (xmlDescriptor.getDefaultRootElementField() != null && !this.unmarshaller.isResultAlwaysXMLRoot() && (descLocalName = xmlDescriptor.getDefaultRootElementField().getXPathFragment().getLocalName()) != null && descLocalName.equals(localName)) {
                    String descUri = xmlDescriptor.getDefaultRootElementField().getXPathFragment().getNamespaceURI();
                    if (!this.xmlReader.isNamespaceAware() || this.xmlReader.isNamespaceAware() && (namespaceURI == null && descUri == null || namespaceURI != null && namespaceURI.length() == 0 && descUri == null || namespaceURI != null && namespaceURI.equals(descUri))) {
                        this.shouldWrap = false;
                    }
                }
                if (xmlDescriptor.hasInheritance()) {
                    Object indicator;
                    QName leafElementType;
                    this.session = this.xmlContext.getSession(xmlDescriptor);
                    UnmarshalRecordImpl tmpUnmarshalRecord = new UnmarshalRecordImpl(null);
                    tmpUnmarshalRecord.setUnmarshaller(this.unmarshaller);
                    tmpUnmarshalRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
                    tmpUnmarshalRecord.setXMLReader(this.getXMLReader());
                    tmpUnmarshalRecord.setAttributes(atts);
                    Object classValue = ((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).classFromRow((org.eclipse.persistence.oxm.record.UnmarshalRecord)new org.eclipse.persistence.oxm.record.UnmarshalRecord(tmpUnmarshalRecord), (CoreAbstractSession)this.session);
                    if (classValue == null && (leafElementType = xmlDescriptor.getDefaultRootElementType()) != null && (indicator = ((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).getClassIndicatorMapping().get(leafElementType)) != null) {
                        classValue = (Class)indicator;
                    }
                    if (classValue != null) {
                        xmlDescriptor = (Descriptor)this.session.getDescriptor((Class)classValue);
                    } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                        throw DescriptorException.missingClassIndicatorField(tmpUnmarshalRecord, (ClassDescriptor)((XMLDescriptor)((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).getDescriptor()));
                    }
                }
            }
            if (xmlDescriptor == null && (obj = this.xmlReader.getCurrentObject(this.session, null)) != null) {
                xmlDescriptor = (Descriptor)this.xmlContext.getSession(obj.getClass()).getDescriptor(obj.getClass());
            }
            if (xmlDescriptor == null && primitiveWrapperClass == null) {
                UnmappedContentHandler unmappedContentHandler;
                if (!this.keepAsElementPolicy.isKeepNoneAsElement()) {
                    this.documentBuilder = new SAXDocumentBuilder();
                    this.documentBuilder.startDocument();
                    for (String prefix : this.unmarshalNamespaceResolver.getPrefixes()) {
                        this.documentBuilder.startPrefixMapping(prefix, this.unmarshalNamespaceResolver.getNamespaceURI(prefix));
                    }
                    this.documentBuilder.startElement(namespaceURI, localName, qName, atts);
                    this.xmlReader.setContentHandler(this.documentBuilder);
                    return;
                }
                Class unmappedContentHandlerClass = this.unmarshaller.getUnmappedContentHandlerClass();
                if (unmappedContentHandlerClass == null) {
                    throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
                }
                try {
                    PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                    unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
                }
                catch (ClassCastException e) {
                    throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
                }
                catch (IllegalAccessException e) {
                    throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
                }
                catch (InstantiationException e) {
                    throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
                }
                UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(unmappedContentHandler, this);
                unmappedContentHandler.startElement(namespaceURI, localName, qName, atts);
                this.xmlReader.setContentHandler(unmappedContentHandler);
                this.setObject(unmappedContentHandlerWrapper.getCurrentObject());
                return;
            }
            if (xmlDescriptor == null && primitiveWrapperClass != null) {
                this.session = this.xmlContext.getSession(null);
                this.rootRecord = this.unmarshaller.createRootUnmarshalRecord(primitiveWrapperClass);
                this.rootRecord.setSession((CoreAbstractSession)((Context)this.unmarshaller.getContext()).getSession());
            } else {
                if (this.session == null) {
                    this.session = this.xmlContext.getSession(xmlDescriptor);
                }
                this.rootRecord = this.unmarshaller.createUnmarshalRecord(xmlDescriptor, this.session);
            }
            this.descriptor = xmlDescriptor;
            this.rootRecord.setUnmarshaller(this.unmarshaller);
            this.rootRecord.setXMLReader(this.getXMLReader());
            if (this.locator != null) {
                this.rootRecord.setDocumentLocator(this.xmlReader.getLocator());
            }
            this.rootRecord.setAttributes(atts);
            boolean hasNilAttribute = atts != null && atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil") != null;
            this.rootRecord.setNil(this.isNil || hasNilAttribute);
            this.rootRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
            this.rootRecord.startDocument();
            this.rootRecord.initializeRecord(null);
            this.xmlReader.setContentHandler(this.rootRecord);
            this.xmlReader.setLexicalHandler(this.rootRecord);
            Object attributeGroup = this.unmarshaller.getUnmarshalAttributeGroup();
            if (attributeGroup != null) {
                if (attributeGroup.getClass() == CoreClassConstants.STRING) {
                    CoreAttributeGroup group = this.descriptor.getAttributeGroup((String)attributeGroup);
                    if (group != null) {
                        this.rootRecord.setUnmarshalAttributeGroup(group);
                    }
                } else if (attributeGroup instanceof CoreAttributeGroup) {
                    this.rootRecord.setUnmarshalAttributeGroup((CoreAttributeGroup)attributeGroup);
                }
            }
            this.rootRecord.startElement(namespaceURI, localName, qName, atts);
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void characters(CharSequence characters) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy policy) {
        this.keepAsElementPolicy = policy;
    }

    public UnmarshalKeepAsElementPolicy getKeepAsElementPolicy() {
        return this.keepAsElementPolicy;
    }

    @Override
    public void setNil(boolean isNil) {
        this.isNil = isNil;
    }
}

