/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.StringBuilderNewLineAppender;
import java.util.Collections;
import java.util.List;
import java.util.logging.LogManager;
import java.util.logging.LoggingMXBean;

public class LogReporter {
    private final StringManager sm = StringManager.getManager(LogReporter.class);
    private final String ROOT_LOGGER = "root";
    private final String ANON_LOGGER = "anonymous";

    public String getLoggingReport() throws RuntimeException {
        try {
            StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
            LoggingMXBean lb = LogManager.getLoggingMXBean();
            List<String> loggers = lb.getLoggerNames();
            Collections.sort(loggers);
            String lf = System.getProperty("java.util.logging.config.file");
            sb.append(this.sm.getString("logging.config.file", (Object)lf));
            sb.append(this.sm.getString("reg.loggers", (Object)loggers.size()));
            sb.append(this.sm.getString("logger.details.1"));
            sb.append(this.sm.getString("logger.details.2"));
            sb.append(this.sm.getString("list.of.loggers"));
            sb.append("--------------------------------------------------");
            for (String logger : loggers) {
                String ln = logger == null ? "anonymous" : logger;
                String parent = lb.getParentLoggerName(logger);
                if (parent == null || parent.length() == 0) {
                    parent = "root";
                }
                sb.append(ln + "|" + lb.getLoggerLevel(logger) + "|" + parent);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

