/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.ApplyRequestValuesPhase;
import com.sun.faces.lifecycle.ClientWindowFactoryImpl;
import com.sun.faces.lifecycle.InvokeApplicationPhase;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.lifecycle.ProcessValidationsPhase;
import com.sun.faces.lifecycle.RenderResponsePhase;
import com.sun.faces.lifecycle.RestoreViewPhase;
import com.sun.faces.lifecycle.UpdateModelValuesPhase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.Lifecycle;

public class LifecycleImpl
extends Lifecycle {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private Phase response = new RenderResponsePhase();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase(), this.response};
    private List<PhaseListener> listeners = new CopyOnWriteArrayList<PhaseListener>();
    private boolean isClientWindowEnabled = false;
    private WebConfiguration config;

    public LifecycleImpl() {
    }

    public LifecycleImpl(FacesContext context) {
        ExternalContext extContext = context.getExternalContext();
        this.config = WebConfiguration.getInstance(extContext);
        context.getApplication().subscribeToEvent(PostConstructApplicationEvent.class, Application.class, new PostConstructApplicationListener());
    }

    private void postConstructApplicationInitialization() {
        String optionValue = this.config.getOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode);
        this.isClientWindowEnabled = null != optionValue && !optionValue.equals(WebConfiguration.WebContextInitParameter.ClientWindowMode.getDefaultValue());
    }

    @Override
    public void attachWindow(FacesContext context) {
        if (!this.isClientWindowEnabled) {
            return;
        }
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        ExternalContext extContext = context.getExternalContext();
        ClientWindow myWindow = extContext.getClientWindow();
        if (null == myWindow && null != (myWindow = this.createClientWindow(context))) {
            myWindow.decode(context);
            extContext.setClientWindow(myWindow);
        }
    }

    private ClientWindow createClientWindow(FacesContext context) {
        ClientWindowFactory clientWindowFactory = null;
        clientWindowFactory = Util.isUnitTestModeEnabled() ? new ClientWindowFactoryImpl(false) : (ClientWindowFactory)FactoryFinder.getFactory("javax.faces.lifecycle.ClientWindowFactory");
        return clientWindowFactory.getClientWindow(context);
    }

    @Override
    public void execute(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("execute(" + context + ")");
        }
        int len = this.phases.length - 1;
        for (int i = 1; i < len && !context.getRenderResponse() && !context.getResponseComplete(); ++i) {
            this.phases[i].doPhase(context, this, this.listeners.listIterator());
        }
    }

    @Override
    public void render(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("render(" + context + ")");
        }
        if (!context.getResponseComplete()) {
            this.response.doPhase(context, this, this.listeners.listIterator());
        }
    }

    @Override
    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<PhaseListener>();
        }
        if (this.listeners.contains(listener)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.lifecycle.duplicate_phase_listener_detected", listener.getClass().getName());
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "addPhaseListener({0},{1})", new Object[]{listener.getPhaseId().toString(), listener.getClass().getName()});
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public PhaseListener[] getPhaseListeners() {
        return this.listeners.toArray(new PhaseListener[this.listeners.size()]);
    }

    @Override
    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (this.listeners.remove(listener) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "removePhaseListener({0})", new Object[]{listener.getClass().getName()});
        }
    }

    private class PostConstructApplicationListener
    implements SystemEventListener {
        private PostConstructApplicationListener() {
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof Application;
        }

        @Override
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            LifecycleImpl.this.postConstructApplicationInitialization();
        }
    }
}

