/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarHelper {
    private static final Logger logger = Logger.getLogger(JarHelper.class.getPackage().getName());

    public static void accept(JarInputStream jis, Visitor visitor) throws IOException {
        JarEntry je;
        while ((je = jis.getNextJarEntry()) != null) {
            logger.logp(Level.FINE, "JarHelper", "accept", "je = ${0}", new Object[]{je});
            visitor.visit(je);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(URLConnection con, OutputStream os, Manifest m) {
        try {
            InputStream in = con.getInputStream();
            JarInputStream jis = null;
            ZipOutputStream jos = null;
            try {
                jis = new JarInputStream(in);
                jos = new JarOutputStream(os, m);
                JarHelper.write(jis, (JarOutputStream)jos);
            }
            finally {
                try {
                    if (jos != null) {
                        jos.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void write(JarInputStream jis, JarOutputStream jos) throws IOException {
        ZipEntry ze;
        ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
        while ((ze = jis.getNextEntry()) != null) {
            logger.logp(Level.FINE, "JarHelper", "write", "ze = {0}", new Object[]{ze});
            jos.putNextEntry(ze);
            JarHelper.copy(jis, jos, byteBuffer);
            jos.closeEntry();
        }
    }

    public static InputStream makeJar(final File dir, final Runnable action) throws IOException {
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Manifest m;
                    File mf = new File(dir, "META-INF/MANIFEST.MF");
                    if (mf.exists()) {
                        FileInputStream mfis = new FileInputStream(mf);
                        try {
                            m = new Manifest(mfis);
                        }
                        finally {
                            mfis.close();
                        }
                    } else {
                        m = new Manifest();
                        m.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                    }
                    final JarOutputStream jos = new JarOutputStream((OutputStream)pos, m);
                    final ByteBuffer buf = ByteBuffer.allocate(10240);
                    final URI baseURI = dir.toURI();
                    dir.listFiles(new FileFilter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean accept(File f) {
                            try {
                                URI entryURI = f.toURI();
                                String entryPath = baseURI.relativize(entryURI).getPath();
                                if (entryPath.equals("META-INF/MANIFEST.MF")) {
                                    return false;
                                }
                                jos.putNextEntry(new JarEntry(entryPath));
                                if (f.isDirectory()) {
                                    f.listFiles(this);
                                } else {
                                    FileInputStream in = new FileInputStream(f);
                                    try {
                                        JarHelper.copy(in, jos, buf);
                                    }
                                    finally {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                jos.closeEntry();
                            }
                            catch (IOException e) {
                                logger.logp(Level.WARNING, "JarHelper", "makeJar", "Exception occurred", e);
                                throw new RuntimeException(e);
                            }
                            return false;
                        }
                    });
                    jos.close();
                    pos.close();
                    if (action != null) {
                        action.run();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
        return pis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out, ByteBuffer byteBuffer) throws IOException {
        try {
            int read;
            ReadableByteChannel inChannel = Channels.newChannel(in);
            WritableByteChannel outChannel = Channels.newChannel(out);
            do {
                if ((read = inChannel.read(byteBuffer)) <= 0) continue;
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.rewind();
                int written = 0;
                while ((written += outChannel.write(byteBuffer)) < read) {
                }
                logger.logp(Level.FINE, "JarHelper", "write", "Copied {0} bytes", new Object[]{read});
                byteBuffer.clear();
            } while (read != -1);
        }
        finally {
            byteBuffer.clear();
        }
    }

    public static interface Visitor {
        public void visit(JarEntry var1);
    }
}

