/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class WebConnectionImpl
implements WebConnection {
    private ServletInputStream inputStream;
    private ServletOutputStream outputStream;
    private Request request;
    private Response response;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public WebConnectionImpl(ServletInputStream inputStream, ServletOutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.isClosed.compareAndSet(false, true) && this.request != null && this.request.isUpgrade()) {
            Context context = this.request.getContext();
            HttpUpgradeHandler httpUpgradeHandler = this.request.getHttpUpgradeHandler();
            Exception exception = null;
            try {
                try {
                    context.fireContainerEvent("beforeUpgradeHandlerDestroyed", httpUpgradeHandler);
                    httpUpgradeHandler.destroy();
                }
                finally {
                    context.fireContainerEvent("afterUpgradeHandlerDestroyed", httpUpgradeHandler);
                }
                this.request.setUpgrade(false);
                if (this.response != null) {
                    this.response.setUpgrade(false);
                }
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (Exception ex) {
                    exception = ex;
                }
                try {
                    this.outputStream.close();
                }
                catch (Exception ex) {
                    exception = ex;
                }
                context.fireContainerEvent("predestroy", httpUpgradeHandler);
                this.request.resumeAfterService();
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public void setRequest(Request req) {
        this.request = req;
    }

    public void setResponse(Response res) {
        this.response = res;
    }
}

