/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public final class ConfigBeanRegistry {
    private final ConcurrentMap<ConfigBean, MBeanInstance> mFromConfigBean = new ConcurrentHashMap<ConfigBean, MBeanInstance>();
    private final ConcurrentMap<ObjectName, MBeanInstance> mFromObjectName = new ConcurrentHashMap<ObjectName, MBeanInstance>();
    private static final ConfigBeanRegistry INSTANCE = new ConfigBeanRegistry();

    private static void debug(String s) {
        System.out.println(s);
    }

    private ConfigBeanRegistry() {
    }

    public static ConfigBeanRegistry getInstance() {
        return INSTANCE;
    }

    private MBeanInstance getMBeanInstance(ObjectName objectName) {
        return (MBeanInstance)this.mFromObjectName.get(objectName);
    }

    private MBeanInstance getMBeanInstance(ConfigBean cb) {
        return (MBeanInstance)this.mFromConfigBean.get(cb);
    }

    public synchronized void add(ConfigBean cb, ObjectName objectName, Object impl) {
        MBeanInstance mb = new MBeanInstance(cb, objectName, impl);
        this.mFromConfigBean.put(cb, mb);
        this.mFromObjectName.put(objectName, mb);
    }

    public synchronized void remove(ObjectName objectName) {
        MBeanInstance mb = (MBeanInstance)this.mFromObjectName.get(objectName);
        if (mb != null) {
            this.mFromObjectName.remove(objectName);
            this.mFromConfigBean.remove(mb.mConfigBean);
        }
    }

    public ConfigBean getConfigBean(ObjectName objectName) {
        MBeanInstance mb = this.getMBeanInstance(objectName);
        return mb == null ? null : mb.mConfigBean;
    }

    public ObjectName getObjectName(ConfigBean cb) {
        MBeanInstance mb = this.getMBeanInstance(cb);
        return mb == null ? null : mb.mObjectName;
    }

    public Object getImpl(ObjectName objectName) {
        MBeanInstance mb = this.getMBeanInstance(objectName);
        return mb == null ? null : mb.mImpl;
    }

    public Object getImpl(ConfigBean cb) {
        MBeanInstance mb = this.getMBeanInstance(cb);
        return cb == null ? null : mb.mImpl;
    }

    public ObjectName getObjectNameForProxy(ConfigBeanProxy cbp) {
        Dom dom = Dom.unwrap((ConfigBeanProxy)cbp);
        if (dom instanceof ConfigBean) {
            return this.getObjectName((ConfigBean)dom);
        }
        return null;
    }

    public static final class MBeanInstance {
        public final ConfigBean mConfigBean;
        public final ObjectName mObjectName;
        public final Object mImpl;

        public MBeanInstance(ConfigBean cb, ObjectName on, Object impl) {
            this.mConfigBean = cb;
            this.mObjectName = on;
            this.mImpl = impl;
        }
    }
}

