/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.startup.CatalinaProperties;

public final class SecurityConfig {
    private static volatile SecurityConfig singleton = null;
    private static final Logger log = LogFacade.getLogger();
    private static final String PACKAGE_ACCESS = "sun.,org.apache.catalina.,org.apache.jasper.,org.glassfish.grizzly.tcp.,org.glassfish.grizzly.";
    private static final String PACKAGE_DEFINITION = "java.,sun.,org.apache.catalina.,org.glassfish.grizzly.tcp.,org.glassfish.grizzly.,org.apache.jasper.";
    private String packageDefinition;
    private String packageAccess;

    private SecurityConfig() {
        block2: {
            try {
                this.packageDefinition = CatalinaProperties.getProperty("package.definition");
                this.packageAccess = CatalinaProperties.getProperty("package.access");
            }
            catch (Exception ex) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "Unable to load properties using CatalinaProperties", ex);
            }
        }
    }

    public static SecurityConfig newInstance() {
        if (singleton == null) {
            singleton = new SecurityConfig();
        }
        return singleton;
    }

    public void setPackageAccess() {
        if (this.packageAccess == null) {
            this.setSecurityProperty("package.access", PACKAGE_ACCESS);
        } else {
            this.setSecurityProperty("package.access", this.packageAccess);
        }
    }

    public void setPackageDefinition() {
        if (this.packageDefinition == null) {
            this.setSecurityProperty("package.definition", PACKAGE_DEFINITION);
        } else {
            this.setSecurityProperty("package.definition", this.packageDefinition);
        }
    }

    private final void setSecurityProperty(String properties, String packageList) {
        if (System.getSecurityManager() != null) {
            String definition = Security.getProperty(properties);
            if (definition != null && definition.length() > 0) {
                definition = definition + ",";
            }
            Security.setProperty(properties, definition + packageList);
        }
    }
}

