/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.connector.MapElement;
import com.sun.enterprise.deployment.runtime.connector.Principal;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.RoleMap;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeDescriptorFactory {
    static Map descriptorClasses;

    protected RuntimeDescriptorFactory() {
    }

    private static void initMapping() {
        descriptorClasses = new HashMap();
        RuntimeDescriptorFactory.register(new XMLElement("resource-description"), ResourceReferenceDescriptor.class);
        RuntimeDescriptorFactory.register(new XMLElement("resource-env-description"), ResourceEnvReferenceDescriptor.class);
        RuntimeDescriptorFactory.register(new XMLElement("ejb-reference-description"), EjbReference.class);
        RuntimeDescriptorFactory.register(new XMLElement("principal"), Principal.class);
        RuntimeDescriptorFactory.register(new XMLElement("backend-principal"), Principal.class);
        RuntimeDescriptorFactory.register(new XMLElement("map-element"), MapElement.class);
        RuntimeDescriptorFactory.register(new XMLElement("role-map"), RoleMap.class);
        RuntimeDescriptorFactory.register(new XMLElement("resource-adapter"), ResourceAdapter.class);
    }

    public static void register(XMLElement xmlPath, Class clazz) {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Register " + clazz + " to handle " + xmlPath.getQName());
        }
        descriptorClasses.put(xmlPath.getQName(), clazz);
    }

    public static Class getDescriptorClass(String xmlPath) {
        String s = xmlPath;
        do {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
                DOLUtils.getDefaultLogger().finer("looking for " + xmlPath + " in " + descriptorClasses);
            }
            if (!descriptorClasses.containsKey(xmlPath)) continue;
            return (Class)descriptorClasses.get(xmlPath);
        } while ((xmlPath = xmlPath.indexOf(47) != -1 ? xmlPath.substring(xmlPath.indexOf(47) + 1) : null) != null);
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("No descriptor registered for " + s);
        }
        return null;
    }

    public static Object getDescriptor(String xmlPath) {
        try {
            Class c = RuntimeDescriptorFactory.getDescriptorClass(xmlPath);
            if (c != null) {
                return c.newInstance();
            }
        }
        catch (Throwable t) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error occurred", t);
        }
        return null;
    }

    static {
        RuntimeDescriptorFactory.initMapping();
    }
}

