/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=Lock.class)
public class LockHandler
extends AbstractAttributeHandler
implements PostProcessor<EjbContext> {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        Lock lockAnn = (Lock)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            if (!(ejbContext.getDescriptor() instanceof EjbSessionDescriptor)) continue;
            EjbSessionDescriptor singletonDesc = (EjbSessionDescriptor)ejbContext.getDescriptor();
            if (!singletonDesc.isSingleton()) {
                throw new AnnotationProcessorException("@Lock is only permitted for singleton session beans");
            }
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, (PostProcessor)this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            if (this.matchesExistingReadOrWriteLockMethod(annMethod, singletonDesc)) continue;
            MethodDescriptor newMethodDesc = new MethodDescriptor(annMethod);
            if (lockAnn.value() == LockType.WRITE) {
                singletonDesc.addWriteLockMethod(newMethodDesc);
                continue;
            }
            singletonDesc.addReadLockMethod(newMethodDesc);
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Singleton.class, ConcurrencyManagement.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    public void postProcessAnnotation(AnnotationInfo ainfo, EjbContext ejbContext) throws AnnotationProcessorException {
        EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)ejbContext.getDescriptor();
        Class classAn = (Class)ainfo.getAnnotatedElement();
        Lock lockAnn = (Lock)ainfo.getAnnotation();
        ArrayList<Method> toProcess = new ArrayList<Method>();
        for (Method m : ejbContext.getComponentDefinitionMethods()) {
            if (!classAn.equals(m.getDeclaringClass())) continue;
            toProcess.add(m);
        }
        for (Method m : classAn.getDeclaredMethods()) {
            if (!Modifier.isPrivate(m.getModifiers())) continue;
            toProcess.add(m);
        }
        for (Method m : toProcess) {
            if (this.matchesExistingReadOrWriteLockMethod(m, ejbDesc)) continue;
            MethodDescriptor newMethodDesc = new MethodDescriptor(m);
            if (lockAnn.value() == LockType.WRITE) {
                ejbDesc.addWriteLockMethod(newMethodDesc);
                continue;
            }
            ejbDesc.addReadLockMethod(newMethodDesc);
        }
    }

    private boolean matchesExistingReadOrWriteLockMethod(Method methodToMatch, EjbSessionDescriptor desc) {
        List<MethodDescriptor> lockMethods = desc.getReadAndWriteLockMethods();
        boolean match = false;
        for (MethodDescriptor next : lockMethods) {
            Method m = next.getMethod((EjbDescriptor)desc);
            if (!m.getDeclaringClass().equals(methodToMatch.getDeclaringClass()) || !TypeUtil.sameMethodSignature((Method)m, (Method)methodToMatch)) continue;
            match = true;
            break;
        }
        return match;
    }
}

