/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.Signal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class AliveAndReadyViewImpl
implements AliveAndReadyView {
    private Signal signal;
    private long signalTime;
    private SortedSet<String> members;
    private final long viewId;
    private final long creationTime;

    public AliveAndReadyViewImpl(SortedSet<String> members, long viewId) {
        this.members = new TreeSet<String>(members);
        this.viewId = viewId;
        this.creationTime = System.currentTimeMillis();
        this.signal = null;
        this.signalTime = -1L;
    }

    public void setSignal(Signal signal) {
        if (signal == null) {
            throw new NullPointerException("setSignal: parameter signal is not allowed to be set to null");
        }
        this.signal = signal;
        this.signalTime = System.currentTimeMillis();
    }

    public Signal getSignal() {
        return this.signal;
    }

    public synchronized SortedSet<String> getMembers() {
        return Collections.unmodifiableSortedSet(this.members);
    }

    synchronized void clearMembers() {
        this.members = new TreeSet<String>();
    }

    synchronized void setMembers(SortedSet<String> members) {
        this.members = members;
    }

    public long getSignalTime() {
        return this.signalTime;
    }

    public long getViewId() {
        return this.viewId;
    }

    public long getViewCreationTime() {
        return this.creationTime;
    }

    public long getViewDuration() {
        long duration = this.signal != null ? this.signalTime - this.creationTime : System.currentTimeMillis() - this.creationTime;
        return duration;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AliveAndReadyView  ViewId:").append(this.viewId);
        if (this.signal == null) {
            sb.append(" View created at ").append(MessageFormat.format("{0,date} {0,time,full}", this.creationTime));
        } else {
            sb.append(" Signal:").append(this.signal.getClass().getSimpleName());
            sb.append(" Duration(ms):").append(this.getViewDuration());
            sb.append(" View terminated at ").append(MessageFormat.format("{0,date} {0,time,full}", this.signalTime));
        }
        if (this.members != null) {
            int size = this.members.size();
            sb.append(" Members[").append(size).append("]:[");
            for (String member : this.members) {
                sb.append(member).append(",");
            }
            if (size != 0) {
                sb.setCharAt(sb.length() - 1, ']');
            } else {
                sb.append("]");
            }
        }
        return sb.toString();
    }
}

