/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeSerializer;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.SqlDateTypeSerializer;

public abstract class AbstractDateTypeSerializer<T extends Date>
extends AbstractDateTimeSerializer<T> {
    public AbstractDateTypeSerializer(Customization customization) {
        super(customization);
    }

    @Override
    protected Instant toInstant(Date value) {
        return Instant.ofEpochMilli(value.getTime());
    }

    @Override
    protected String formatDefault(Date value, Locale locale) {
        DateTimeFormatter formatter = this.getDefaultFormatter();
        if (value instanceof java.sql.Date) {
            formatter = SqlDateTypeSerializer.DEFAULT_FORMATTER;
        }
        return formatter.withLocale(locale).format(this.toInstant(value));
    }

    @Override
    protected String formatWithFormatter(Date value, DateTimeFormatter formatter) {
        return this.getZonedFormatter(formatter).format(this.toTemporalAccessor(value));
    }

    @Override
    protected String formatStrictIJson(Date value) {
        return JsonbDateFormatter.IJSON_DATE_FORMATTER.withZone(UTC).format(this.toTemporalAccessor(value));
    }

    @Override
    protected TemporalAccessor toTemporalAccessor(Date object) {
        return this.toInstant(object);
    }

    protected abstract DateTimeFormatter getDefaultFormatter();
}

