/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

final class ServiceFactoryUtils {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String[] EMPTY_ARRAY = new String[0];

    ServiceFactoryUtils() {
    }

    static Object getProviderFromEntry(String entry, Class<?>[] argumentTypes, Object[] arguments) {
        if (entry == null) {
            return null;
        }
        try {
            Class clazz = Util.loadClass(entry, null);
            Constructor c = clazz.getDeclaredConstructor(argumentTypes);
            if (c == null) {
                throw new FacesException("Unable to find constructor accepting arguments: " + Arrays.toString(arguments));
            }
            return c.newInstance(arguments);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | FacesException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.toString(), e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getServiceEntries(String key) {
        String serviceName;
        Enumeration<URL> urls;
        ArrayList<String> results;
        block27: {
            results = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return EMPTY_ARRAY;
            }
            urls = null;
            serviceName = "META-INF/services/" + key;
            try {
                urls = loader.getResources(serviceName);
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block27;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        if (urls != null) {
            InputStream input = null;
            BufferedReader reader = null;
            while (urls.hasMoreElements()) {
                try {
                    if (results == null) {
                        results = new ArrayList<String>();
                    }
                    URL url = urls.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    input = conn.getInputStream();
                    if (input == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                    }
                    catch (Exception e) {
                        reader = new BufferedReader(new InputStreamReader(input));
                    }
                    String line = reader.readLine();
                    while (line != null) {
                        results.add(line.trim());
                        line = reader.readLine();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "jsf.spi.provider.cannot_read_service", new Object[]{serviceName});
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                finally {
                    block28: {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block28;
                                LOGGER.log(Level.FINEST, "Closing stream", e);
                            }
                        }
                    }
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.log(Level.FINEST, "Closing stream", e);
                    }
                }
            }
        }
        return results != null && !results.isEmpty() ? results.toArray(new String[results.size()]) : EMPTY_ARRAY;
    }
}

