/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.writer;

import com.sun.enterprise.admin.remote.ParamsWithPayload;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriter;
import com.sun.enterprise.util.StringUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;

public class MultipartProprietaryWriter
implements ProprietaryWriter {
    protected static final String BOUNDARY_BASE = "admfrmwrk_payload_";
    protected static final AtomicInteger boundary_int = new AtomicInteger();
    protected static final String EOL = "\r\n";
    protected static final String BOUNDERY_DELIMIT = "--";

    @Override
    public boolean isWriteable(Object entity) {
        if (entity instanceof ParamsWithPayload) {
            ParamsWithPayload pwp = (ParamsWithPayload)entity;
            return pwp.getPayloadOutbound() != null && pwp.getPayloadOutbound().size() > 0;
        }
        if (entity instanceof Payload.Outbound) {
            return ((Payload.Outbound)entity).size() > 0;
        }
        return false;
    }

    @Override
    public void writeTo(Object entity, final HttpURLConnection urlConnection) throws IOException {
        RestPayloadImpl.Outbound payload = null;
        ParameterMap parameters = null;
        ActionReport ar = null;
        if (entity instanceof ParamsWithPayload) {
            ParamsWithPayload pwp = (ParamsWithPayload)entity;
            payload = pwp.getPayloadOutbound();
            parameters = pwp.getParameters();
            ar = pwp.getActionReport();
        } else if (entity instanceof Payload.Outbound) {
            payload = (Payload.Outbound)entity;
        }
        this.writeTo((Payload.Outbound)payload, parameters, ar, new OutputStream(){
            private OutputStream delegate;

            private OutputStream getDelegate() throws IOException {
                if (this.delegate == null) {
                    this.delegate = urlConnection.getOutputStream();
                }
                return this.delegate;
            }

            @Override
            public void write(int b) throws IOException {
                this.getDelegate().write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.getDelegate().write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.getDelegate().write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.getDelegate().flush();
            }

            @Override
            public void close() throws IOException {
                this.getDelegate().close();
            }
        }, new ContentTypeWriter(){

            @Override
            public void writeContentType(String firstPart, String secondPart, String boundary) {
                StringBuilder ct = new StringBuilder();
                ct.append(firstPart).append('/').append(secondPart);
                if (boundary != null) {
                    ct.append("; boundary=").append(boundary);
                }
                urlConnection.addRequestProperty("Content-type", ct.toString());
                urlConnection.setRequestProperty("MIME-Version", "1.0");
            }
        });
    }

    protected void writeParam(Writer writer, OutputStream underOS, String boundary, String key, String value) throws IOException {
        MultipartProprietaryWriter.multiWrite(writer, BOUNDERY_DELIMIT, boundary, EOL);
        MultipartProprietaryWriter.multiWrite(writer, "Content-Disposition: form-data; name=\"", key, "\"", EOL);
        MultipartProprietaryWriter.multiWrite(writer, EOL, value, EOL);
        writer.flush();
    }

    protected void writePayloadPart(Writer writer, OutputStream underOS, String boundary, Payload.Part part) throws IOException {
        MultipartProprietaryWriter.multiWrite(writer, BOUNDERY_DELIMIT, boundary, EOL);
        MultipartProprietaryWriter.multiWrite(writer, "Content-Disposition: file; name=\"", part.getName(), "\"; filename=\"", part.getName(), "\"", EOL);
        if (StringUtils.ok((String)part.getContentType())) {
            MultipartProprietaryWriter.multiWrite(writer, "Content-Type: ", part.getContentType(), EOL);
        }
        for (Map.Entry<Object, Object> entry : part.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String lKey = key.toLowerCase(Locale.ENGLISH);
            if ("content-disposition".equals(lKey) || "content-type".equals(lKey)) continue;
            if (!"content-transfer-encoding".equals(lKey)) {
                key = "Content-" + key;
            }
            MultipartProprietaryWriter.multiWrite(writer, key, ": ", String.valueOf(entry.getValue()), EOL);
        }
        writer.write(EOL);
        writer.flush();
        part.copy(underOS);
        underOS.flush();
        writer.write(EOL);
    }

    protected void writeActionReport(Writer writer, OutputStream underOS, String boundary, ActionReport ar) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(Payload.Outbound payload, ParameterMap parameters, ActionReport ar, OutputStream os, ContentTypeWriter contentTypeWriter) throws IOException {
        String boundary = this.getBoundary();
        String ctType = "form-data";
        if (parameters == null || parameters.size() == 0) {
            ctType = "mixed";
        }
        contentTypeWriter.writeContentType("multipart", ctType, boundary);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    this.writeParam(writer, os, boundary, (String)entry.getKey(), value);
                }
            }
        }
        if (ar != null) {
            this.writeActionReport(writer, os, boundary, ar);
        }
        if (payload != null) {
            Iterator parts = payload.parts();
            while (parts.hasNext()) {
                this.writePayloadPart(writer, os, boundary, (Payload.Part)parts.next());
            }
        }
        MultipartProprietaryWriter.multiWrite(writer, BOUNDERY_DELIMIT, boundary, BOUNDERY_DELIMIT, EOL);
        ((Writer)writer).flush();
    }

    private String getBoundary() {
        return BOUNDARY_BASE + boundary_int.incrementAndGet();
    }

    protected static void multiWrite(Writer writer, String ... args) throws IOException {
        for (String arg : args) {
            writer.write(arg);
        }
    }

    public static interface ContentTypeWriter {
        public void writeContentType(String var1, String var2, String var3);
    }
}

